/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.ICategory;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.IDocumentTemplate;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.model.IPrescription;
import ch.elexis.core.model.IRecipe;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.builder.IArticleBuilder;
import ch.elexis.core.model.builder.IPrescriptionBuilder;
import ch.elexis.core.model.format.PersonFormatUtil;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.services.AbstractServiceTest;
import ch.elexis.core.services.AllServiceTests;
import ch.elexis.core.services.IContext;
import ch.elexis.core.services.IDocumentService;
import ch.elexis.core.services.IDocumentStore;
import ch.elexis.core.services.IMedicationService;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.internal.dto.CategoryDocumentDTO;
import ch.elexis.core.test.context.TestContext;
import ch.elexis.core.text.ITextPlugin;
import ch.elexis.core.types.ArticleTyp;
import ch.elexis.core.utils.OsgiServiceUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IDocumentServiceTest
extends AbstractServiceTest {
    private IDocumentService documentService;
    private IDocumentStore documentStore;
    private IDocumentTemplate documentTemplate;
    private IDocumentTemplate directTemplate;
    private ITextPlugin textPlugin;
    private IContext context;
    private IMedicationService medicationService;
    private List<IPrescription> createdPrescriptions;
    private IArticle localArticle;
    private IRecipe recipe;

    @Before
    public void before() throws ElexisException {
        this.textPlugin = (ITextPlugin)OsgiServiceUtil.getService(ITextPlugin.class).orElseThrow(() -> new IllegalStateException("No text plugin available"));
        this.documentStore = (IDocumentStore)OsgiServiceUtil.getService(IDocumentStore.class, (String)"(storeid=ch.elexis.data.store.brief)").orElseThrow(() -> new IllegalStateException("No service available"));
        this.documentService = (IDocumentService)OsgiServiceUtil.getService(IDocumentService.class).orElseThrow(() -> new IllegalStateException("No service available"));
        this.medicationService = (IMedicationService)OsgiServiceUtil.getService(IMedicationService.class).orElseThrow(() -> new IllegalStateException("No service available"));
        IDocumentTemplate document = (IDocumentTemplate)CoreModelServiceHolder.get().create(IDocumentTemplate.class);
        document.setTitle("TestPlaceholders");
        document.setMimeType("docx");
        document.setCategory((ICategory)new CategoryDocumentDTO("Vorlagen"));
        this.documentTemplate = (IDocumentTemplate)this.documentStore.saveDocument((IDocument)document, this.getClass().getResourceAsStream("/rsc/TestPlaceholders.docx"));
        document = (IDocumentTemplate)CoreModelServiceHolder.get().create(IDocumentTemplate.class);
        document.setTitle("TestDirectTemplates");
        document.setMimeType("docx");
        document.setCategory((ICategory)new CategoryDocumentDTO("Vorlagen"));
        this.directTemplate = (IDocumentTemplate)this.documentStore.saveDocument((IDocument)document, this.getClass().getResourceAsStream("/rsc/TestDirectTemplates.docx"));
        this.createTestMandantPatientFallBehandlung();
        this.context = ContextServiceHolder.get().createNamedContext("create_document_context");
        ((TestContext)this.context).setParent(null);
        this.createTestPrescriptions();
    }

    private void createTestPrescriptions() {
        this.localArticle = (IArticle)new IArticleBuilder(coreModelService, "test medication article", "1234567", ArticleTyp.EIGENARTIKEL).build();
        this.localArticle.setGtin("1111111000000");
        this.localArticle.setPackageSize(2);
        this.localArticle.setSellingSize(1);
        coreModelService.save((Identifiable)this.localArticle);
        this.createdPrescriptions = new ArrayList<IPrescription>();
        this.createdPrescriptions.add((IPrescription)new IPrescriptionBuilder(coreModelService, null, this.localArticle, (IPatient)this.testPatients.get(0), "0-1-1-0").entryType(EntryType.FIXED_MEDICATION).disposalComment("disposal comment").buildAndSave());
        this.createdPrescriptions.add((IPrescription)new IPrescriptionBuilder(coreModelService, null, this.localArticle, (IPatient)this.testPatients.get(0), "1-0-0-1").entryType(EntryType.SYMPTOMATIC_MEDICATION).dosageInstruction("dosage instruction").buildAndSave());
        this.createdPrescriptions.add((IPrescription)new IPrescriptionBuilder(coreModelService, null, this.localArticle, (IPatient)this.testPatients.get(0), "1-0-0-0").entryType(EntryType.RESERVE_MEDICATION).buildAndSave());
        this.createdPrescriptions.add((IPrescription)new IPrescriptionBuilder(coreModelService, null, this.localArticle, (IPatient)this.testPatients.get(0), "0-0-0-1").entryType(EntryType.FIXED_MEDICATION).buildAndSave());
        this.recipe = this.medicationService.createRecipe((IPatient)this.testPatients.get(0), this.createdPrescriptions);
    }

    @After
    public void after() {
        this.removeTestPrescriptions();
        ContextServiceHolder.get().releaseContext("create_document_context");
        this.cleanup();
        if (this.documentTemplate != null) {
            this.documentStore.removeDocument((IDocument)this.documentTemplate);
        }
        OsgiServiceUtil.ungetService((Object)this.documentService);
        OsgiServiceUtil.ungetService((Object)this.documentStore);
        OsgiServiceUtil.ungetService((Object)this.textPlugin);
    }

    private void removeTestPrescriptions() {
        coreModelService.remove((Identifiable)this.recipe);
        coreModelService.remove(this.createdPrescriptions);
        coreModelService.remove((Identifiable)this.localArticle);
    }

    @Test
    public void adressatValidation() throws Exception {
        Map validationResult = this.documentService.validateTemplate(this.documentTemplate, this.context);
        Assert.assertNotNull((Object)validationResult);
        Assert.assertFalse((boolean)((Boolean)validationResult.get("[Adressat.Vorname]")));
        this.context.setNamed("Adressat", this.testMandators.get(0));
        validationResult = this.documentService.validateTemplate(this.documentTemplate, this.context);
        Assert.assertNotNull((Object)validationResult);
        Assert.assertTrue((boolean)((Boolean)validationResult.get("[Adressat.Vorname]")));
        Assert.assertTrue((boolean)((Boolean)validationResult.get("[Adressat.Anschrift]")));
    }

    @Test
    public void adressatReplacement() throws Exception {
        this.context.setNamed("Adressat", this.testMandators.get(0));
        IDocument createdDocument = (IDocument)this.documentService.createDocument(this.documentTemplate, this.context).getObject();
        Assert.assertNotNull((Object)createdDocument);
        int foundCount = this.textPlugin.findCount("mandator1");
        Assert.assertTrue((foundCount > 0 ? 1 : 0) != 0);
        foundCount = this.textPlugin.findCount("Lieber");
        Assert.assertTrue((foundCount > 0 ? 1 : 0) != 0);
        foundCount = this.textPlugin.findCount("[Adressat.Anschrift]");
        Assert.assertTrue((foundCount == 0 ? 1 : 0) != 0);
        this.saveToTempFileAndDelete(createdDocument);
    }

    @Test
    public void patientReplacement() throws Exception {
        this.context.setTyped(this.testPatients.get(0));
        IDocument createdDocument = (IDocument)this.documentService.createDocument(this.documentTemplate, this.context).getObject();
        Assert.assertNotNull((Object)createdDocument);
        Assert.assertEquals(this.testPatients.get(0), (Object)createdDocument.getPatient());
        Assert.assertNotNull((Object)createdDocument.getCreated());
        Assert.assertEquals((Object)"docx", (Object)createdDocument.getMimeType());
        int foundCount = this.textPlugin.findCount("Armer");
        Assert.assertTrue((foundCount > 0 ? 1 : 0) != 0);
        foundCount = this.textPlugin.findCount(PersonFormatUtil.getDateOfBirth((IPerson)((IPerson)this.testPatients.get(0))));
        Assert.assertTrue((foundCount > 0 ? 1 : 0) != 0);
        this.saveToTempFileAndDelete(createdDocument);
    }

    @Test
    public void patientValidation() throws Exception {
        Map validationResult = this.documentService.validateTemplate(this.documentTemplate, this.context);
        Assert.assertNotNull((Object)validationResult);
        for (String key : validationResult.keySet()) {
            if (!key.startsWith("[Patient.")) continue;
            Assert.assertFalse((boolean)((Boolean)validationResult.get(key)));
        }
        this.context.setTyped(this.testPatients.get(0));
        validationResult = this.documentService.validateTemplate(this.documentTemplate, this.context);
        Assert.assertNotNull((Object)validationResult);
        for (String key : validationResult.keySet()) {
            if (!key.startsWith("[Patient.")) continue;
            Assert.assertTrue((boolean)((Boolean)validationResult.get(key)));
        }
    }

    @Test
    public void mandantReplacement() throws Exception {
        this.context.setTyped(this.testMandators.get(0));
        IDocument createdDocument = (IDocument)this.documentService.createDocument(this.documentTemplate, this.context).getObject();
        Assert.assertNotNull((Object)createdDocument);
        int foundCount = this.textPlugin.findCount("mandator1");
        Assert.assertTrue((foundCount > 0 ? 1 : 0) != 0);
        this.saveToTempFileAndDelete(createdDocument);
    }

    @Test
    public void directRezeptzeilenValidation() throws Exception {
        Map validationResult = this.documentService.validateTemplate(this.directTemplate, this.context);
        Assert.assertNotNull((Object)validationResult);
        for (String key : validationResult.keySet()) {
            if (!key.startsWith("[Rezept")) continue;
            Assert.assertFalse((boolean)((Boolean)validationResult.get(key)));
        }
        this.context.setTyped((Object)this.recipe);
        validationResult = this.documentService.validateTemplate(this.directTemplate, this.context);
        Assert.assertNotNull((Object)validationResult);
        for (String key : validationResult.keySet()) {
            if (!key.startsWith("[Rezept")) continue;
            Assert.assertTrue((boolean)((Boolean)validationResult.get(key)));
        }
    }

    @Test
    public void directRezeptzeilenReplacement() throws Exception {
        this.context.setTyped((Object)this.recipe);
        IDocument createdDocument = (IDocument)this.documentService.createDocument(this.directTemplate, this.context).getObject();
        Assert.assertNotNull((Object)createdDocument);
        this.saveToTempFileAndDelete(createdDocument);
        int foundCount = this.textPlugin.findCount("[Rezeptzeilen]");
        Assert.assertEquals((long)0L, (long)foundCount);
        foundCount = this.textPlugin.findCount("test medication article");
        Assert.assertTrue((foundCount > 0 ? 1 : 0) != 0);
    }

    @Test
    public void directRezeptzeilenExtReplacement() throws Exception {
        this.context.setTyped((Object)this.recipe);
        IDocument createdDocument = (IDocument)this.documentService.createDocument(this.directTemplate, this.context).getObject();
        Assert.assertNotNull((Object)createdDocument);
        this.saveToTempFileAndDelete(createdDocument);
        int foundCount = this.textPlugin.findCount("[RezeptzeilenExt]");
        Assert.assertEquals((long)0L, (long)foundCount);
        foundCount = this.textPlugin.findCount("disposal comment");
        Assert.assertTrue((foundCount > 0 ? 1 : 0) != 0);
    }

    @Test
    public void directMedikamentenlisteReplacement() throws Exception {
        this.context.setTyped((Object)this.recipe);
        IDocument createdDocument = (IDocument)this.documentService.createDocument(this.directTemplate, this.context).getObject();
        Assert.assertNotNull((Object)createdDocument);
        this.saveToTempFileAndDelete(createdDocument);
        int foundCount = this.textPlugin.findCount("[Medikamentenliste]");
        Assert.assertEquals((long)0L, (long)foundCount);
        foundCount = this.textPlugin.findCount("dosage instruction");
        Assert.assertTrue((foundCount > 0 ? 1 : 0) != 0);
    }

    @Test
    public void fallValidation() throws Exception {
        Map validationResult = this.documentService.validateTemplate(this.documentTemplate, this.context);
        Assert.assertNotNull((Object)validationResult);
        for (String key : validationResult.keySet()) {
            if (!key.startsWith("[Fall")) continue;
            Assert.assertFalse((boolean)((Boolean)validationResult.get(key)));
        }
        this.context.setTyped((Object)AllServiceTests.getCoverage());
        validationResult = this.documentService.validateTemplate(this.documentTemplate, this.context);
        Assert.assertNotNull((Object)validationResult);
        for (String key : validationResult.keySet()) {
            if (!key.startsWith("[Fall")) continue;
            Assert.assertTrue((boolean)((Boolean)validationResult.get(key)));
        }
    }

    @Test
    public void fallReplacement() throws Exception {
        this.context.setTyped((Object)AllServiceTests.getCoverage());
        IDocument createdDocument = (IDocument)this.documentService.createDocument(this.documentTemplate, this.context).getObject();
        Assert.assertNotNull((Object)createdDocument);
        this.saveToTempFileAndDelete(createdDocument);
        int foundCount = this.textPlugin.findCount("[Fall:-:-:Kostentraeger]");
        Assert.assertEquals((long)0L, (long)foundCount);
        foundCount = this.textPlugin.findCount("1234-5678");
        Assert.assertTrue((foundCount > 0 ? 1 : 0) != 0);
        foundCount = this.textPlugin.findCount("Test Organization");
        Assert.assertTrue((foundCount > 0 ? 1 : 0) != 0);
    }

    private void saveToTempFileAndDelete(IDocument document) throws IOException {
        File tempFile = File.createTempFile(document.getTitle(), ".docx");
        FileUtils.copyInputStreamToFile((InputStream)document.getContent(), (File)tempFile);
        tempFile.delete();
    }
}

