/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.ICustomService;
import ch.elexis.core.model.IDiagnosis;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IFreeTextDiagnosis;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IStockEntry;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.builder.IEncounterBuilder;
import ch.elexis.core.services.AbstractServiceTest;
import ch.elexis.core.services.AllServiceTests;
import ch.elexis.core.services.IBillingService;
import ch.elexis.core.services.IElexisEntityManager;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.InvoiceServiceHolder;
import ch.elexis.core.services.holder.StockServiceHolder;
import ch.elexis.core.types.ArticleTyp;
import ch.elexis.core.utils.OsgiServiceUtil;
import ch.rgw.tools.Money;
import ch.rgw.tools.Result;
import java.time.LocalDate;
import java.util.List;
import javax.persistence.EntityManager;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class IBillingServiceTest
extends AbstractServiceTest {
    private IBillingService billingService = (IBillingService)OsgiServiceUtil.getService(IBillingService.class).get();
    private static ICustomService customService;
    private static IArticle customArticle;
    private static IEncounter encounter;
    private static IStockEntry customArticleStockEntry;

    @BeforeClass
    public static void beforeClass() {
        customService = (ICustomService)coreModelService.create(ICustomService.class);
        customService.setText("test service");
        customService.setCode("1234");
        customService.setNetPrice(new Money(512));
        customService.setPrice(new Money(1024));
        coreModelService.save((Identifiable)customService);
        customArticle = (IArticle)coreModelService.create(IArticle.class);
        customArticle.setText("test article");
        customArticle.setGtin("0123456789012");
        customArticle.setTyp(ArticleTyp.EIGENARTIKEL);
        coreModelService.save((Identifiable)customArticle);
        customArticleStockEntry = StockServiceHolder.get().storeArticleInStock(StockServiceHolder.get().getDefaultStock(), customArticle);
        Assert.assertEquals((long)1L, (long)customArticleStockEntry.getCurrentStock());
        encounter = (IEncounter)new IEncounterBuilder(CoreModelServiceHolder.get(), AllServiceTests.getCoverage(), AllServiceTests.getMandator()).buildAndSave();
    }

    @AfterClass
    public static void afterClass() {
        CoreModelServiceHolder.get().remove((Identifiable)encounter);
    }

    @Before
    public void before() {
        this.createTestMandantPatientFallBehandlung();
        ContextServiceHolder.get().setActiveMandator((IMandator)this.testMandators.get(0));
    }

    @After
    public void after() {
        ContextServiceHolder.get().setActiveMandator(null);
        customArticleStockEntry.setCurrentStock(1);
        coreModelService.save((Identifiable)customArticleStockEntry);
        this.cleanup();
    }

    @Test
    public void billCustomService() throws InterruptedException {
        Result billed = this.billingService.bill((IBillable)customService, encounter, 1.0);
        Assert.assertTrue((String)((Result.msg)billed.getMessages().get(0)).getText(), (boolean)billed.isOK());
        List billedList = encounter.getBilled();
        Assert.assertEquals((long)1L, (long)billedList.size());
        Assert.assertEquals((double)1.0, (double)((IBilled)billedList.get(0)).getAmount(), (double)0.0);
        Assert.assertEquals((long)1024L, (long)((IBilled)billedList.get(0)).getPrice().getCents());
        EntityManager em = (EntityManager)((IElexisEntityManager)OsgiServiceUtil.getService(IElexisEntityManager.class).get()).getEntityManager(true);
        em.getTransaction().begin();
        int executeUpdate = em.createNativeQuery("UPDATE LEISTUNGEN SET DELETED='1' WHERE DELETED='0'").executeUpdate();
        Assert.assertEquals((long)1L, (long)executeUpdate);
        em.getTransaction().commit();
        billed = this.billingService.bill((IBillable)customService, encounter, 1.0);
        billedList = encounter.getBilled();
        Assert.assertFalse((boolean)((IBilled)billedList.get(0)).isDeleted());
        Assert.assertEquals((long)1L, (long)billedList.size());
        Assert.assertEquals((double)1.0, (double)((IBilled)billedList.get(0)).getAmount(), (double)0.0);
        Assert.assertEquals((long)1024L, (long)((IBilled)billedList.get(0)).getPrice().getCents());
        coreModelService.remove((Identifiable)billed.get());
    }

    @Test
    public void isNonEditableCoverageHasEndDate() {
        ContextServiceHolder.get().setActiveMandator((IMandator)this.testMandators.get(0));
        Result isEditable = this.billingService.isEditable((IEncounter)this.testEncounters.get(0));
        Assert.assertTrue((String)isEditable.toString(), (boolean)isEditable.isOK());
        ICoverage fall = ((IEncounter)this.testEncounters.get(0)).getCoverage();
        fall.setDateTo(LocalDate.now());
        coreModelService.save((Identifiable)fall);
        Result result = this.billingService.isEditable((IEncounter)this.testEncounters.get(0));
        Assert.assertFalse((String)result.toString(), (boolean)result.isOK());
    }

    @Test
    public void isNonEditableAsInvoiceIsSet() {
        ContextServiceHolder.get().setActiveUser(AllServiceTests.getUser());
        ContextServiceHolder.get().setActiveMandator((IMandator)this.testMandators.get(0));
        ConfigServiceHolder.get().set((IContact)ContextServiceHolder.get().getActiveUserContact().get(), "billing/strict", false);
        Result isEditable = this.billingService.isEditable((IEncounter)this.testEncounters.get(0));
        Assert.assertTrue((String)isEditable.toString(), (boolean)isEditable.isOK());
        IFreeTextDiagnosis diagnosis = (IFreeTextDiagnosis)coreModelService.create(IFreeTextDiagnosis.class);
        diagnosis.setDescription("test");
        diagnosis.setText("testText");
        coreModelService.save((Identifiable)diagnosis);
        ((IEncounter)this.testEncounters.get(0)).addDiagnosis((IDiagnosis)diagnosis);
        coreModelService.save((Identifiable)this.testEncounters.get(0));
        Result invoice = InvoiceServiceHolder.get().invoice(this.testEncounters);
        Assert.assertTrue((String)invoice.toString(), (boolean)invoice.isOK());
        Result result = this.billingService.isEditable((IEncounter)this.testEncounters.get(0));
        Assert.assertFalse((String)result.toString(), (boolean)result.isOK());
    }

    @Test
    public void billArticleAndDecrementStock() {
        Result billed = this.billingService.bill((IBillable)customArticle, encounter, 1.0);
        Assert.assertTrue((String)((Result.msg)billed.getMessages().get(0)).getText(), (boolean)billed.isOK());
        CoreModelServiceHolder.get().remove((Identifiable)billed.get());
        IStockEntry stockEntry = StockServiceHolder.get().findStockEntryForArticleInStock(StockServiceHolder.get().getDefaultStock(), customArticle);
        Assert.assertEquals((long)0L, (long)stockEntry.getCurrentStock());
    }

    @Test
    public void changeAmountCorrectlyModifiesStock() {
        customArticleStockEntry.setCurrentStock(8);
        coreModelService.save((Identifiable)customArticleStockEntry);
        Result billed = this.billingService.bill((IBillable)customArticle, encounter, 1.0);
        Assert.assertTrue((String)((Result.msg)billed.getMessages().get(0)).getText(), (boolean)billed.isOK());
        this.billingService.changeAmountValidated((IBilled)billed.get(), 4.0);
        IStockEntry stockEntry = StockServiceHolder.get().findStockEntryForArticleInStock(StockServiceHolder.get().getDefaultStock(), customArticle);
        Assert.assertEquals((long)4L, (long)stockEntry.getCurrentStock());
        this.billingService.changeAmountValidated((IBilled)billed.get(), 3.0);
        stockEntry = StockServiceHolder.get().findStockEntryForArticleInStock(StockServiceHolder.get().getDefaultStock(), customArticle);
        Assert.assertEquals((long)5L, (long)stockEntry.getCurrentStock());
        CoreModelServiceHolder.get().remove((Identifiable)billed.get());
    }

    @Test
    public void billSellingSizeSmallerPackageSize() {
        IArticle customArticle_2 = (IArticle)coreModelService.create(IArticle.class);
        customArticle_2.setText("Actimove Gilchrist Plus");
        customArticle_2.setTyp(ArticleTyp.EIGENARTIKEL);
        customArticle_2.setPackageSize(10);
        customArticle_2.setSellingPrice(new Money(6350));
        customArticle_2.setSellingSize(1);
        coreModelService.save((Identifiable)customArticle_2);
        Result billed = this.billingService.bill((IBillable)customArticle_2, encounter, 1.0);
        Assert.assertTrue((String)((Result.msg)billed.getMessages().get(0)).getText(), (boolean)billed.isOK());
        double billed_amount = ((IBilled)billed.get()).getAmount();
        double billed_price = ((IBilled)billed.get()).getPrice().getCents();
        coreModelService.remove((Identifiable)billed.get());
        coreModelService.remove((Identifiable)customArticle_2);
        Assert.assertEquals((double)1.0, (double)billed_amount, (double)0.1);
        Assert.assertEquals((double)new Money(635).getCents(), (double)billed_price, (double)0.1);
    }
}

