/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.model.IAppointment;
import ch.elexis.core.model.IAppointmentSeries;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.agenda.Area;
import ch.elexis.core.model.agenda.AreaType;
import ch.elexis.core.model.agenda.EndingType;
import ch.elexis.core.model.agenda.SeriesType;
import ch.elexis.core.model.builder.IAppointmentBuilder;
import ch.elexis.core.services.AbstractServiceTest;
import ch.elexis.core.services.IAppointmentService;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.types.AppointmentState;
import ch.elexis.core.types.AppointmentType;
import ch.elexis.core.utils.OsgiServiceUtil;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.TemporalAdjusters;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class IAppointmentServiceTest
extends AbstractServiceTest {
    private IAppointmentService appointmentService = (IAppointmentService)OsgiServiceUtil.getService(IAppointmentService.class).get();
    private IAppointment savedAppointment;

    @BeforeClass
    public static void beforeClass() {
        IConfigService iConfigService = (IConfigService)OsgiServiceUtil.getService(IConfigService.class).get();
        iConfigService.set("agenda/bereiche", "Notfall,MPA,OP,Arzt 1,Arzt 2");
        iConfigService.set("agenda/bereich/Arzt 1/type", "CONTACT/be5370812884c8fc5019123");
        iConfigService.set("agenda/TerminTypen", "frei,gesperrt,Notfall,Selbstzahler,Neuer Pat,Kontrolle,Termin,Checkup,OP,24h-BD / ApneaLink,Medicosearch,Sperrung,Sitzung,Reminder,Sonografie");
        String blockedTimes = "FS1~#<ASa=A0000-0800\n1200-2359~#<ADo=A0000-0800\n1800-2359~#<AFr=A0000-0800\n1800-2359~#<AMi=A0000-0800\n1800-2359~#<ADi=A0000-0730\n1900-2359~#<AMo=A0000-0800\n1800-2359~#<ASo=A0000-2359";
        iConfigService.set("agenda/tagesvorgaben/Greta", blockedTimes);
        iConfigService.set("agenda/tagesvorgaben/Dr. Invalid Block", "FS1~#<ASa=A0000-2359~#<ADo=A0000-0800\n1100-2359~#<AFr=A0000-0800\n1000-1015\n\n1200-1330\n1500-1515\n\n1700-2359~#<AMi=A0000-0800\n1000-1015\n\n1200-1330\n1500-1515\n\n1700-2359~#<ADi=A0000-0800\n1200-1330\n1500-1515\n1700-2359~#<AMo=A0000-2359~#<ASo=A0000-2359");
    }

    @Before
    public void before() {
        this.savedAppointment = (IAppointment)new IAppointmentBuilder(coreModelService, "Notfall", LocalDateTime.of(2018, 1, 2, 9, 0), LocalDateTime.of(2018, 1, 2, 9, 30), this.appointmentService.getType(AppointmentType.BOOKED), this.appointmentService.getState(AppointmentState.DEFAULT)).buildAndSave();
    }

    @After
    public void after() {
        coreModelService.remove(coreModelService.getQuery(IAppointment.class).execute());
        Assert.assertEquals((long)0L, (long)coreModelService.getQuery(IAppointment.class).execute().size());
    }

    @Test
    public void testCommon() {
        Optional load = coreModelService.load(this.savedAppointment.getId(), IAppointment.class);
        Assert.assertTrue((boolean)load.isPresent());
        Assert.assertEquals((long)30L, (long)((IAppointment)load.get()).getDurationMinutes().intValue());
        Assert.assertEquals((Object)this.appointmentService.getType(AppointmentType.BOOKED), (Object)((IAppointment)load.get()).getType());
        Assert.assertEquals((long)1L, (long)coreModelService.getQuery(IAppointment.class).execute().size());
        Assert.assertEquals((long)15L, (long)this.appointmentService.getTypes().size());
    }

    @Test
    public void getConfiguredBlockTimesBySchedule() {
        Map configuredBlockTimes = this.appointmentService.getConfiguredBlockTimesBySchedule("Greta");
        Assert.assertEquals((long)7L, (long)configuredBlockTimes.size());
        Object[] wednesday = (String[])configuredBlockTimes.get(DayOfWeek.WEDNESDAY);
        Assert.assertArrayEquals((Object[])new String[]{"0000-0800", "1800-2359"}, (Object[])wednesday);
        Object[] tuesday = (String[])configuredBlockTimes.get(DayOfWeek.TUESDAY);
        Assert.assertArrayEquals((Object[])new String[]{"0000-0730", "1900-2359"}, (Object[])tuesday);
        configuredBlockTimes = this.appointmentService.getConfiguredBlockTimesBySchedule("Dr. Bakterius");
        Assert.assertEquals((long)7L, (long)configuredBlockTimes.size());
        Object[] monday = (String[])configuredBlockTimes.get(DayOfWeek.MONDAY);
        Assert.assertArrayEquals((Object[])new String[]{"0000-0800", "1800-2359"}, (Object[])monday);
        tuesday = (String[])configuredBlockTimes.get(DayOfWeek.TUESDAY);
        Assert.assertArrayEquals((Object[])new String[]{"0000-0800", "1800-2359"}, (Object[])tuesday);
    }

    @Test
    public void assertBlockTimes() {
        this.savedAppointment.setType("OP");
        coreModelService.save((Identifiable)this.savedAppointment);
        this.appointmentService.assertBlockTimes(LocalDate.of(2018, 1, 2), "Notfall");
        IQuery query = coreModelService.getQuery(IAppointment.class);
        query.and("tag", IQuery.COMPARATOR.EQUALS, (Object)LocalDate.of(2018, 1, 2), false);
        List results = query.execute();
        Assert.assertEquals((long)3L, (long)results.size());
        results = results.stream().sorted((p1, p2) -> p1.getStartTime().compareTo(p2.getStartTime())).collect(Collectors.toList());
        Assert.assertEquals((Object)LocalDateTime.of(2018, 1, 2, 0, 0), (Object)((IAppointment)results.get(0)).getStartTime());
        Assert.assertEquals((Object)LocalDateTime.of(2018, 1, 2, 8, 0), (Object)((IAppointment)results.get(0)).getEndTime());
        Assert.assertEquals((Object)LocalDateTime.of(2018, 1, 2, 9, 0), (Object)((IAppointment)results.get(1)).getStartTime());
        Assert.assertEquals((Object)LocalDateTime.of(2018, 1, 2, 9, 30), (Object)((IAppointment)results.get(1)).getEndTime());
        Assert.assertEquals((Object)LocalDateTime.of(2018, 1, 2, 18, 0), (Object)((IAppointment)results.get(2)).getStartTime());
        Assert.assertEquals((Object)LocalDateTime.of(2018, 1, 2, 23, 59), (Object)((IAppointment)results.get(2)).getEndTime());
        IllegalArgumentException exception = null;
        try {
            this.appointmentService.assertBlockTimes(LocalDate.of(2025, 2, 24), "Dr. Invalid Block");
            this.appointmentService.assertBlockTimes(LocalDate.of(2025, 2, 25), "Dr. Invalid Block");
            this.appointmentService.assertBlockTimes(LocalDate.of(2025, 2, 26), "Dr. Invalid Block");
            this.appointmentService.assertBlockTimes(LocalDate.of(2025, 2, 27), "Dr. Invalid Block");
        }
        catch (IllegalArgumentException e) {
            exception = e;
        }
        Assert.assertNotNull((Object)exception);
    }

    @Test
    public void testUpdateNoBoundaries() {
        Assert.assertEquals((long)1L, (long)coreModelService.getQuery(IAppointment.class).execute().size());
        this.appointmentService.assertBlockTimes(LocalDate.of(2018, 1, 2), "Notfall");
        Assert.assertEquals((long)1L, (long)coreModelService.getQuery(IAppointment.class).execute().size());
    }

    @Test
    public void testClone() {
        IAppointment cloned = this.appointmentService.clone(this.savedAppointment);
        Assert.assertNotNull((Object)cloned.getId());
        Assert.assertNotEquals((Object)this.savedAppointment.getId(), (Object)cloned.getId());
        Assert.assertEquals((Object)this.savedAppointment.getSubjectOrPatient(), (Object)cloned.getSubjectOrPatient());
        Assert.assertEquals((Object)this.savedAppointment.getStartTime(), (Object)cloned.getStartTime());
        Assert.assertEquals((Object)this.savedAppointment.getEndTime(), (Object)cloned.getEndTime());
        Assert.assertEquals((Object)this.savedAppointment.getType(), (Object)cloned.getType());
        Assert.assertEquals((Object)this.savedAppointment.getState(), (Object)cloned.getState());
        Assert.assertEquals((long)this.savedAppointment.getPriority(), (long)cloned.getPriority());
    }

    @Test
    public void testDelete() {
        Assert.assertEquals((long)1L, (long)coreModelService.getQuery(IAppointment.class).execute().size());
        this.appointmentService.delete(this.savedAppointment, false);
        Assert.assertEquals((long)0L, (long)coreModelService.getQuery(IAppointment.class).execute().size());
    }

    @Test
    public void series() {
        LocalDate previousMonday = LocalDate.now().with(TemporalAdjusters.previous(DayOfWeek.MONDAY));
        LocalDateTime seriesStart = previousMonday.atTime(10, 30);
        LocalTime seriesEnd = LocalTime.of(11, 0);
        IAppointmentSeries series = this.appointmentService.createAppointmentSeries();
        series.setStartTime(seriesStart);
        series.setSeriesEndTime(seriesEnd);
        series.setReason("test");
        series.setSeriesType(SeriesType.WEEKLY);
        series.setSeriesPatternString("1,246");
        series.setEndingType(EndingType.AFTER_N_OCCURENCES);
        series.setEndingPatternString("2");
        List appointments = this.appointmentService.saveAppointmentSeries(series);
        Assert.assertNotNull((Object)appointments);
        Assert.assertEquals((long)6L, (long)appointments.size());
        Assert.assertTrue((((IAppointment)appointments.get(0)).isRecurring() && ((IAppointment)appointments.get(3)).isRecurring() ? 1 : 0) != 0);
        Assert.assertEquals((Object)"test", (Object)((IAppointment)appointments.get(0)).getReason());
        Assert.assertEquals((Object)"test", (Object)((IAppointment)appointments.get(3)).getReason());
        this.appointmentService.delete((IAppointment)appointments.get(0), false);
        Assert.assertTrue((((IAppointment)appointments.get(0)).isRecurring() && ((IAppointment)appointments.get(3)).isRecurring() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((IAppointment)appointments.get(0)).isDeleted());
        Assert.assertFalse((boolean)((IAppointment)appointments.get(3)).isDeleted());
        this.appointmentService.delete((IAppointment)appointments.get(3), true);
        Assert.assertTrue((boolean)series.getAppointments().isEmpty());
        Assert.assertTrue((boolean)((IAppointment)appointments.get(2)).isDeleted());
        Assert.assertTrue((boolean)((IAppointment)appointments.get(3)).isDeleted());
        Assert.assertTrue((boolean)((IAppointment)appointments.get(4)).isDeleted());
    }

    @Test
    public void setAreaType() {
        this.appointmentService.setAreaType("Arzt 1", AreaType.GENERIC, null);
        this.appointmentService.setAreaType("Notfall", AreaType.CONTACT, "be5370812884c8fc5019123");
        List areas = this.appointmentService.getAreas();
        Assert.assertEquals((long)5L, (long)areas.size());
        for (Area area : areas) {
            if ("Notfall".equals(area.getName())) {
                Assert.assertEquals((Object)AreaType.CONTACT, (Object)area.getType());
                Assert.assertEquals((Object)"be5370812884c8fc5019123", (Object)area.getContactId());
                continue;
            }
            Assert.assertEquals((Object)AreaType.GENERIC, (Object)area.getType());
        }
        this.appointmentService.setAreaType("Notfall", AreaType.GENERIC, null);
        this.appointmentService.setAreaType("Arzt 1", AreaType.CONTACT, "be5370812884c8fc5019123");
    }

    @Test
    public void getAreas() {
        List areas = this.appointmentService.getAreas();
        Assert.assertEquals((long)5L, (long)areas.size());
        for (Area area : areas) {
            if ("Arzt 1".equals(area.getName())) {
                Assert.assertEquals((Object)AreaType.CONTACT, (Object)area.getType());
                Assert.assertEquals((Object)"be5370812884c8fc5019123", (Object)area.getContactId());
                continue;
            }
            Assert.assertEquals((Object)AreaType.GENERIC, (Object)area.getType());
        }
    }

    @Test
    public void getTransientFree() {
        LocalDate nextMonday = null;
        nextMonday = LocalDate.now().getDayOfWeek() == DayOfWeek.MONDAY ? LocalDate.now().plusWeeks(1L) : LocalDate.now().with(TemporalAdjusters.previous(DayOfWeek.MONDAY)).plusWeeks(1L);
        this.appointmentService.assertBlockTimes(nextMonday, "Notfall");
        List appointments = this.appointmentService.getAppointments("Notfall", nextMonday, true);
        Assert.assertNotNull((Object)appointments);
        Assert.assertEquals((long)3L, (long)appointments.size());
        Assert.assertEquals((Object)this.appointmentService.getType(AppointmentType.BOOKED), (Object)((IAppointment)appointments.get(0)).getType());
        Assert.assertEquals((Object)this.appointmentService.getType(AppointmentType.FREE), (Object)((IAppointment)appointments.get(1)).getType());
        Assert.assertEquals((Object)this.appointmentService.getType(AppointmentType.BOOKED), (Object)((IAppointment)appointments.get(2)).getType());
        Assert.assertFalse((boolean)this.appointmentService.isColliding((IAppointment)appointments.get(1)));
        IAppointment first = (IAppointment)new IAppointmentBuilder(coreModelService, "Notfall", nextMonday.atTime(9, 0), nextMonday.atTime(10, 0), this.appointmentService.getType(AppointmentType.BOOKED), this.appointmentService.getState(AppointmentState.DEFAULT)).buildAndSave();
        IAppointment second = (IAppointment)new IAppointmentBuilder(coreModelService, "Notfall", nextMonday.atTime(9, 30), nextMonday.atTime(10, 30), this.appointmentService.getType(AppointmentType.BOOKED), this.appointmentService.getState(AppointmentState.DEFAULT)).buildAndSave();
        appointments = this.appointmentService.getAppointments("Notfall", nextMonday, true);
        Assert.assertNotNull((Object)appointments);
        Assert.assertEquals((long)6L, (long)appointments.size());
        Assert.assertEquals((Object)this.appointmentService.getType(AppointmentType.BOOKED), (Object)((IAppointment)appointments.get(0)).getType());
        Assert.assertEquals((Object)this.appointmentService.getType(AppointmentType.FREE), (Object)((IAppointment)appointments.get(1)).getType());
        Assert.assertEquals((Object)this.appointmentService.getType(AppointmentType.BOOKED), (Object)((IAppointment)appointments.get(2)).getType());
        Assert.assertEquals((Object)this.appointmentService.getType(AppointmentType.BOOKED), (Object)((IAppointment)appointments.get(3)).getType());
        Assert.assertEquals((Object)this.appointmentService.getType(AppointmentType.FREE), (Object)((IAppointment)appointments.get(4)).getType());
        Assert.assertEquals((Object)this.appointmentService.getType(AppointmentType.BOOKED), (Object)((IAppointment)appointments.get(5)).getType());
        Assert.assertFalse((boolean)this.appointmentService.isColliding((IAppointment)appointments.get(1)));
        Assert.assertFalse((boolean)this.appointmentService.isColliding((IAppointment)appointments.get(4)));
        LocalDateTime seriesStart = nextMonday.atTime(6, 0);
        LocalTime seriesEnd = LocalTime.of(6, 30);
        IAppointmentSeries series = this.appointmentService.createAppointmentSeries();
        series.setSeriesStartTime(seriesStart.toLocalTime());
        series.setSeriesEndTime(seriesEnd);
        series.setSchedule("Notfall");
        series.setReason("test");
        series.setSeriesType(SeriesType.WEEKLY);
        series.setSeriesPatternString("1,2");
        series.setEndingType(EndingType.AFTER_N_OCCURENCES);
        series.setEndingPatternString("2");
        List seriesAppointments = this.appointmentService.saveAppointmentSeries(series);
        Assert.assertTrue((boolean)((IAppointment)seriesAppointments.get(1)).getStartTime().toLocalDate().equals(nextMonday));
        appointments = this.appointmentService.getAppointments("Notfall", nextMonday, true);
        Assert.assertNotNull((Object)appointments);
        Assert.assertEquals((long)7L, (long)appointments.size());
        Assert.assertEquals((Object)this.appointmentService.getType(AppointmentType.BOOKED), (Object)((IAppointment)appointments.get(0)).getType());
        Assert.assertEquals((Object)"series", (Object)((IAppointment)appointments.get(1)).getType());
        Assert.assertEquals((Object)this.appointmentService.getType(AppointmentType.FREE), (Object)((IAppointment)appointments.get(2)).getType());
        Assert.assertEquals((Object)this.appointmentService.getType(AppointmentType.BOOKED), (Object)((IAppointment)appointments.get(3)).getType());
        Assert.assertEquals((Object)this.appointmentService.getType(AppointmentType.BOOKED), (Object)((IAppointment)appointments.get(4)).getType());
        Assert.assertEquals((Object)this.appointmentService.getType(AppointmentType.FREE), (Object)((IAppointment)appointments.get(5)).getType());
        Assert.assertEquals((Object)this.appointmentService.getType(AppointmentType.BOOKED), (Object)((IAppointment)appointments.get(6)).getType());
        Assert.assertFalse((boolean)this.appointmentService.isColliding((IAppointment)appointments.get(2)));
        Assert.assertFalse((boolean)this.appointmentService.isColliding((IAppointment)appointments.get(5)));
    }
}

