/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core;

import ch.elexis.core.time.TimeUtil;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Month;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TimeUtilTest {
    private static DatatypeFactory dtf;

    @BeforeClass
    public static void beforeClass() throws DatatypeConfigurationException {
        dtf = DatatypeFactory.newInstance();
    }

    @Test
    public void testToLocalDateXMLGregorianCalendar() {
        XMLGregorianCalendar calendar = dtf.newXMLGregorianCalendar("2021-10-13T00:00:00.0Z");
        LocalDate result = TimeUtil.toLocalDate((XMLGregorianCalendar)calendar);
        LocalDate reference = LocalDate.of(2021, Month.OCTOBER, 13);
        Assert.assertEquals((Object)reference, (Object)result);
    }

    @Test
    public void testToLocalDateTimeXMLGregorianCalendar() {
        XMLGregorianCalendar calendar = dtf.newXMLGregorianCalendar("2021-10-13T05:49:44.303Z");
        LocalDateTime result = TimeUtil.toLocalDateTime((XMLGregorianCalendar)calendar);
        LocalDateTime reference = LocalDateTime.of(2021, Month.OCTOBER, 13, 7, 49, 44, 303000000);
        Assert.assertEquals((Object)reference, (Object)result);
    }

    @Test
    public void testToDateXMLGregorianCalendar() {
        XMLGregorianCalendar calendar = dtf.newXMLGregorianCalendar("2021-10-13T05:49:44.0Z");
        Date result = TimeUtil.toDate((XMLGregorianCalendar)calendar);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(2021, 9, 13, 7, 49, 44);
        Date reference = gregorianCalendar.getTime();
        Assert.assertEquals((Object)reference.toString(), (Object)result.toString());
    }
}

