/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.entities.Fall;
import ch.elexis.core.jpa.entities.Kontakt;
import ch.elexis.core.jpa.model.adapter.AbstractIdDeleteModelAdapter;
import ch.elexis.core.jpa.model.adapter.AbstractIdModelAdapter;
import ch.elexis.core.model.IAccountTransaction;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IInvoice;
import ch.elexis.core.model.IInvoiceBilled;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPayment;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.IdentifiableWithXid;
import ch.elexis.core.model.InvoiceState;
import ch.elexis.core.model.service.holder.CoreModelServiceHolder;
import ch.elexis.core.model.service.holder.StoreToStringServiceHolder;
import ch.elexis.core.model.util.ModelUtil;
import ch.elexis.core.services.INamedQuery;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.rgw.tools.Money;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.LoggerFactory;

public class Invoice
extends AbstractIdDeleteModelAdapter<ch.elexis.core.jpa.entities.Invoice>
implements IdentifiableWithXid,
IInvoice {
    public Invoice(ch.elexis.core.jpa.entities.Invoice entity) {
        super((EntityWithId)entity);
    }

    public Object getExtInfo(Object key) {
        return this.extInfoHandler.getExtInfo(key);
    }

    public void setExtInfo(Object key, Object value) {
        this.extInfoHandler.setExtInfo(key, value);
    }

    public Map<Object, Object> getMap() {
        return this.extInfoHandler.getMap();
    }

    public InvoiceState getState() {
        return ((ch.elexis.core.jpa.entities.Invoice)this.getEntity()).getState();
    }

    public void setState(InvoiceState value) {
        this.setStateDate(LocalDate.now());
        ((ch.elexis.core.jpa.entities.Invoice)this.getEntityMarkDirty()).setState(value);
        this.addTrace("Status\u00e4nderung", Integer.toString(value.numericValue()));
        ContextServiceHolder.get().getActiveUserContact().ifPresent(activeUserContact -> {
            String userDescription = String.format("%s %s", activeUserContact.getDescription1(), activeUserContact.getDescription2());
            this.addTrace("Mandator", userDescription);
        });
    }

    public String getNumber() {
        return ((ch.elexis.core.jpa.entities.Invoice)this.getEntity()).getNumber();
    }

    public IMandator getMandator() {
        return ch.elexis.core.model.util.internal.ModelUtil.getAdapter((EntityWithId)((ch.elexis.core.jpa.entities.Invoice)this.getEntity()).getMandator(), IMandator.class, true);
    }

    public void setMandator(IMandator value) {
        if (value != null) {
            ((ch.elexis.core.jpa.entities.Invoice)this.getEntityMarkDirty()).setMandator((Kontakt)((AbstractIdModelAdapter)value).getEntity());
        } else {
            ((ch.elexis.core.jpa.entities.Invoice)this.getEntityMarkDirty()).setMandator(null);
        }
    }

    public ICoverage getCoverage() {
        return ch.elexis.core.model.util.internal.ModelUtil.getAdapter((EntityWithId)((ch.elexis.core.jpa.entities.Invoice)this.getEntity()).getFall(), ICoverage.class);
    }

    public void setCoverage(ICoverage value) {
        if (value != null) {
            ((ch.elexis.core.jpa.entities.Invoice)this.getEntityMarkDirty()).setFall((Fall)((AbstractIdModelAdapter)value).getEntity());
        } else {
            ((ch.elexis.core.jpa.entities.Invoice)this.getEntityMarkDirty()).setFall(null);
        }
    }

    public List<IEncounter> getEncounters() {
        CoreModelServiceHolder.get().refresh((Identifiable)this);
        return ((ch.elexis.core.jpa.entities.Invoice)this.getEntity()).getEncounters().parallelStream().filter(b -> !b.isDeleted()).map(b -> ch.elexis.core.model.util.internal.ModelUtil.getAdapter((EntityWithId)b, IEncounter.class, true)).sorted((e1, e2) -> e1.getDate().compareTo(e2.getDate())).collect(Collectors.toList());
    }

    public List<IBilled> getBilled() {
        CoreModelServiceHolder.get().refresh((Identifiable)this);
        return ((ch.elexis.core.jpa.entities.Invoice)this.getEntity()).getInvoiceBilled().parallelStream().filter(b -> !b.isDeleted()).map(b -> ch.elexis.core.model.util.internal.ModelUtil.getAdapter((EntityWithId)b, IInvoiceBilled.class, true)).collect(Collectors.toList());
    }

    public void addTrace(String name, String value) {
        List<String> trace = this.getTrace(name);
        trace.add(String.valueOf(new TimeTool().toString(0)) + ": " + value);
        this.extInfoHandler.setExtInfo((Object)name, (Object)StringTool.pack(trace));
    }

    public List<String> getTrace(String name) {
        byte[] raw = (byte[])this.extInfoHandler.getExtInfo((Object)name);
        ArrayList trace = null;
        if (raw != null) {
            trace = StringTool.unpack((byte[])raw);
        }
        if (trace == null) {
            trace = new ArrayList();
        }
        return trace;
    }

    public LocalDate getDate() {
        return ((ch.elexis.core.jpa.entities.Invoice)this.getEntity()).getInvoiceDate();
    }

    public void setDate(LocalDate value) {
        ((ch.elexis.core.jpa.entities.Invoice)this.getEntityMarkDirty()).setInvoiceDate(value);
    }

    public LocalDate getDateFrom() {
        return ((ch.elexis.core.jpa.entities.Invoice)this.getEntity()).getInvoiceDateFrom();
    }

    public void setDateFrom(LocalDate value) {
        ((ch.elexis.core.jpa.entities.Invoice)this.getEntityMarkDirty()).setInvoiceDateFrom(value);
    }

    public LocalDate getDateTo() {
        return ((ch.elexis.core.jpa.entities.Invoice)this.getEntity()).getInvoiceDateTo();
    }

    public void setDateTo(LocalDate value) {
        ((ch.elexis.core.jpa.entities.Invoice)this.getEntityMarkDirty()).setInvoiceDateTo(value);
    }

    public Money getTotalAmount() {
        return ModelUtil.getMoneyForCentString((String)((ch.elexis.core.jpa.entities.Invoice)this.getEntity()).getAmount()).orElse(null);
    }

    public void setTotalAmount(Money value) {
        if (value != null) {
            ((ch.elexis.core.jpa.entities.Invoice)this.getEntityMarkDirty()).setAmount(value.getCentsAsString());
        } else {
            ((ch.elexis.core.jpa.entities.Invoice)this.getEntityMarkDirty()).setAmount(null);
        }
    }

    public Money getOpenAmount() {
        List<IPayment> payments = this.getPayments();
        Money total = this.getTotalAmount();
        for (IPayment payment : payments) {
            Money paymentAmount = payment.getAmount();
            total.subtractMoney(paymentAmount);
        }
        return new Money(total);
    }

    public Money getPayedAmount() {
        List<IPayment> payments = this.getPayments();
        Money total = new Money();
        for (IPayment payment : payments) {
            Money paymentAmount = payment.getAmount();
            if (paymentAmount.isNegative()) continue;
            total.addMoney(paymentAmount);
        }
        return total;
    }

    public List<IPayment> getPayments() {
        CoreModelServiceHolder.get().refresh((Identifiable)this);
        return ((ch.elexis.core.jpa.entities.Invoice)this.getEntity()).getPayments().stream().filter(p -> !p.isDeleted()).map(p -> ch.elexis.core.model.util.internal.ModelUtil.getAdapter((EntityWithId)p, IPayment.class, true)).collect(Collectors.toList());
    }

    public List<IAccountTransaction> getTransactions() {
        CoreModelServiceHolder.get().refresh((Identifiable)this);
        return ((ch.elexis.core.jpa.entities.Invoice)this.getEntity()).getTransactions().stream().filter(p -> !p.isDeleted()).map(p -> ch.elexis.core.model.util.internal.ModelUtil.getAdapter((EntityWithId)p, IAccountTransaction.class, true)).collect(Collectors.toList());
    }

    public String getRemark() {
        return (String)this.getExtInfo("Bemerkung");
    }

    public void setRemark(String value) {
        this.setExtInfo("Bemerkung", value);
    }

    public boolean adjustAmount(Money value) {
        int oldVal = this.getTotalAmount().getCents();
        if (oldVal != 0) {
            int newVal = value.getCents();
            int diff = Math.abs(oldVal - newVal);
            if (diff > 500 || diff * 50 > oldVal) {
                return false;
            }
            INamedQuery query = CoreModelServiceHolder.get().getNamedQuery(IAccountTransaction.class, new String[]{"invoice"});
            List openTransactions = query.executeWithParameters(query.getParameterMap(new Object[]{"invoice", this}));
            if ((openTransactions = openTransactions.stream().filter(transaction -> transaction.getPayment() == null).collect(Collectors.toList())) != null && openTransactions.size() == 1) {
                IAccountTransaction openTransaction = (IAccountTransaction)openTransactions.get(0);
                Money negBetrag = new Money(value);
                negBetrag.negate();
                openTransaction.setAmount(negBetrag);
            }
        }
        this.setTotalAmount(value);
        return true;
    }

    public void reject(InvoiceState.REJECTCODE rejectCode, String message) {
        this.setState(InvoiceState.DEFECTIVE);
        this.addTrace("Zur\u00fcckgewiesen", String.valueOf(rejectCode.toString()) + ", " + message);
    }

    public Money getDemandAmount() {
        List<IPayment> payments = this.getPayments();
        Money total = new Money();
        for (IPayment payment : payments) {
            Money paymentAmount = payment.getAmount();
            if (!paymentAmount.isNegative()) continue;
            total.addMoney(paymentAmount.negate());
        }
        return total;
    }

    public LocalDate getStateDate() {
        return ((ch.elexis.core.jpa.entities.Invoice)this.getEntity()).getStatusDate();
    }

    public void setStateDate(LocalDate value) {
        ((ch.elexis.core.jpa.entities.Invoice)this.getEntityMarkDirty()).setStatusDate(value);
    }

    private List<String> getAttachmentsInternal() {
        byte[] raw = (byte[])this.extInfoHandler.getExtInfo((Object)"Attachments");
        ArrayList<String> storeToStrings = null;
        if (raw != null) {
            storeToStrings = StringTool.unpack((byte[])raw);
        }
        if (storeToStrings == null || storeToStrings.isEmpty()) {
            storeToStrings = new ArrayList<String>();
        }
        return storeToStrings;
    }

    public List<IDocument> getAttachments() {
        ArrayList<IDocument> documents = new ArrayList<IDocument>();
        for (String storeToString : this.getAttachmentsInternal()) {
            Optional loadFromString = StoreToStringServiceHolder.get().loadFromString(storeToString);
            if (loadFromString.isPresent()) {
                documents.add((IDocument)loadFromString.get());
                continue;
            }
            LoggerFactory.getLogger(this.getClass()).warn("[{}] Unable to load attached IDocument [{}]", (Object)this.getId(), (Object)storeToString);
        }
        return documents;
    }

    public void addAttachment(IDocument attachment) {
        String storeToString = StoreToStringServiceHolder.getStoreToString(attachment);
        List<String> attachmentsInternal = this.getAttachmentsInternal();
        if (!attachmentsInternal.contains(storeToString)) {
            attachmentsInternal.add(storeToString);
            this.extInfoHandler.setExtInfo((Object)"Attachments", (Object)StringTool.pack(attachmentsInternal));
        }
    }

    public void removeAttachment(IDocument attachment) {
        String storeToString = StoreToStringServiceHolder.getStoreToString(attachment);
        List<String> attachmentsInternal = this.getAttachmentsInternal();
        if (attachmentsInternal.contains(storeToString)) {
            attachmentsInternal.remove(storeToString);
            this.extInfoHandler.setExtInfo((Object)"Attachments", (Object)StringTool.pack(attachmentsInternal));
        }
    }
}

