/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.jpa.entities.Behandlung;
import ch.elexis.core.jpa.entities.Brief;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.entities.Heap;
import ch.elexis.core.jpa.entities.Kontakt;
import ch.elexis.core.jpa.model.adapter.AbstractIdDeleteModelAdapter;
import ch.elexis.core.model.IBlob;
import ch.elexis.core.model.ICategory;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.IDocumentLetter;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IHistory;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.IdentifiableWithXid;
import ch.elexis.core.model.TransientCategory;
import ch.elexis.core.model.TransientHistory;
import ch.elexis.core.model.util.DocumentLetterUtil;
import ch.elexis.core.model.util.internal.ModelUtil;
import ch.elexis.core.services.INativeQuery;
import ch.elexis.core.services.IVirtualFilesystemService;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.time.TimeUtil;
import ch.elexis.core.types.DocumentStatus;
import ch.elexis.core.types.DocumentStatusMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;

public class DocumentLetter
extends AbstractIdDeleteModelAdapter<Brief>
implements IdentifiableWithXid,
IDocumentLetter {
    private ICategory category;
    private String storeId = "";
    private List<IHistory> history;

    public DocumentLetter(Brief entity) {
        super((EntityWithId)entity);
    }

    public String getTitle() {
        return ((Brief)this.getEntity()).getSubject();
    }

    public void setTitle(String value) {
        ((Brief)this.getEntityMarkDirty()).setSubject(value);
    }

    public String getDescription() {
        return ((Brief)this.getEntity()).getNote();
    }

    public void setDescription(String value) {
        ((Brief)this.getEntityMarkDirty()).setNote(value);
    }

    public List<DocumentStatus> getStatus() {
        int status = ((Brief)this.getEntity()).getStatus();
        Set map = DocumentStatusMapper.map((int)status);
        if (((Brief)this.getEntity()).getRecipient() != null) {
            map.add(DocumentStatus.SENT);
        }
        return new ArrayList<DocumentStatus>(map);
    }

    public void setStatus(DocumentStatus _status, boolean active) {
        HashSet<DocumentStatus> _statusSet = new HashSet<DocumentStatus>(this.getStatus());
        if (active) {
            _statusSet.add(_status);
        } else {
            _statusSet.remove(_status);
        }
        int value = DocumentStatusMapper.map(_statusSet);
        ((Brief)this.getEntity()).setStatus(value);
    }

    public Date getCreated() {
        LocalDateTime creationDate = ((Brief)this.getEntity()).getCreationDate();
        return creationDate != null ? this.toDate(creationDate) : this.getLastchanged();
    }

    public void setCreated(Date value) {
        ((Brief)this.getEntityMarkDirty()).setCreationDate(TimeUtil.toLocalDateTime((Date)value));
    }

    public Date getLastchanged() {
        if (((Brief)this.getEntity()).getModifiedDate() != null) {
            return this.toDate(((Brief)this.getEntity()).getModifiedDate());
        }
        if (((Brief)this.getEntity()).getLastupdate() != null) {
            return new Date(((Brief)this.getEntity()).getLastupdate());
        }
        return new Date(0L);
    }

    public void setLastchanged(Date value) {
        ((Brief)this.getEntityMarkDirty()).setModifiedDate(TimeUtil.toLocalDateTime((Date)value));
    }

    public String getMimeType() {
        return StringUtils.defaultString((String)((Brief)this.getEntity()).getMimetype());
    }

    public void setMimeType(String value) {
        ((Brief)this.getEntityMarkDirty()).setMimetype(value);
    }

    public ICategory getCategory() {
        if (this.category == null && ((Brief)this.getEntity()).getTyp() != null) {
            this.category = new TransientCategory(((Brief)this.getEntity()).getTyp());
        }
        return this.category;
    }

    public void setCategory(ICategory value) {
        this.category = value;
        ((Brief)this.getEntityMarkDirty()).setTyp(value.getName());
    }

    public List<IHistory> getHistory() {
        if (this.history == null) {
            this.history = new ArrayList<IHistory>();
            if (((Brief)this.getEntity()).getRecipient() != null) {
                this.history.add(new TransientHistory(this.getCreated(), DocumentStatus.SENT, ModelUtil.getPersonalia(((Brief)this.getEntity()).getRecipient())));
            }
        }
        return this.history;
    }

    public String getStoreId() {
        return StringUtils.isNotEmpty((CharSequence)this.storeId) ? this.storeId : "ch.elexis.data.store.brief";
    }

    public void setStoreId(String value) {
        this.storeId = value;
    }

    public String getExtension() {
        return DocumentLetterUtil.evaluateFileExtension(((Brief)this.getEntity()).getMimetype());
    }

    public void setExtension(String value) {
        ((Brief)this.getEntity()).setMimetype(value);
    }

    public String getKeywords() {
        return StringUtils.defaultString((String)((Brief)this.getEntity()).getKeywords());
    }

    public void setKeywords(String value) {
        ((Brief)this.getEntityMarkDirty()).setKeywords(value);
    }

    public IPatient getPatient() {
        return ModelUtil.getAdapter((EntityWithId)((Brief)this.getEntity()).getPatient(), IPatient.class);
    }

    public void setPatient(IPatient value) {
        if (value instanceof AbstractIdDeleteModelAdapter) {
            ((Brief)this.getEntityMarkDirty()).setPatient((Kontakt)((AbstractIdDeleteModelAdapter)value).getEntity());
        } else if (value == null) {
            ((Brief)this.getEntityMarkDirty()).setPatient(null);
        }
    }

    public IContact getAuthor() {
        return ModelUtil.getAdapter((EntityWithId)((Brief)this.getEntity()).getSender(), IContact.class);
    }

    public void setAuthor(IContact value) {
        if (value instanceof AbstractIdDeleteModelAdapter) {
            ((Brief)this.getEntityMarkDirty()).setSender((Kontakt)((AbstractIdDeleteModelAdapter)value).getEntity());
        } else if (value == null) {
            ((Brief)this.getEntityMarkDirty()).setSender(null);
        }
    }

    public IContact getRecipient() {
        return ModelUtil.getAdapter((EntityWithId)((Brief)this.getEntity()).getRecipient(), IContact.class);
    }

    public void setRecipient(IContact value) {
        if (value instanceof AbstractIdDeleteModelAdapter) {
            ((Brief)this.getEntityMarkDirty()).setRecipient((Kontakt)((AbstractIdDeleteModelAdapter)value).getEntity());
        } else if (value == null) {
            ((Brief)this.getEntityMarkDirty()).setRecipient(null);
        }
    }

    public InputStream getContent() {
        byte[] inhalt;
        Heap content;
        IVirtualFilesystemService.IVirtualFilesystemHandle vfsHandle = DocumentLetterUtil.getExternalHandleIfApplicable((IDocument)this);
        if (vfsHandle != null && vfsHandle.canRead()) {
            try {
                return vfsHandle.openInputStream();
            }
            catch (IOException e) {
                LoggerFactory.getLogger(this.getClass()).warn("Exception getting InputStream for Letter [{}]", (Object)this.getId(), (Object)e);
            }
        }
        if ((content = ((Brief)this.getEntity()).getContent()) != null && (inhalt = content.getInhalt()) != null) {
            return new ByteArrayInputStream(inhalt);
        }
        return null;
    }

    public long getContentLength() {
        Object next;
        try {
            IVirtualFilesystemService.IVirtualFilesystemHandle vfsHandle = DocumentLetterUtil.getExternalHandleIfApplicable((IDocument)this);
            if (vfsHandle != null && vfsHandle.canRead()) {
                return vfsHandle.getContentLenght();
            }
        }
        catch (IOException vfsHandle) {
            // empty catch block
        }
        INativeQuery nativeQuery = CoreModelServiceHolder.get().getNativeQuery("SELECT LENGTH(INHALT) FROM HEAP WHERE ID = ?1");
        Iterator result = nativeQuery.executeWithParameters(nativeQuery.getIndexedParameterMap(new Object[]{1, this.getId()})).iterator();
        if (result.hasNext() && (next = result.next()) != null) {
            return Long.parseLong(next.toString());
        }
        return -1L;
    }

    public void setContent(InputStream content) {
        block22: {
            this.setStatus(DocumentStatus.PREPROCESSED, false);
            this.setStatus(DocumentStatus.INDEXED, false);
            this.setLastchanged(new Date());
            IVirtualFilesystemService.IVirtualFilesystemHandle vfsHandle = DocumentLetterUtil.getExternalHandleIfApplicable((IDocument)this);
            if (vfsHandle != null) {
                if (content == null) {
                    try {
                        vfsHandle.delete();
                        return;
                    }
                    catch (IOException e) {
                        LoggerFactory.getLogger(this.getClass()).error("Error deleting document content", (Throwable)e);
                    }
                } else {
                    try {
                        Throwable e = null;
                        Object var4_9 = null;
                        try (OutputStream outputStream = vfsHandle.openOutputStream();){
                            IOUtils.copy((InputStream)content, (OutputStream)outputStream);
                            return;
                        }
                        catch (Throwable throwable) {
                            if (e == null) {
                                e = throwable;
                            } else if (e != throwable) {
                                e.addSuppressed(throwable);
                            }
                            throw e;
                        }
                    }
                    catch (IOException e) {
                        LoggerFactory.getLogger(this.getClass()).error("Error setting document content, will write to HEAP", (Throwable)e);
                    }
                }
            }
            try {
                try {
                    if (content == null) {
                        ((Brief)this.getEntity()).setContent(null);
                        break block22;
                    }
                    ((Brief)this.getEntity()).getOrCreateContent().setInhalt(IOUtils.toByteArray((InputStream)content));
                    this.addChanged((Identifiable)ModelUtil.getAdapter((EntityWithId)((Brief)this.getEntity()).getOrCreateContent(), IBlob.class));
                }
                catch (IOException e) {
                    LoggerFactory.getLogger(this.getClass()).error("Error setting document content", (Throwable)e);
                    IOUtils.closeQuietly((InputStream)content);
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)content);
            }
        }
    }

    public String getLabel() {
        return String.valueOf(new SimpleDateFormat("dd.MM.yyyy").format(this.getCreated())) + " " + this.getTitle();
    }

    public IEncounter getEncounter() {
        return ModelUtil.getAdapter((EntityWithId)((Brief)this.getEntity()).getConsultation(), IEncounter.class);
    }

    public void setEncounter(IEncounter value) {
        if (value instanceof AbstractIdDeleteModelAdapter) {
            ((Brief)this.getEntityMarkDirty()).setConsultation((Behandlung)((AbstractIdDeleteModelAdapter)value).getEntity());
        } else if (value == null) {
            ((Brief)this.getEntityMarkDirty()).setConsultation(null);
        }
    }

    public boolean isTemplate() {
        if (this.getCategory() != null) {
            return "Vorlagen".equals(this.getCategory().getName());
        }
        return false;
    }
}

