/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.model.builder.IContactBuilder;
import ch.elexis.core.services.INamedQuery;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.test.AbstractTest;
import ch.elexis.core.types.Gender;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PatientTest
extends AbstractTest {
    @Before
    public void before() {
        super.before();
        super.createPatient();
    }

    @After
    public void after() {
        super.after();
    }

    @Test
    public void createDeletePatient() {
        this.patient.setExtInfo((Object)"BirthName", (Object)"Birthname");
        this.coreModelService.save((Identifiable)this.patient);
        Assert.assertTrue((boolean)this.patient.isPatient());
        Assert.assertTrue((boolean)this.patient.isPerson());
        Assert.assertFalse((boolean)this.patient.isMandator());
        Assert.assertFalse((boolean)this.patient.isOrganization());
        Assert.assertFalse((boolean)this.patient.isLaboratory());
        String id = this.patient.getId();
        Assert.assertNotNull((Object)id);
        Assert.assertNotNull((Object)this.patient.getCode());
        IContact findById = (IContact)this.coreModelService.load(id, IContact.class).get();
        Assert.assertNotNull((Object)findById);
        Assert.assertEquals((Object)"Birthname", (Object)findById.getExtInfo((Object)"BirthName"));
    }

    @Test
    public void queryByPatientNumber() {
        IPatient patient1 = (IPatient)new IContactBuilder.PatientBuilder(this.coreModelService, "testfirst", "testlast", LocalDate.of(2018, 10, 24), Gender.FEMALE).build();
        patient1.setPatientNr("123");
        CoreModelServiceHolder.get().save((Identifiable)patient1);
        INamedQuery namedQuery = CoreModelServiceHolder.get().getNamedQuery(IPatient.class, new String[]{"code"});
        Optional loaded = namedQuery.executeWithParametersSingleResult(namedQuery.getParameterMap(new Object[]{"code", StringTool.normalizeCase((String)"123")}));
        Assert.assertTrue((boolean)loaded.isPresent());
        Assert.assertEquals((Object)patient1, loaded.get());
        CoreModelServiceHolder.get().remove((Identifiable)patient1);
    }

    @Test
    public void queryByName() {
        IPatient patient1 = (IPatient)new IContactBuilder.PatientBuilder(this.coreModelService, "testfirst", "testlast", LocalDate.of(2018, 10, 24), Gender.FEMALE).build();
        patient1.setPatientNr("123");
        CoreModelServiceHolder.get().save((Identifiable)patient1);
        IQuery query = CoreModelServiceHolder.get().getQuery(IPatient.class);
        query.and((EStructuralFeature)ModelPackage.Literals.IPERSON__FIRST_NAME, IQuery.COMPARATOR.LIKE, (Object)"testfirst", true);
        List loaded = query.execute();
        Assert.assertFalse((boolean)loaded.isEmpty());
        query = CoreModelServiceHolder.get().getQuery(IPatient.class);
        query.and((EStructuralFeature)ModelPackage.Literals.IPERSON__FIRST_NAME, IQuery.COMPARATOR.LIKE, (Object)"testlast", true);
        loaded = query.execute();
        Assert.assertTrue((boolean)loaded.isEmpty());
        CoreModelServiceHolder.get().remove((Identifiable)patient1);
    }

    @Test
    public void queryByDateOfBirth() {
        IPatient patient1 = (IPatient)new IContactBuilder.PatientBuilder(this.coreModelService, "testfirst", "testlast", LocalDate.of(2018, 10, 24), Gender.FEMALE).build();
        patient1.setPatientNr("123");
        CoreModelServiceHolder.get().save((Identifiable)patient1);
        IQuery query = CoreModelServiceHolder.get().getQuery(IPatient.class);
        query.and((EStructuralFeature)ModelPackage.Literals.IPERSON__DATE_OF_BIRTH, IQuery.COMPARATOR.EQUALS, (Object)new TimeTool("24.10.2018").toLocalDate());
        List loaded = query.execute();
        Assert.assertFalse((boolean)loaded.isEmpty());
        CoreModelServiceHolder.get().remove((Identifiable)patient1);
    }
}

