/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ILabItem;
import ch.elexis.core.model.ILabMapping;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.types.LabItemTyp;
import ch.elexis.core.utils.OsgiServiceUtil;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LabMappingTest {
    private IModelService modelService;
    private ILabItem item1;
    private ILabItem item2;
    private IContact origin1;
    private IContact origin2;

    @Before
    public void before() {
        this.modelService = (IModelService)OsgiServiceUtil.getService(IModelService.class, (String)"(service.model.name=ch.elexis.core.model)").get();
        this.item1 = (ILabItem)this.modelService.create(ILabItem.class);
        this.item1.setCode("testItem1");
        this.item1.setName("test item name 1");
        this.item1.setTyp(LabItemTyp.NUMERIC);
        this.modelService.save((Identifiable)this.item1);
        this.item2 = (ILabItem)this.modelService.create(ILabItem.class);
        this.item2.setCode("testItem2");
        this.item2.setName("test item name 2");
        this.item2.setTyp(LabItemTyp.TEXT);
        this.modelService.save((Identifiable)this.item2);
        this.origin1 = (IContact)this.modelService.create(IContact.class);
        this.origin1.setDescription1("test origin 1");
        this.modelService.save((Identifiable)this.origin1);
        this.origin2 = (IContact)this.modelService.create(IContact.class);
        this.origin2.setDescription1("test origin 2");
        this.modelService.save((Identifiable)this.origin2);
    }

    @After
    public void after() {
        this.modelService.remove((Identifiable)this.item1);
        this.modelService.remove((Identifiable)this.item2);
        this.modelService.remove((Identifiable)this.origin1);
        this.modelService.remove((Identifiable)this.origin2);
        OsgiServiceUtil.ungetService((Object)this.modelService);
        this.modelService = null;
    }

    @Test
    public void create() {
        ILabMapping mapping = (ILabMapping)this.modelService.create(ILabMapping.class);
        Assert.assertNotNull((Object)mapping);
        Assert.assertTrue((boolean)(mapping instanceof ILabMapping));
        mapping.setItemName("TestItemMap1");
        mapping.setItem(this.item1);
        mapping.setOrigin(this.origin1);
        this.modelService.save((Identifiable)mapping);
        Optional loadedMapping = this.modelService.load(mapping.getId(), ILabMapping.class);
        Assert.assertTrue((boolean)loadedMapping.isPresent());
        Assert.assertFalse((mapping == loadedMapping.get() ? 1 : 0) != 0);
        Assert.assertEquals((Object)mapping, loadedMapping.get());
        Assert.assertEquals((Object)mapping.getItemName(), (Object)((ILabMapping)loadedMapping.get()).getItemName());
        Assert.assertEquals((Object)mapping.getItem(), (Object)((ILabMapping)loadedMapping.get()).getItem());
        Assert.assertEquals((Object)mapping.getOrigin(), (Object)((ILabMapping)loadedMapping.get()).getOrigin());
        this.modelService.remove((Identifiable)mapping);
    }

    @Test
    public void query() {
        ILabMapping mapping1 = (ILabMapping)this.modelService.create(ILabMapping.class);
        mapping1.setItemName("TestItemMap1");
        mapping1.setItem(this.item1);
        mapping1.setOrigin(this.origin1);
        this.modelService.save((Identifiable)mapping1);
        ILabMapping mapping2 = (ILabMapping)this.modelService.create(ILabMapping.class);
        mapping2.setItemName("TestItemMap2");
        mapping2.setItem(this.item2);
        mapping2.setOrigin(this.origin2);
        this.modelService.save((Identifiable)mapping2);
        IQuery query = this.modelService.getQuery(ILabMapping.class);
        query.and((EStructuralFeature)ModelPackage.Literals.ILAB_MAPPING__ITEM_NAME, IQuery.COMPARATOR.EQUALS, (Object)"TestItemMap2");
        query.and((EStructuralFeature)ModelPackage.Literals.ILAB_MAPPING__ORIGIN, IQuery.COMPARATOR.EQUALS, (Object)this.origin2);
        List existing = query.execute();
        Assert.assertNotNull((Object)existing);
        Assert.assertFalse((boolean)existing.isEmpty());
        Assert.assertEquals((long)1L, (long)existing.size());
        Assert.assertEquals((Object)mapping2, existing.get(0));
        query = this.modelService.getQuery(ILabMapping.class);
        query.and((EStructuralFeature)ModelPackage.Literals.ILAB_MAPPING__ITEM, IQuery.COMPARATOR.EQUALS, (Object)this.item1);
        query.and((EStructuralFeature)ModelPackage.Literals.ILAB_MAPPING__ORIGIN, IQuery.COMPARATOR.EQUALS, (Object)this.origin1);
        existing = query.execute();
        Assert.assertNotNull((Object)existing);
        Assert.assertFalse((boolean)existing.isEmpty());
        Assert.assertEquals((long)1L, (long)existing.size());
        Assert.assertEquals((Object)mapping1, existing.get(0));
        this.modelService.remove((Identifiable)mapping1);
        this.modelService.remove((Identifiable)mapping2);
    }
}

