/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.model.IConfig;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.test.AbstractTest;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.persistence.RollbackException;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.junit.Assert;
import org.junit.Test;

public class ConfigTest
extends AbstractTest {
    @Test
    public void create() {
        IConfig config = (IConfig)this.coreModelService.create(IConfig.class);
        Assert.assertNotNull((Object)config);
        Assert.assertTrue((boolean)(config instanceof IConfig));
        config.setKey("test key1");
        config.setValue("test value 1");
        this.coreModelService.save((Identifiable)config);
        Optional loadedConfig = this.coreModelService.load(config.getId(), IConfig.class);
        Assert.assertTrue((boolean)loadedConfig.isPresent());
        Assert.assertFalse((config == loadedConfig.get() ? 1 : 0) != 0);
        Assert.assertEquals((Object)config, loadedConfig.get());
        Assert.assertEquals((Object)config.getValue(), (Object)((IConfig)loadedConfig.get()).getValue());
        this.coreModelService.remove((Identifiable)config);
    }

    @Test
    public void query() {
        IConfig config1 = (IConfig)this.coreModelService.create(IConfig.class);
        config1.setKey("test key 1");
        config1.setValue("test value 1");
        this.coreModelService.save((Identifiable)config1);
        IConfig config2 = (IConfig)this.coreModelService.create(IConfig.class);
        config2.setKey("test key 2");
        config2.setValue("test value 2");
        this.coreModelService.save((Identifiable)config2);
        IQuery query = this.coreModelService.getQuery(IConfig.class);
        query.and((EStructuralFeature)ModelPackage.Literals.ICONFIG__KEY, IQuery.COMPARATOR.EQUALS, (Object)"test key 2");
        List existing = query.execute();
        Assert.assertNotNull((Object)existing);
        Assert.assertFalse((boolean)existing.isEmpty());
        Assert.assertFalse((config2 == existing.get(0) ? 1 : 0) != 0);
        Assert.assertEquals((Object)config2, existing.get(0));
        Assert.assertEquals((Object)config2.getValue(), (Object)((IConfig)existing.get(0)).getValue());
        Optional loaded = this.coreModelService.load("test key 2", IConfig.class);
        Assert.assertTrue((boolean)loaded.isPresent());
        Assert.assertEquals((Object)config2, loaded.get());
        this.coreModelService.remove((Identifiable)config1);
        this.coreModelService.remove((Identifiable)config2);
    }

    @Test
    public void optimisticLock() throws InterruptedException {
        IConfig config1 = (IConfig)this.coreModelService.create(IConfig.class);
        config1.setKey("test key 1");
        config1.setValue("test value 1");
        this.coreModelService.save((Identifiable)config1);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute(new Runnable(){

            @Override
            public void run() {
                int affected = ConfigTest.this.coreModelService.executeNativeUpdate("UPDATE config SET wert = 'test key', lastupdate = 1 WHERE param = 'test key 1'", false);
                Assert.assertEquals((long)1L, (long)affected);
            }
        });
        executor.awaitTermination(1000L, TimeUnit.MILLISECONDS);
        config1.setValue("test key 1");
        RollbackException rbe = null;
        try {
            this.coreModelService.save((Identifiable)config1);
        }
        catch (RollbackException e) {
            rbe = e;
        }
        Assert.assertNotNull((Object)((Object)rbe));
    }
}

