/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.test.AbstractTest;
import ch.rgw.tools.Money;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;

public class BilledTest
extends AbstractTest {
    @Test
    public void create() {
        IBilled billed = (IBilled)this.coreModelService.create(IBilled.class);
        billed.setAmount(1.0);
        billed.setPoints(2);
        billed.setFactor(1.0);
        billed.setPrimaryScale(100);
        billed.setSecondaryScale(100);
        Assert.assertFalse((boolean)billed.isNonIntegerAmount());
        Assert.assertFalse((boolean)billed.isChangedPrice());
        Assert.assertEquals((double)0.02, (double)billed.getPrice().doubleValue(), (double)0.001);
        Assert.assertEquals((double)1.0, (double)billed.getAmount(), (double)0.001);
        Assert.assertEquals((double)0.02, (double)billed.getTotal().doubleValue(), (double)0.001);
        this.coreModelService.save((Identifiable)billed);
        Optional loadedBilled = this.coreModelService.load(billed.getId(), IBilled.class);
        Assert.assertTrue((boolean)loadedBilled.isPresent());
        Assert.assertFalse((billed == loadedBilled.get() ? 1 : 0) != 0);
        Assert.assertEquals((Object)billed, loadedBilled.get());
        Assert.assertEquals((double)billed.getAmount(), (double)((IBilled)loadedBilled.get()).getAmount(), (double)0.01);
        Assert.assertEquals((Object)billed.getPrice(), (Object)((IBilled)loadedBilled.get()).getPrice());
        this.coreModelService.remove((Identifiable)billed);
    }

    @Test
    public void changeNonIntegerAmount() {
        IBilled billed = (IBilled)this.coreModelService.create(IBilled.class);
        billed.setPoints(2);
        billed.setFactor(1.0);
        billed.setPrimaryScale(100);
        billed.setSecondaryScale(100);
        billed.setAmount(2.5);
        this.coreModelService.save((Identifiable)billed);
        Assert.assertTrue((boolean)billed.isNonIntegerAmount());
        Assert.assertFalse((boolean)billed.isChangedPrice());
        Assert.assertEquals((double)0.02, (double)billed.getPrice().doubleValue(), (double)0.001);
        Assert.assertEquals((double)2.5, (double)billed.getAmount(), (double)0.001);
        Assert.assertEquals((double)0.05, (double)billed.getTotal().doubleValue(), (double)0.001);
        this.coreModelService.remove((Identifiable)billed);
    }

    @Test
    public void changePrice() {
        IBilled billed = (IBilled)this.coreModelService.create(IBilled.class);
        billed.setPoints(2);
        billed.setFactor(1.0);
        billed.setPrimaryScale(100);
        billed.setSecondaryScale(100);
        billed.setAmount(1.0);
        billed.setPrice(new Money(2.5));
        this.coreModelService.save((Identifiable)billed);
        Assert.assertFalse((boolean)billed.isNonIntegerAmount());
        Assert.assertTrue((boolean)billed.isChangedPrice());
        Assert.assertEquals((double)2.5, (double)billed.getPrice().doubleValue(), (double)0.001);
        Assert.assertEquals((double)1.0, (double)billed.getAmount(), (double)0.001);
        Assert.assertEquals((double)2.5, (double)billed.getTotal().doubleValue(), (double)0.001);
        billed.setAmount(3.0);
        this.coreModelService.save((Identifiable)billed);
        Assert.assertFalse((boolean)billed.isNonIntegerAmount());
        Assert.assertTrue((boolean)billed.isChangedPrice());
        Assert.assertEquals((double)2.5, (double)billed.getPrice().doubleValue(), (double)0.001);
        Assert.assertEquals((double)3.0, (double)billed.getAmount(), (double)0.001);
        Assert.assertEquals((double)7.5, (double)billed.getTotal().doubleValue(), (double)0.001);
        this.coreModelService.remove((Identifiable)billed);
    }

    @Test
    public void testShowTwoDifferentTotalImplementations() {
        IBilled billed = (IBilled)this.coreModelService.create(IBilled.class);
        billed.setAmount(2.0);
        billed.setFactor(1.0);
        billed.setPrimaryScale(3);
        billed.setPrice(new Money(105));
        this.coreModelService.save((Identifiable)billed);
        Money moneyNewTotal = billed.getTotal();
        Money moneyInvalidTotal = this.calculateTotalInvalidWay(billed);
        Assert.assertEquals((long)6L, (long)moneyNewTotal.getCents());
        Assert.assertEquals((long)6L, (long)moneyInvalidTotal.getCents());
        billed.setPrice(new Money(110));
        moneyNewTotal = billed.getTotal();
        moneyInvalidTotal = this.calculateTotalInvalidWay(billed);
        Assert.assertEquals((long)7L, (long)moneyNewTotal.getCents());
        Assert.assertEquals((long)6L, (long)moneyInvalidTotal.getCents());
        billed.setPrice(new Money(120));
        moneyNewTotal = billed.getTotal();
        moneyInvalidTotal = this.calculateTotalInvalidWay(billed);
        Assert.assertEquals((long)7L, (long)moneyNewTotal.getCents());
        Assert.assertEquals((long)8L, (long)moneyInvalidTotal.getCents());
    }

    private Money calculateTotalInvalidWay(IBilled billed) {
        return billed.getPrice().multiply(billed.getPrimaryScaleFactor()).multiply(billed.getSecondaryScaleFactor()).multiply(billed.getAmount());
    }
}

