/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.mail.ui.dialogs;

import ch.elexis.core.mail.AttachmentsUtil;
import ch.elexis.core.mail.ui.dialogs.LaborAttachmentAction;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.ui.icons.Images;
import java.io.File;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.Command;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;

public class AttachmentsComposite
extends Composite {
    private String attachments;
    private String documents;
    private Command createRocheLaborCommand;
    private String postfix;
    private Composite attachmentsParent;

    public AttachmentsComposite(Composite parent, int style) {
        super(parent, style);
        this.setData("org.eclipse.e4.ui.css.CssClassName", "CustomComposite");
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        this.createRocheLaborCommand = commandService.getCommand("at.medevit.elexis.roche.labor.CreatePdfSelection");
        this.createContent();
    }

    private void createContent() {
        this.setLayout((Layout)new GridLayout(3, false));
        Label lbl = new Label((Composite)this, 0);
        lbl.setText("Anhang");
        lbl.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.attachmentsParent = new Composite((Composite)this, 0);
        this.attachmentsParent.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.attachmentsParent.setLayout((Layout)new GridLayout(2, false));
        ToolBarManager mgr = new ToolBarManager();
        if (this.createRocheLaborCommand != null && this.createRocheLaborCommand.isEnabled()) {
            mgr.add((IAction)new LaborAttachmentAction(this, this.createRocheLaborCommand));
        }
        ToolBar toolbar = mgr.createControl((Composite)this);
        toolbar.setLayoutData((Object)new GridData(131072, 128, false, false));
        Label dropLabel = new Label((Composite)this, 0x1000800);
        dropLabel.setText("Externe Datei hierhin ziehen");
        GridData gd = new GridData(4, 0x1000000, true, false, 3, 1);
        gd.heightHint = 30;
        dropLabel.setLayoutData((Object)gd);
        Transfer[] dropTransferTypes = new Transfer[]{FileTransfer.getInstance()};
        DropTarget target = new DropTarget((Control)dropLabel, 1);
        target.setTransfer(dropTransferTypes);
        target.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
                event.detail = 1;
            }

            public void drop(DropTargetEvent event) {
                if (FileTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    String[] files = (String[])event.data;
                    Arrays.asList(files).forEach(s -> {
                        if (StringUtils.isBlank((CharSequence)AttachmentsComposite.this.getAttachments())) {
                            AttachmentsComposite.this.setAttachments((String)s);
                        } else {
                            AttachmentsComposite.this.setAttachments(String.valueOf(AttachmentsComposite.this.getAttachments()) + ":::" + s);
                        }
                    });
                    AttachmentsComposite.this.updateAttachments();
                }
            }
        });
    }

    public String getAttachmentNames(String attachmentAsString) {
        StringBuilder build = new StringBuilder();
        if (attachmentAsString != null) {
            String[] attachments;
            String[] stringArray = attachments = attachmentAsString.split(",\n");
            int n = attachments.length;
            int n2 = 0;
            while (n2 < n) {
                String f = stringArray[n2];
                if (build.length() > 0) {
                    build.append(",\n");
                }
                build.append(Paths.get(f, new String[0]).getFileName());
                ++n2;
            }
        }
        return build.toString();
    }

    public void setAttachments(String attachments) {
        this.attachments = attachments;
        this.updateAttachments();
    }

    private void updateAttachments() {
        Label label;
        String[] stringArray;
        this.attachmentsParent.setRedraw(false);
        Control[] controlArray = this.attachmentsParent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
        if (StringUtils.isNotBlank((CharSequence)this.attachments)) {
            String[] attachmentsParts;
            stringArray = attachmentsParts = this.attachments.split(":::");
            int n3 = attachmentsParts.length;
            n = 0;
            while (n < n3) {
                String string = stringArray[n];
                label = new Label(this.attachmentsParent, 0);
                label.setText(FilenameUtils.getName((String)string));
                label.setData((Object)string);
                label.setToolTipText("Mit Doppelklick \u00f6ffnen (keine \u00c4nderungen)");
                label.addMouseListener((MouseListener)new MouseAdapter(){

                    public void mouseDoubleClick(MouseEvent e) {
                        File file = new File((String)label.getData());
                        file.setReadOnly();
                        Program.launch((String)((String)label.getData()));
                    }
                });
                label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                final Label remove = new Label(this.attachmentsParent, 0);
                remove.setImage(Images.IMG_DELETE.getImage());
                remove.setData((Object)string);
                remove.addMouseListener((MouseListener)new MouseAdapter(){

                    public void mouseUp(MouseEvent e) {
                        List<String> removeParts = Arrays.asList(AttachmentsComposite.this.getAttachments().split(":::"));
                        String removedString = removeParts.stream().filter(part -> !part.equals(remove.getData())).collect(Collectors.joining(":::"));
                        AttachmentsComposite.this.setAttachments(removedString);
                    }
                });
                remove.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
                ++n;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.documents)) {
            String[] documentsParts;
            stringArray = documentsParts = this.documents.split(":::");
            int n4 = documentsParts.length;
            n = 0;
            while (n < n4) {
                String string = stringArray[n];
                label = new Label(this.attachmentsParent, 0);
                final String tmpFile = AttachmentsUtil.toAttachment((String)string);
                if (!tmpFile.toLowerCase().endsWith(".pdf")) {
                    MessageDialog.openWarning((Shell)this.getShell(), (String)"Warnung", (String)("Dokument " + FilenameUtils.getName((String)tmpFile) + " konnte nicht konvertiert werden, bzw. ist kein pdf.\nBitte pr\u00fcfen ob ein editierbares Dokument versendet werden soll."));
                }
                label.setText(FilenameUtils.getName((String)tmpFile));
                label.setData((Object)string);
                label.setToolTipText("Mit Doppelklick \u00f6ffnen (keine \u00c4nderungen)");
                label.addMouseListener((MouseListener)new MouseAdapter(){

                    public void mouseDoubleClick(MouseEvent e) {
                        File file = new File(tmpFile);
                        file.setReadOnly();
                        Program.launch((String)tmpFile);
                    }
                });
                label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                final Label remove = new Label(this.attachmentsParent, 0);
                remove.setImage(Images.IMG_DELETE.getImage());
                remove.setData((Object)string);
                remove.addMouseListener((MouseListener)new MouseAdapter(){

                    public void mouseUp(MouseEvent e) {
                        List<String> removeParts = Arrays.asList(AttachmentsComposite.this.getDocuments().split(":::"));
                        String removedString = removeParts.stream().filter(part -> !part.equals(remove.getData())).collect(Collectors.joining(":::"));
                        AttachmentsComposite.this.setDocuments(removedString);
                    }
                });
                remove.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
                ++n;
            }
        }
        this.attachmentsParent.setRedraw(true);
        this.getParent().layout(true, true);
    }

    public void addDocument(IDocument document) {
        if (document != null) {
            this.documents = StringUtils.isBlank((CharSequence)this.documents) ? AttachmentsUtil.getDocumentsString(Collections.singletonList(document)) : String.valueOf(this.documents) + ":::" + AttachmentsUtil.getDocumentsString(Collections.singletonList(document));
        }
        this.updateAttachments();
    }

    public void setDocuments(String documents) {
        this.documents = documents;
        this.updateAttachments();
    }

    public String getAttachments() {
        return this.attachments;
    }

    public String getDocuments() {
        return this.documents;
    }

    public void setPostfix(String text) {
        this.postfix = text;
    }

    public String getPostfix() {
        return this.postfix;
    }
}

