/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.mail.ui.archive;

import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.mail.ui.archive.OmnivoreDocumentStoreServiceHolder;
import ch.elexis.core.model.ICategory;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.services.IDocumentStore;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.LoggerFactory;

public class ArchiveUtil {
    public static String PREF_MAIL_ARCHIVE_ENABLED = "mail/archive/enabled";
    public static String PREF_MAIL_ARCHIVE_DOCUMENT_CATEGORY = "mail/archive/document/category";
    public static String DEFAULT_CATEGORY = "Email Anhang Archiv";

    public static void archiveAttachments(List<File> attachments) {
        if (ConfigServiceHolder.get().get(PREF_MAIL_ARCHIVE_ENABLED, false) && attachments != null && !attachments.isEmpty()) {
            if (OmnivoreDocumentStoreServiceHolder.isAvailable()) {
                String prefix = ArchiveUtil.getPrefix();
                Optional patient = ContextServiceHolder.get().getActivePatient();
                if (patient.isPresent()) {
                    attachments.forEach(f -> ArchiveUtil.archiveFile(prefix, f, (IPatient)patient.get()));
                } else {
                    LoggerFactory.getLogger(ArchiveUtil.class).warn("No active patient");
                }
            } else {
                LoggerFactory.getLogger(ArchiveUtil.class).warn("No omnivore document service available");
            }
        }
    }

    private static String getPrefix() {
        return "Mailversand " + LocalDateTime.now().format(DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm"));
    }

    private static void archiveFile(String namePrefix, File file, IPatient iPatient) {
        IDocumentStore omnivoreStore = OmnivoreDocumentStoreServiceHolder.get();
        ICategory category = ArchiveUtil.getArchiveCategory(omnivoreStore);
        IDocument archiveDocument = omnivoreStore.createDocument(iPatient.getId(), String.valueOf(namePrefix) + " - " + file.getName(), category.getName());
        archiveDocument.setCreated(new Date());
        archiveDocument.setMimeType(FilenameUtils.getExtension((String)file.getName()));
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (FileInputStream inStream = new FileInputStream(file);){
                omnivoreStore.saveDocument(archiveDocument, (InputStream)inStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (ElexisException | IOException e) {
            LoggerFactory.getLogger(ArchiveUtil.class).error("Exception archiving attachment", e);
        }
    }

    private static ICategory getArchiveCategory(IDocumentStore omnivoreStore) {
        String categoryName = ConfigServiceHolder.get().get(PREF_MAIL_ARCHIVE_DOCUMENT_CATEGORY, DEFAULT_CATEGORY);
        Optional existing = omnivoreStore.getCategoryByName(categoryName);
        if (existing.isEmpty()) {
            return omnivoreStore.createCategory(DEFAULT_CATEGORY);
        }
        return (ICategory)existing.get();
    }
}

