/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.importer.div.importers.multifile.strategy;

import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.importer.div.importers.HL7Parser;
import ch.elexis.core.importer.div.importers.ILabContactResolver;
import ch.elexis.core.importer.div.importers.IPersistenceHandler;
import ch.elexis.core.importer.div.importers.ImportHandler;
import ch.elexis.core.importer.div.importers.OverwriteAllImportHandler;
import ch.elexis.core.importer.div.importers.TransientLabResult;
import ch.elexis.core.importer.div.importers.multifile.strategy.FileImportStrategyUtil;
import ch.elexis.core.importer.div.importers.multifile.strategy.IFileImportStrategy;
import ch.elexis.core.importer.div.service.holder.LabImportUtilHolder;
import ch.elexis.core.importer.div.service.holder.OmnivoreDocumentStoreServiceHolder;
import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.ICategory;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.ILabItem;
import ch.elexis.core.model.ILaboratory;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.services.IVirtualFilesystemService;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.types.LabItemTyp;
import ch.rgw.io.FileTool;
import ch.rgw.tools.Result;
import ch.rgw.tools.TimeTool;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPDFImportStrategy
implements IFileImportStrategy {
    private static final Logger log = LoggerFactory.getLogger(DefaultPDFImportStrategy.class);
    private static final String PDF = "pdf";
    private ILaboratory myLab;
    private String labName;
    private IPatient patient;
    private TimeTool dateTime;
    private String group;
    private String prio;
    private boolean testMode = false;
    private boolean moveAfterImport;
    private ImportHandler defaultImportHandler;
    private String pdfImportCategory;

    public DefaultPDFImportStrategy(ImportHandler defaultImportHandler) {
        this.defaultImportHandler = defaultImportHandler;
    }

    @Override
    public Result<Object> execute(IVirtualFilesystemService.IVirtualFilesystemHandle fileHandle, Map<String, Object> context, HL7Parser hl7parser, IPersistenceHandler persistenceHandler) {
        ImportHandler importHandler;
        block16: {
            importHandler = this.testMode ? new OverwriteAllImportHandler() : this.defaultImportHandler;
            try {
                this.initValuesFromContext(context);
                if (OmnivoreDocumentStoreServiceHolder.isAvailable()) break block16;
                if (this.moveAfterImport) {
                    try {
                        FileImportStrategyUtil.moveAfterImport(false, fileHandle);
                    }
                    catch (IOException e) {
                        return new Result(Result.SEVERITY.ERROR, 2, "Could not move after import [" + fileHandle.getAbsolutePath() + "]: " + e.getMessage(), context, true);
                    }
                }
                return new Result(Result.SEVERITY.ERROR, 2, MessageFormat.format(Messages.DefaultPDFImportStrategy_NoDocManager, fileHandle.getName(), this.patient.getLabel()), (Object)this.patient.getId(), true);
            }
            catch (IllegalStateException ise) {
                if (this.moveAfterImport) {
                    try {
                        FileImportStrategyUtil.moveAfterImport(false, fileHandle);
                    }
                    catch (IOException e) {
                        return new Result(Result.SEVERITY.ERROR, 2, "Could not move after import [" + fileHandle.getAbsolutePath() + "]: " + e.getMessage(), context, true);
                    }
                }
                return new Result(Result.SEVERITY.ERROR, 2, String.valueOf(Messages.DefaultPDFImportStrategy_InitContextFailed) + "\n" + ise.getMessage(), context, true);
            }
        }
        String name = "Dokument";
        String shortname = "doc";
        ILabItem labItem = LabImportUtilHolder.get().getLabItem(shortname, name, LabItemTyp.DOCUMENT).orElse(null);
        if (labItem == null) {
            labItem = LabImportUtilHolder.get().createLabItem(shortname, name, this.myLab, "", "", PDF, LabItemTyp.DOCUMENT, this.group, this.prio);
            log.debug("LabItem created [{}]", (Object)labItem);
        }
        String titel = this.generatePDFTitle(fileHandle.getName(), this.dateTime);
        String orderId = "noorder";
        try {
            String category;
            String string = category = StringUtils.isNotBlank((CharSequence)this.pdfImportCategory) ? this.pdfImportCategory : this.labName;
            if (this.addDocument(titel, category, this.dateTime, fileHandle, fileHandle.getName())) {
                TransientLabResult importResult = new TransientLabResult.Builder(this.patient, this.myLab, labItem, titel).date(this.dateTime).build(LabImportUtilHolder.get());
                orderId = LabImportUtilHolder.get().importLabResults(Collections.singletonList(importResult), importHandler);
            } else {
                log.error("pdf [{}] already present in document manager (omnivore)", (Object)fileHandle.getAbsolutePath());
            }
        }
        catch (ElexisException | IOException | IllegalStateException e) {
            log.error("error saving pdf [{}] in document manager (omnivore)", (Object)fileHandle.getAbsolutePath(), (Object)e);
            return new Result(Result.SEVERITY.ERROR, 2, "Could not store document [" + fileHandle.getAbsolutePath() + "]: " + e.getMessage(), context, true);
        }
        if (this.moveAfterImport) {
            try {
                FileImportStrategyUtil.moveAfterImport(true, fileHandle);
            }
            catch (IOException e) {
                e.printStackTrace();
                return new Result(Result.SEVERITY.ERROR, 2, "Could not move after import [" + fileHandle.getAbsolutePath() + "]: " + e.getMessage(), context, true);
            }
        }
        return new Result(Result.SEVERITY.OK, 0, "OK", (Object)orderId, false);
    }

    private void initValuesFromContext(Map<String, Object> context) {
        String msg2;
        StringBuilder sbFailed = new StringBuilder();
        this.patient = (IPatient)context.get("patient");
        if (this.patient == null) {
            sbFailed.append(Messages.Core_Patient);
            sbFailed.append("; ");
        }
        this.myLab = LabImportUtilHolder.get().loadCoreModel((String)context.get("labid"), ILaboratory.class).get();
        if (this.myLab == null) {
            sbFailed.append(Messages.Core_Laboratory);
            sbFailed.append("; ");
        }
        if (ConfigServiceHolder.get().getLocal("hl7Parser/importencdata", false)) {
            this.labName = ConfigServiceHolder.get().getLocal("hl7Parser/importencdataCategory", null);
        }
        if (this.labName == null || this.labName.isEmpty()) {
            this.labName = (String)context.get("labname");
            if (this.labName == null) {
                sbFailed.append(Messages.DefaultPDFImportStrategy_LabName);
                sbFailed.append("; ");
            }
        }
        this.dateTime = (TimeTool)context.get("time");
        if (this.dateTime == null) {
            sbFailed.append(Messages.Core_Date);
            sbFailed.append("; ");
        }
        this.group = (String)context.get("group");
        if (this.group == null) {
            sbFailed.append(Messages.Core_Group);
            sbFailed.append("; ");
        }
        this.prio = (String)context.get("prio");
        if (this.prio == null) {
            sbFailed.append(Messages.DefaultPDFImportStrategy_Prio);
            sbFailed.append("; ");
        }
        if ((msg2 = sbFailed.toString()) != null && !msg2.isEmpty()) {
            throw new IllegalStateException(msg2);
        }
    }

    private String generatePDFTitle(String filename, TimeTool dateTime) {
        SimpleDateFormat sdfTitle = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String title = "Laborbefund" + sdfTitle.format(dateTime.getTime()) + "." + FileTool.getExtension((String)filename);
        log.debug("generated labresult pdf title '" + title);
        return title;
    }

    private boolean addDocument(String title, String category, TimeTool creationTime, IVirtualFilesystemService.IVirtualFilesystemHandle fileHandle, String keywords) throws IOException, ElexisException {
        ICategory iCategory = this.findOrCreateCategory(category);
        List existing = OmnivoreDocumentStoreServiceHolder.get().getDocuments(this.patient.getId(), null, iCategory, null);
        if ((existing = existing.stream().filter(d -> this.documentMatches((IDocument)d, title, this.dateTime)).collect(Collectors.toList())).isEmpty()) {
            IDocument document = OmnivoreDocumentStoreServiceHolder.get().createDocument(this.patient.getId(), title, iCategory.getName());
            String extension = FileTool.getExtension((String)fileHandle.getName());
            document.setCreated(this.dateTime.getTime());
            document.setExtension(extension);
            document.setMimeType(extension.toLowerCase());
            document.setKeywords(keywords);
            Throwable throwable = null;
            Object var11_17 = null;
            try (InputStream is = fileHandle.openInputStream();){
                OmnivoreDocumentStoreServiceHolder.get().saveDocument(document, is);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return true;
        }
        log.warn("Overwriting existing lab document [" + title + "]");
        Throwable throwable = null;
        Object var9_12 = null;
        try (InputStream is = fileHandle.openInputStream();){
            OmnivoreDocumentStoreServiceHolder.get().saveDocument((IDocument)existing.get(0), is);
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        return false;
    }

    private boolean documentMatches(IDocument document, String title, TimeTool timeTool) {
        return document.getTitle().equals(title) && document.getCreated().equals(timeTool.getTime());
    }

    private ICategory findOrCreateCategory(String category) {
        if (category == null) {
            return OmnivoreDocumentStoreServiceHolder.get().getCategoryDefault();
        }
        List categories = OmnivoreDocumentStoreServiceHolder.get().getCategories();
        for (ICategory iCategory : categories) {
            if (!iCategory.getName().equals(category)) continue;
            return iCategory;
        }
        log.info("Created category " + category + " for multi file import");
        return OmnivoreDocumentStoreServiceHolder.get().createCategory(category);
    }

    @Override
    public void setTestMode(boolean testing) {
        this.testMode = testing;
    }

    @Override
    public IFileImportStrategy setMoveAfterImport(boolean value) {
        this.moveAfterImport = value;
        return this;
    }

    @Override
    public IFileImportStrategy setLabContactResolver(ILabContactResolver resolver) {
        return this;
    }

    public DefaultPDFImportStrategy setPDFImportCategory(String category) {
        this.pdfImportCategory = category;
        return this;
    }
}

