/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.importer.div.importers;

import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.model.builder.IContactBuilder;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.INamedQuery;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.types.Gender;
import ch.elexis.core.utils.KontaktMatcher;
import ch.elexis.hl7.HL7PatientResolver;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;

public abstract class AbstractHL7PatientResolver
extends HL7PatientResolver {
    IModelService coreModelService;
    Logger logger;

    public IPatient resolvePatient(String patid, String firstname, String lastname, String birthDate) {
        return this.resolvePatient(firstname, lastname, birthDate, patid);
    }

    public boolean matchPatient(IPatient patient, String firstname, String lastname, String birthDate) {
        return KontaktMatcher.isSame((IPatient)patient, (String)lastname, (String)firstname, (String)birthDate);
    }

    public IPatient createPatient(String lastName, String firstName, String birthDate, String sex) {
        TimeTool birthDateTimeTool = new TimeTool(birthDate);
        Gender gender = Gender.fromValue((String)sex);
        return (IPatient)new IContactBuilder.PatientBuilder(CoreModelServiceHolder.get(), firstName, lastName, birthDateTimeTool.toLocalDate(), gender).buildAndSave();
    }

    public List<? extends IPatient> getPatientById(String patid) {
        INamedQuery namedQuery = CoreModelServiceHolder.get().getNamedQuery(IPatient.class, new String[]{"code"});
        return namedQuery.executeWithParameters(namedQuery.getParameterMap(new Object[]{"code", StringTool.normalizeCase((String)patid)}));
    }

    public List<? extends IPatient> findPatientByNameAndBirthdate(String lastName, String firstName, String birthDate) {
        IQuery patientQuery = CoreModelServiceHolder.get().getQuery(IPatient.class);
        patientQuery.and((EStructuralFeature)ModelPackage.Literals.IPERSON__LAST_NAME, IQuery.COMPARATOR.EQUALS, (Object)lastName, true);
        patientQuery.and((EStructuralFeature)ModelPackage.Literals.IPERSON__FIRST_NAME, IQuery.COMPARATOR.EQUALS, (Object)firstName, true);
        patientQuery.and((EStructuralFeature)ModelPackage.Literals.IPERSON__DATE_OF_BIRTH, IQuery.COMPARATOR.EQUALS, (Object)new TimeTool(birthDate).toLocalDate());
        return patientQuery.execute();
    }
}

