/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.hl7.util;

import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.hl7v2.validation.ValidationContext;
import ca.uhn.hl7v2.validation.impl.NoValidation;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

public class HL7Helper {
    private static final SimpleDateFormat SDF_DATE_TIME_PATTERN = new SimpleDateFormat("yyyyMMddHHmmss");
    private static final String DTM_DATE_TIME_PATTERN = "yyyyMMddHHmmss";

    public static Date stringToDate(String dateTimeStr) throws ParseException {
        if (dateTimeStr == null || dateTimeStr.length() == 0) {
            return null;
        }
        if (dateTimeStr.length() >= 14) {
            return SDF_DATE_TIME_PATTERN.parse(dateTimeStr);
        }
        SimpleDateFormat sdf = new SimpleDateFormat(DTM_DATE_TIME_PATTERN.substring(0, dateTimeStr.length()));
        return sdf.parse(dateTimeStr);
    }

    public static String dateToString(Date date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return SDF_DATE_TIME_PATTERN.format(cal.getTime());
    }

    public static String dateToString(LocalDateTime localDateTime) {
        return HL7Helper.dateToString(Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant()));
    }

    public static String determineName(List<String> possibleNames) {
        String ret = "";
        for (String possibleName : possibleNames) {
            int retNonDigitCount;
            int possibleNonDigitCount;
            if (possibleName == null || "null".equals(possibleName) || (possibleNonDigitCount = HL7Helper.getNonDigitCharacters(possibleName)) <= (retNonDigitCount = HL7Helper.getNonDigitCharacters(ret))) continue;
            ret = possibleName;
        }
        return ret;
    }

    private static int getNonDigitCharacters(String possibleName) {
        int ret = possibleName.length();
        int i = 0;
        int len = possibleName.length();
        while (i < len) {
            if (Character.isDigit(possibleName.charAt(i))) {
                --ret;
            }
            ++i;
        }
        return ret;
    }

    public static String getEncoding(String message) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedReader reader = new BufferedReader(new StringReader(message));){
                String firstLine = reader.readLine();
                if (firstLine != null && firstLine.startsWith("MSH") && (firstLine.contains("8859-1") || firstLine.contains("8859/1"))) {
                    return StandardCharsets.ISO_8859_1.name();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return StandardCharsets.UTF_8.name();
    }

    public static Message parseMessage(String raw) throws Exception {
        PipeParser parser = new PipeParser();
        parser.setValidationContext((ValidationContext)new NoValidation());
        return parser.parse(raw);
    }
}

