/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.importer;

import ch.elexis.core.findings.util.ModelUtil;
import ch.elexis.core.findings.util.fhir.IFhirTransformer;
import ch.elexis.core.findings.util.fhir.IFhirTransformerRegistry;
import ch.elexis.core.interfaces.IReferenceDataImporter;
import ch.elexis.core.model.IOrganization;
import ch.elexis.core.services.IXidService;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Resource;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.LoggerFactory;

@Component(property={"referenceDataId=fhirbundle"})
public class FhirBundleReferenceDataImporter
implements IReferenceDataImporter {
    @Reference
    private IFhirTransformerRegistry transformerRegistry;
    @Reference
    private IXidService xidService;

    public IStatus performImport(IProgressMonitor ipm, InputStream input, Integer newVersion) {
        if (input != null) {
            try {
                String jsonString = IOUtils.toString((InputStream)input, (String)"UTF-8");
                IBaseResource resource = ModelUtil.getAsResource(jsonString);
                if (resource instanceof Bundle) {
                    Bundle bundle = (Bundle)resource;
                    for (Bundle.BundleEntryComponent bundleEntry : bundle.getEntry()) {
                        Optional<Object> localObject = Optional.empty();
                        Resource entryResource = bundleEntry.getResource();
                        if (entryResource instanceof Organization) {
                            Organization fhirObject = (Organization)entryResource;
                            IFhirTransformer<Organization, IOrganization> transformer = this.transformerRegistry.getTransformerFor(Organization.class, IOrganization.class);
                            localObject = this.getLocalObjectByIdentifiers((Resource)fhirObject, IOrganization.class);
                            localObject = localObject.isEmpty() ? transformer.createLocalObject(fhirObject) : transformer.updateLocalObject(fhirObject, (IOrganization)localObject.get());
                        } else {
                            LoggerFactory.getLogger(this.getClass()).warn("Unknown entry resource type [" + entryResource + "]");
                        }
                        if (!localObject.isPresent()) continue;
                        this.updateLocalObject(localObject.get());
                    }
                }
                return Status.OK_STATUS;
            }
            catch (IOException e) {
                LoggerFactory.getLogger(this.getClass()).error("Error importing FHIR bundle", (Throwable)e);
            }
        } else {
            LoggerFactory.getLogger(this.getClass()).warn("No input to import");
        }
        return Status.CANCEL_STATUS;
    }

    protected void updateLocalObject(Object object) {
    }

    private <T> Optional<T> getLocalObjectByIdentifiers(Resource fhirObject, Class<T> clazz) {
        List<Identifier> identifiers = this.getIdentifiersReflective(fhirObject);
        Iterator<Identifier> iterator = identifiers.iterator();
        if (iterator.hasNext()) {
            Identifier identifier = iterator.next();
            String localSystem = this.toLocalSystem(identifier.getSystem());
            return this.xidService.findObject(localSystem, identifier.getValue(), clazz);
        }
        return Optional.empty();
    }

    private List<Identifier> getIdentifiersReflective(Resource resource) {
        try {
            Method getterMethod = resource.getClass().getMethod("getIdentifier", null);
            Object list = getterMethod.invoke((Object)resource, null);
            if (list instanceof List) {
                return (List)list;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LoggerFactory.getLogger(this.getClass()).warn("Could not get identifiers of [" + resource + "]", (Object)e.getMessage());
        }
        return Collections.emptyList();
    }

    private String toLocalSystem(String system) {
        switch (system) {
            case "urn:oid:2.16.756.5.32": 
            case "www.ahv.ch/xid": {
                return "www.ahv.ch/xid";
            }
            case "www.xid.ch/id/ean": 
            case "urn:oid:2.51.1.3": {
                return "www.xid.ch/id/ean";
            }
            case "https://www.bag.admin.ch/bag/bsv-nummer": 
            case "www.xid.ch/id/kknum": {
                return "www.xid.ch/id/kknum";
            }
        }
        return null;
    }
}

