/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ch.elexis.core.findings.IEncounter;
import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.IFindingsService;
import ch.elexis.core.findings.migration.IMigratorService;
import ch.elexis.core.findings.util.fhir.IFhirTransformer;
import ch.elexis.core.findings.util.fhir.transformer.helper.AbstractHelper;
import ch.elexis.core.findings.util.fhir.transformer.helper.FhirUtil;
import ch.elexis.core.findings.util.fhir.transformer.helper.FindingsContentHelper;
import ch.elexis.core.findings.util.fhir.transformer.helper.IEncounterHelper;
import ch.elexis.core.findings.util.fhir.transformer.mapper.IEncounterEncounterAttributeMapper;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IModelService;
import java.util.Optional;
import java.util.Set;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.BaseResource;
import org.hl7.fhir.r4.model.Encounter;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.LoggerFactory;

@Component
public class EncounterIEncounterTransformer
implements IFhirTransformer<Encounter, IEncounter> {
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService coreModelService;
    @Reference(target="(service.model.name=ch.elexis.core.findings.model)")
    private IModelService findingsModelService;
    @Reference
    private IFindingsService findingsService;
    @Reference
    private IMigratorService migratorService;
    private FindingsContentHelper contentHelper;
    private IEncounterHelper encounterHelper;
    private IEncounterEncounterAttributeMapper attributeMapper;

    @Activate
    public void activate() {
        this.contentHelper = new FindingsContentHelper();
        this.encounterHelper = new IEncounterHelper(this.coreModelService, this.findingsModelService);
        this.attributeMapper = new IEncounterEncounterAttributeMapper();
    }

    @Override
    public Optional<Encounter> getFhirObject(IEncounter localObject, SummaryEnum summaryEnum, Set<Include> includes) {
        Optional<IBaseResource> resource = this.contentHelper.getResource((IFinding)localObject);
        if (resource.isPresent()) {
            return Optional.of((Encounter)resource.get());
        }
        return Optional.empty();
    }

    @Override
    public Optional<IEncounter> getLocalObject(Encounter fhirObject) {
        Optional<String> localId;
        if (fhirObject != null && fhirObject.getId() != null && (localId = FhirUtil.getLocalId(fhirObject.getId())).isPresent()) {
            return this.findingsService.findById(localId.get(), IEncounter.class);
        }
        return Optional.empty();
    }

    @Override
    public Optional<IEncounter> updateLocalObject(Encounter fhirObject, IEncounter localObject) {
        Optional behandlung = this.coreModelService.load(localObject.getConsultationId(), ch.elexis.core.model.IEncounter.class);
        behandlung.ifPresent(cons -> {
            this.attributeMapper.fhirToElexis(fhirObject, (ch.elexis.core.model.IEncounter)cons);
            this.migratorService.migrateConsultationsFindings(localObject.getConsultationId(), IEncounter.class);
        });
        return Optional.empty();
    }

    @Override
    public Optional<IEncounter> createLocalObject(Encounter fhirObject) {
        Optional performerKontakt = this.coreModelService.load(this.encounterHelper.getMandatorId(fhirObject).get(), IMandator.class);
        Optional patientKontakt = this.coreModelService.load(this.encounterHelper.getPatientId(fhirObject).get(), IPatient.class);
        if (performerKontakt.isPresent() && patientKontakt.isPresent()) {
            IEncounter iEncounter = (IEncounter)this.findingsService.create(IEncounter.class);
            this.contentHelper.setResource((BaseResource)fhirObject, (IFinding)iEncounter);
            patientKontakt.ifPresent(k -> iEncounter.setPatientId(k.getId()));
            performerKontakt.ifPresent(k -> iEncounter.setMandatorId(k.getId()));
            this.encounterHelper.createIEncounter(iEncounter).ifPresent(cons -> {
                iEncounter.setConsultationId(cons.getId());
                this.attributeMapper.fhirToElexis(fhirObject, (ch.elexis.core.model.IEncounter)cons);
                this.coreModelService.save((Identifiable)cons);
                AbstractHelper.acquireAndReleaseLock((Identifiable)cons);
            });
            this.findingsService.saveFinding((IFinding)iEncounter);
            return Optional.of(iEncounter);
        }
        LoggerFactory.getLogger(EncounterIEncounterTransformer.class).warn("Could not create encounter for mandator [" + performerKontakt + "] patient [" + patientKontakt + "]");
        return Optional.empty();
    }

    @Override
    public boolean matchesTypes(Class<?> fhirClazz, Class<?> localClazz) {
        return Encounter.class.equals(fhirClazz) && IEncounter.class.equals(localClazz);
    }
}

