/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ch.elexis.core.findings.util.fhir.IFhirTransformer;
import ch.elexis.core.findings.util.fhir.transformer.helper.AbstractHelper;
import ch.elexis.core.findings.util.fhir.transformer.helper.FhirUtil;
import ch.elexis.core.findings.util.fhir.transformer.helper.IEncounterHelper;
import ch.elexis.core.findings.util.fhir.transformer.mapper.IEncounterEncounterAttributeMapper;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.builder.IEncounterBuilder;
import ch.elexis.core.services.IModelService;
import java.util.Optional;
import java.util.Set;
import org.hl7.fhir.r4.model.Encounter;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.LoggerFactory;

@Component
public class EncounterCoreIEncounterTransformer
implements IFhirTransformer<Encounter, IEncounter> {
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService coreModelService;
    private IEncounterEncounterAttributeMapper attributeMapper;
    private IEncounterHelper encounterHelper;

    @Activate
    public void activate() {
        this.attributeMapper = new IEncounterEncounterAttributeMapper();
        this.encounterHelper = new IEncounterHelper(this.coreModelService, null);
    }

    @Override
    public Optional<Encounter> getFhirObject(IEncounter localObject, SummaryEnum summaryEnum, Set<Include> includes) {
        Encounter encounter = new Encounter();
        this.attributeMapper.elexisToFhir(localObject, encounter, summaryEnum, includes);
        return Optional.of(encounter);
    }

    @Override
    public Optional<IEncounter> getLocalObject(Encounter fhirObject) {
        Optional<String> localId;
        if (fhirObject != null && fhirObject.getId() != null && (localId = FhirUtil.getLocalId(fhirObject.getId())).isPresent()) {
            return this.coreModelService.load(localId.get(), IEncounter.class);
        }
        return Optional.empty();
    }

    @Override
    public Optional<IEncounter> updateLocalObject(Encounter fhirObject, IEncounter localObject) {
        this.attributeMapper.fhirToElexis(fhirObject, localObject);
        this.coreModelService.save((Identifiable)localObject);
        return Optional.of(localObject);
    }

    @Override
    public Optional<IEncounter> createLocalObject(Encounter fhirObject) {
        Optional performerKontakt = this.coreModelService.load(this.encounterHelper.getMandatorId(fhirObject).get(), IMandator.class);
        Optional patientKontakt = this.coreModelService.load(this.encounterHelper.getPatientId(fhirObject).get(), IPatient.class);
        if (performerKontakt.isPresent() && patientKontakt.isPresent()) {
            ICoverage fall = this.encounterHelper.getOrCreateDefaultFall((IPatient)patientKontakt.get());
            IEncounter iEncounter = (IEncounter)new IEncounterBuilder(this.coreModelService, fall, (IMandator)performerKontakt.get()).build();
            this.attributeMapper.fhirToElexis(fhirObject, iEncounter);
            this.coreModelService.save((Identifiable)iEncounter);
            AbstractHelper.acquireAndReleaseLock((Identifiable)iEncounter);
            return Optional.of(iEncounter);
        }
        LoggerFactory.getLogger(EncounterCoreIEncounterTransformer.class).warn("Could not create encounter for mandator [" + performerKontakt + "] patient [" + patientKontakt + "]");
        return Optional.empty();
    }

    @Override
    public boolean matchesTypes(Class<?> fhirClazz, Class<?> localClazz) {
        return Encounter.class.equals(fhirClazz) && IEncounter.class.equals(localClazz);
    }
}

