/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util;

import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.IObservation;
import ch.elexis.core.findings.IObservationLink;
import ch.elexis.core.findings.ObservationComponent;
import ch.elexis.core.findings.codes.CodingSystem;
import ch.elexis.core.findings.util.FindingsServiceHolder;
import ch.elexis.core.findings.util.ModelUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;

public class FindingsTextUtil {
    public static String getGroupText(IObservation observation, boolean shouldSet) {
        StringBuilder stringBuilder = new StringBuilder();
        if (IObservation.ObservationType.REF.equals((Object)observation.getObservationType())) {
            String title = FindingsTextUtil.getNameText(observation);
            stringBuilder.append(title).append(": ");
            List children = observation.getTargetObseravtions(IObservationLink.ObservationLinkType.REF);
            int i = 0;
            while (i < children.size()) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(FindingsTextUtil.getObservationText((IObservation)children.get(i), shouldSet));
                ++i;
            }
            observation.getComment().ifPresent(comment -> {
                StringBuilder stringBuilder2 = stringBuilder.append(" ").append((String)comment);
            });
        } else {
            stringBuilder.append(FindingsTextUtil.getObservationText(observation, shouldSet));
        }
        if (shouldSet) {
            observation.setText(stringBuilder.toString());
            FindingsServiceHolder.getiFindingsService().saveFinding((IFinding)observation);
        }
        return stringBuilder.toString();
    }

    public static String getObservationText(IObservation observation, boolean shouldSet) {
        String title = FindingsTextUtil.getNameText(observation);
        String value = FindingsTextUtil.getValueText(observation);
        StringBuilder stringBuilder = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)title)) {
            stringBuilder.append(title).append(" ");
        }
        stringBuilder.append(value);
        if (shouldSet) {
            observation.setText(stringBuilder.toString());
            FindingsServiceHolder.getiFindingsService().saveFinding((IFinding)observation);
        }
        return stringBuilder.toString();
    }

    public static String getNameText(IObservation observation) {
        return ModelUtil.getCodeBySystem((List<ICoding>)observation.getCoding(), CodingSystem.ELEXIS_LOCAL_CODESYSTEM).map(ICoding::getDisplay).orElse("");
    }

    public static String getValueText(IObservation observation) {
        switch (observation.getObservationType()) {
            case TEXT: {
                return FindingsTextUtil.getStringValue(observation);
            }
            case NUMERIC: {
                return FindingsTextUtil.getNumericValue(observation);
            }
            case BOOLEAN: {
                return FindingsTextUtil.getBooleanValue(observation);
            }
            case DATE: {
                return FindingsTextUtil.getDateValue(observation);
            }
            case COMP: {
                return FindingsTextUtil.getCompValue(observation);
            }
        }
        LoggerFactory.getLogger(FindingsTextUtil.class).warn("Unknown ObservationType " + observation.getObservationType());
        return "";
    }

    public static String getStringValue(IObservation observation) {
        StringBuilder sb = new StringBuilder(observation.getStringValue().orElse(""));
        sb.append(FindingsTextUtil.getCommentText(observation));
        return sb.toString();
    }

    public static String getNumericValue(IObservation observation) {
        StringBuilder sb = new StringBuilder();
        observation.getNumericValue().ifPresent(value -> {
            StringBuilder stringBuilder2 = sb.append(value.toPlainString());
        });
        observation.getNumericValueUnit().ifPresent(unit -> {
            StringBuilder stringBuilder2 = sb.append(" ").append((String)unit);
        });
        sb.append(FindingsTextUtil.getCommentText(observation));
        return sb.toString();
    }

    public static String getBooleanValue(IObservation observation) {
        StringBuilder sb = new StringBuilder();
        observation.getBooleanValue().ifPresent(value -> {
            StringBuilder stringBuilder2 = sb.append(value != false ? "Ja" : "Nein");
        });
        sb.append(FindingsTextUtil.getCommentText(observation));
        return sb.toString();
    }

    public static String getDateValue(IObservation observation) {
        StringBuilder sb = new StringBuilder();
        observation.getDateTimeValue().ifPresent(date -> {
            StringBuilder stringBuilder2 = sb.append(new SimpleDateFormat("dd.MM.yyyy").format((Date)date));
        });
        sb.append(FindingsTextUtil.getCommentText(observation));
        return sb.toString();
    }

    public static String getCompValue(IObservation observation) {
        StringBuilder sb = new StringBuilder();
        String textSplitter = observation.getFormat("textSeparator");
        if (StringUtils.isEmpty((CharSequence)textSplitter)) {
            textSplitter = ", ";
        }
        List components = observation.getComponents();
        String exactUnit = ModelUtil.getExactUnitOfComponent(components);
        int i = 0;
        while (i < components.size()) {
            if (i > 0) {
                sb.append(textSplitter);
            }
            sb.append(FindingsTextUtil.getComponentText((ObservationComponent)components.get(i), exactUnit == null));
            ++i;
        }
        if (exactUnit != null) {
            sb.append(" ").append(exactUnit);
        }
        observation.getComment().ifPresent(comment -> {
            StringBuilder stringBuilder2 = sb.append(" [").append((String)comment).append("]");
        });
        return sb.toString();
    }

    private static String getCommentText(IObservation observation) {
        return observation.getComment().filter(StringUtils::isNotBlank).map(comment -> " [" + comment + "]").orElse("");
    }

    public static String getComponentText(ObservationComponent component, boolean showUnitInComponent) {
        StringBuilder sb = new StringBuilder();
        component.getNumericValue().ifPresent(value -> {
            StringBuilder stringBuilder2 = sb.append(value.toPlainString());
        });
        if (showUnitInComponent) {
            component.getNumericValueUnit().ifPresent(unit -> {
                StringBuilder stringBuilder2 = sb.append(" ").append((String)unit);
            });
        }
        return sb.toString();
    }
}

