/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.templates.ui.composite;

import ch.elexis.core.data.interfaces.ICodeElement;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.codes.CodingSystem;
import ch.elexis.core.findings.templates.model.CodeElement;
import ch.elexis.core.findings.templates.model.DataType;
import ch.elexis.core.findings.templates.model.FindingsTemplate;
import ch.elexis.core.findings.templates.model.FindingsTemplates;
import ch.elexis.core.findings.templates.model.InputData;
import ch.elexis.core.findings.templates.model.InputDataBoolean;
import ch.elexis.core.findings.templates.model.InputDataDate;
import ch.elexis.core.findings.templates.model.InputDataGroup;
import ch.elexis.core.findings.templates.model.InputDataGroupComponent;
import ch.elexis.core.findings.templates.model.InputDataNumeric;
import ch.elexis.core.findings.templates.model.InputDataText;
import ch.elexis.core.findings.templates.model.ModelFactory;
import ch.elexis.core.findings.templates.model.ModelPackage;
import ch.elexis.core.findings.templates.model.Type;
import ch.elexis.core.findings.templates.ui.dlg.FindingsSelectionDialog;
import ch.elexis.core.findings.templates.ui.util.FindingsServiceHolder;
import ch.elexis.core.findings.util.model.TransientCoding;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.dialogs.base.InputDialog;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.WidgetFactory;
import ch.elexis.core.ui.views.codesystems.CodeSelectorFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.EMFUpdateValueStrategy;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.SelectionDialog;

public class FindingsDetailComposite
extends Composite {
    private WritableValue<FindingsTemplate> item = new WritableValue(null, FindingsTemplate.class);
    private Text textTitle;
    private Text textUnit;
    private Text txtComma;
    private ComboViewer comboType;
    private ComboViewer comboInputData;
    FindingsTemplate selection;
    private Composite compositeType;
    private Composite compositeInputData;
    private GridData minGd;
    private FindingsTemplates model;
    private Text loincCode;
    private boolean openedFromDialog;
    private List<FindingsTemplate> findingTemplatesToMove = new ArrayList<FindingsTemplate>();
    private Label lblColorCooser;

    public FindingsDetailComposite(Composite parent, FindingsTemplates model, boolean openedFromDialog) {
        super(parent, 0);
        this.setLayout((Layout)new GridLayout(2, false));
        this.setLayoutData(new GridData(4, 4, true, true));
        this.model = model;
        this.openedFromDialog = openedFromDialog;
        this.findingTemplatesToMove.clear();
    }

    public void createContents() {
        Label lblTitle = new Label((Composite)this, 0);
        lblTitle.setText("Titel");
        this.minGd = new GridData(16384, 0x1000000, false, false, 1, 1);
        this.minGd.widthHint = 100;
        lblTitle.setLayoutData((Object)this.minGd);
        this.textTitle = new Text((Composite)this, 2048);
        this.textTitle.setLayoutData((Object)new GridData(4, 4, true, false));
        Label lblType = new Label((Composite)this, 0);
        lblType.setText("Typ");
        this.comboType = new ComboViewer((Composite)this, 2056);
        ObservableListContentProvider contentProvider = new ObservableListContentProvider();
        this.comboType.setContentProvider((IContentProvider)contentProvider);
        this.comboType.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(EMFProperties.value((EStructuralFeature)ModelPackage.Literals.INPUT_DATA_GROUP__DATA_TYPE).observeDetail(contentProvider.getKnownElements())));
        this.comboType.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.comboType.setLabelProvider((IBaseLabelProvider)new ComboTypeLabelProvider());
        this.comboType.setInput((Object)new Type[]{Type.OBSERVATION_VITAL});
        this.comboType.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Type type = (Type)((StructuredSelection)event.getSelection()).getFirstElement();
                FindingsDetailComposite.this.selection.setType(type);
                if (type.getValue() < 100) {
                    FindingsDetailComposite.this.compositeType.setVisible(true);
                } else {
                    FindingsDetailComposite.this.compositeType.setVisible(false);
                    FindingsDetailComposite.this.selection.setInputData(null);
                }
            }
        });
        this.compositeType = new Composite((Composite)this, 0);
        this.compositeType.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        this.compositeType.setLayout((Layout)gl);
        Label lblColor = new Label((Composite)this, 0);
        lblColor.setText("Farbe");
        this.lblColorCooser = new Label((Composite)this, 0);
        this.lblColorCooser.setText("\u00e4ndern..");
        this.lblColorCooser.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (FindingsDetailComposite.this.selection == null) {
                    return;
                }
                ColorDialog cd = new ColorDialog(UiDesk.getTopShell());
                cd.setRGB(FindingsDetailComposite.this.lblColorCooser.getBackground().getRGB());
                RGB rgb = cd.open();
                if (rgb != null) {
                    String colorString = UiDesk.createColor((RGB)rgb);
                    FindingsTemplate template = FindingsDetailComposite.this.selection;
                    template.setColor(colorString);
                    FindingsDetailComposite.this.lblColorCooser.setBackground(CoreUiUtil.getColorForString((String)colorString));
                    FindingsDetailComposite.this.lblColorCooser.redraw();
                }
            }
        });
        WidgetFactory.createLabel((Composite)this, (String)"LOINC");
        Composite codesComposite = new Composite((Composite)this, 0);
        codesComposite.setLayout((Layout)SWTHelper.createGridLayout((boolean)true, (int)2));
        codesComposite.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.loincCode = new Text(codesComposite, 2056);
        this.loincCode.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.loincCode.setTextLimit(80);
        Button loincCodeSelection = new Button(codesComposite, 8);
        loincCodeSelection.setText("...");
        loincCodeSelection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectionDialog dialog = CodeSelectorFactory.getSelectionDialog((String)"LOINC", (Shell)FindingsDetailComposite.this.getShell(), (Object)"ignoreErrors");
                if (dialog.open() == 0) {
                    if (dialog.getResult() != null && dialog.getResult().length > 0) {
                        FindingsDetailComposite.this.selectCode(Optional.of((ICodeElement)dialog.getResult()[0]));
                    } else {
                        FindingsDetailComposite.this.selectCode(Optional.empty());
                    }
                }
            }
        });
        this.createObservationComposite();
        DataBindingContext bindingContext = new DataBindingContext();
        ISWTObservableValue observeTextTitle = WidgetProperties.text((int)24).observe((Widget)this.textTitle);
        IObservableValue observeValueTextTitle = EMFProperties.value((EStructuralFeature)ModelPackage.Literals.FINDINGS_TEMPLATE__TITLE).observeDetail(this.item);
        UpdateValueStrategy modelToTarget = new UpdateValueStrategy();
        UpdateValueStrategy targetToModel = new UpdateValueStrategy();
        targetToModel.setBeforeSetValidator((IValidator)new IValidator<String>(){

            public IStatus validate(String value) {
                Optional existing = FindingsServiceHolder.findingsTemplateService.getFindingsTemplate((ICoding)new TransientCoding(CodingSystem.ELEXIS_LOCAL_CODESYSTEM.getSystem(), value, ""));
                if (existing.isPresent()) {
                    return ValidationStatus.error((String)("Eine lokale Vorlage mit dem Code [" + value + "] existiert bereits."));
                }
                return ValidationStatus.ok();
            }
        });
        Binding bindValue = bindingContext.bindValue((IObservableValue)observeTextTitle, observeValueTextTitle, targetToModel, modelToTarget);
        ControlDecorationSupport.create((ValidationStatusProvider)bindValue, (int)16512);
        this.setVisible(false);
    }

    private void selectCode(Optional<ICodeElement> optionalCodeElement) {
        this.loincCode.setText("");
        this.loincCode.setToolTipText("");
        if (this.selection != null) {
            if (optionalCodeElement != null) {
                if (optionalCodeElement.isPresent()) {
                    CodeElement codeElement = ModelFactory.eINSTANCE.createCodeElement();
                    codeElement.setCode(optionalCodeElement.get().getCode());
                    codeElement.setDisplay(optionalCodeElement.get().getText());
                    codeElement.setSystem(optionalCodeElement.get().getCodeSystemName());
                    this.selection.setCodeElement(codeElement);
                } else {
                    this.selection.setCodeElement(null);
                }
            }
            if (this.selection.getCodeElement() != null) {
                this.loincCode.setText(String.valueOf(this.selection.getCodeElement().getCode()) + ": " + this.selection.getCodeElement().getDisplay());
                this.loincCode.setToolTipText(this.selection.getCodeElement().getDisplay());
            }
        }
    }

    public void createObservationComposite() {
        Label lblType = new Label(this.compositeType, 0);
        lblType.setText("Datentyp");
        lblType.setLayoutData((Object)this.minGd);
        this.comboInputData = new ComboViewer(this.compositeType, 2056);
        ObservableListContentProvider contentProvider = new ObservableListContentProvider();
        this.comboInputData.setContentProvider((IContentProvider)contentProvider);
        this.comboInputData.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(EMFProperties.value((EStructuralFeature)ModelPackage.Literals.INPUT_DATA_NUMERIC__DATA_TYPE).observeDetail(contentProvider.getKnownElements())));
        this.comboInputData.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.comboInputData.setLabelProvider((IBaseLabelProvider)new ComboInputDataTypeLabelProvider());
        this.comboInputData.setInput((Object)DataType.VALUES);
        this.compositeInputData = new Composite(this.compositeType, 0);
        this.compositeInputData.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        this.compositeInputData.setLayout((Layout)gl);
        this.comboInputData.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                FindingsDetailComposite.this.updateInputData((DataType)((StructuredSelection)event.getSelection()).getFirstElement());
                FindingsDetailComposite.this.updateSize();
            }
        });
    }

    private void updateSize() {
        this.layout(true, true);
    }

    private void updateInputData(DataType dataType) {
        Control[] controlArray = this.compositeInputData.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
        this.layout(true, true);
        switch (dataType) {
            case GROUP: {
                final InputDataGroup inputDataGroup = this.selection.getInputData() instanceof InputDataGroup ? (InputDataGroup)this.selection.getInputData() : ModelFactory.eINSTANCE.createInputDataGroup();
                Label lblGroup = new Label(this.compositeInputData, 0);
                lblGroup.setText("Gruppe (Referenz)");
                lblGroup.setLayoutData((Object)this.minGd);
                Composite c = new Composite(this.compositeInputData, 0);
                c.setLayout((Layout)new GridLayout(2, false));
                c.setLayoutData((Object)new GridData(4, 4, false, false));
                final Label lblGrouplist = new Label(c, 0);
                lblGrouplist.setText(this.getInputDataGroupText((InputData)inputDataGroup));
                Button button = new Button(c, 8);
                button.setText("\u00e4ndern..");
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        FindingsSelectionDialog findingsSelectionDialog = new FindingsSelectionDialog(FindingsDetailComposite.this.getShell(), FindingsDetailComposite.this.model, (List<FindingsTemplate>)inputDataGroup.getFindingsTemplates(), true, FindingsDetailComposite.this.selection, true);
                        if (findingsSelectionDialog.open() == 0) {
                            inputDataGroup.getFindingsTemplates().clear();
                            for (FindingsTemplate findingsTemplate : findingsSelectionDialog.getSelection()) {
                                inputDataGroup.getFindingsTemplates().add((Object)findingsTemplate);
                                try {
                                    FindingsServiceHolder.findingsTemplateService.validateCycleDetection(FindingsDetailComposite.this.selection, 0, 100);
                                }
                                catch (ElexisException e1) {
                                    inputDataGroup.getFindingsTemplates().remove((Object)findingsTemplate);
                                    MessageDialog.openError((Shell)FindingsDetailComposite.this.getShell(), (String)"Befunde Vorlagen", (String)e1.getMessage());
                                }
                            }
                            FindingsDetailComposite.this.selection.setInputData((InputData)inputDataGroup);
                            lblGrouplist.setText(FindingsDetailComposite.this.getInputDataGroupText((InputData)inputDataGroup));
                            FindingsDetailComposite.this.compositeInputData.layout(true, true);
                            FindingsDetailComposite.this.updateSize();
                        }
                    }
                });
                this.selection.setInputData((InputData)inputDataGroup);
                this.compositeInputData.layout();
                break;
            }
            case GROUP_COMPONENT: {
                final InputDataGroupComponent inputDataGroupComponent = this.selection.getInputData() instanceof InputDataGroupComponent ? (InputDataGroupComponent)this.selection.getInputData() : ModelFactory.eINSTANCE.createInputDataGroupComponent();
                Label lblGroupComponent = new Label(this.compositeInputData, 0);
                lblGroupComponent.setText("Gruppe (Umfasst)");
                lblGroupComponent.setLayoutData((Object)this.minGd);
                Composite cGroupComponent = new Composite(this.compositeInputData, 0);
                cGroupComponent.setLayout((Layout)new GridLayout(2, false));
                cGroupComponent.setLayoutData((Object)new GridData(4, 4, false, false));
                final Label lblGroupComponentlist = new Label(cGroupComponent, 0);
                lblGroupComponentlist.setText(this.getInputDataGroupText((InputData)inputDataGroupComponent));
                Button buttonGroupComponent = new Button(cGroupComponent, 8);
                buttonGroupComponent.setText("\u00e4ndern..");
                buttonGroupComponent.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        FindingsSelectionDialog findingsSelectionDialog = new FindingsSelectionDialog(FindingsDetailComposite.this.getShell(), FindingsDetailComposite.this.model, (List<FindingsTemplate>)(FindingsDetailComposite.this.openedFromDialog ? FindingsDetailComposite.this.findingTemplatesToMove : inputDataGroupComponent.getFindingsTemplates()), true, FindingsDetailComposite.this.selection, true);
                        if (findingsSelectionDialog.open() == 0) {
                            FindingsDetailComposite.this.findingTemplatesToMove.clear();
                            for (FindingsTemplate findingsTemplate : findingsSelectionDialog.getSelection()) {
                                FindingsDetailComposite.this.findingTemplatesToMove.add(findingsTemplate);
                            }
                            if (!FindingsDetailComposite.this.openedFromDialog) {
                                FindingsDetailComposite.this.moveCachedFindingsTemplates();
                            }
                            lblGroupComponentlist.setText(FindingsDetailComposite.this.getInputDataGroupText((InputData)inputDataGroupComponent));
                            FindingsDetailComposite.this.selection.setInputData((InputData)inputDataGroupComponent);
                            FindingsDetailComposite.this.compositeInputData.layout(true, true);
                            FindingsDetailComposite.this.updateSize();
                        }
                    }
                });
                Label lblSeparator = new Label(this.compositeInputData, 0);
                lblSeparator.setText("Trenntext");
                Text txtSeparator = new Text(this.compositeInputData, 2048);
                GridData gdTxtSeparator = new GridData(16384, 0x1000000, false, false);
                gdTxtSeparator.widthHint = 60;
                txtSeparator.setLayoutData((Object)gdTxtSeparator);
                DataBindingContext dataBindingContext = new DataBindingContext();
                ISWTObservableValue wTextUnit = WidgetProperties.text((int)24).observe((Widget)txtSeparator);
                IObservableValue mTextUnit = EMFProperties.value((EStructuralFeature)ModelPackage.Literals.INPUT_DATA_GROUP_COMPONENT__TEXT_SEPARATOR).observe((Object)inputDataGroupComponent);
                dataBindingContext.bindValue((IObservableValue)wTextUnit, mTextUnit);
                this.selection.setInputData((InputData)inputDataGroupComponent);
                this.compositeInputData.layout();
                break;
            }
            case NUMERIC: {
                final InputDataNumeric inputDataNumeric = this.selection.getInputData() instanceof InputDataNumeric ? (InputDataNumeric)this.selection.getInputData() : ModelFactory.eINSTANCE.createInputDataNumeric();
                Label lblUnit = new Label(this.compositeInputData, 0);
                lblUnit.setText("Einheit");
                lblUnit.setLayoutData((Object)this.minGd);
                this.textUnit = new Text(this.compositeInputData, 2048);
                this.textUnit.setLayoutData((Object)new GridData(4, 4, true, false));
                Label lblComma = new Label(this.compositeInputData, 0);
                lblComma.setText("Kommastellen");
                this.txtComma = new Text(this.compositeInputData, 2048);
                this.txtComma.setLayoutData((Object)new GridData(4, 4, true, false));
                DataBindingContext ctx = new DataBindingContext();
                ISWTObservableValue widgetValue = WidgetProperties.text((int)24).observe((Widget)this.txtComma);
                IObservableValue modelValue = EMFProperties.value((EStructuralFeature)ModelPackage.Literals.INPUT_DATA_NUMERIC__DECIMAL_PLACE).observe((Object)inputDataNumeric);
                EMFUpdateValueStrategy modelToTarget = new EMFUpdateValueStrategy();
                modelToTarget.setConverter((IConverter)new Converter(Integer.class, String.class){

                    public Object convert(Object fromObject) {
                        return "" + fromObject;
                    }
                });
                EMFUpdateValueStrategy targetToModel = new EMFUpdateValueStrategy();
                targetToModel.setConverter((IConverter)new Converter(String.class, Integer.class){

                    public Object convert(Object fromObject) {
                        try {
                            return Integer.parseInt((String)fromObject);
                        }
                        catch (NumberFormatException e) {
                            return 0;
                        }
                    }
                });
                ctx.bindValue((IObservableValue)widgetValue, modelValue, (UpdateValueStrategy)targetToModel, (UpdateValueStrategy)modelToTarget);
                widgetValue = WidgetProperties.text((int)24).observe((Widget)this.textUnit);
                modelValue = EMFProperties.value((EStructuralFeature)ModelPackage.Literals.INPUT_DATA_NUMERIC__UNIT).observe((Object)inputDataNumeric);
                ctx.bindValue((IObservableValue)widgetValue, modelValue);
                Label lblScript = new Label(this.compositeInputData, 0);
                lblScript.setText("Script");
                Button btnScript = new Button(this.compositeInputData, 8);
                widgetValue = WidgetProperties.text().observe((Widget)btnScript);
                modelValue = EMFProperties.value((EStructuralFeature)ModelPackage.Literals.INPUT_DATA_NUMERIC__SCRIPT).observe((Object)inputDataNumeric);
                modelToTarget = new EMFUpdateValueStrategy();
                modelToTarget.setConverter((IConverter)new Converter(String.class, String.class){

                    public Object convert(Object fromObject) {
                        if (fromObject instanceof String && !((String)fromObject).isEmpty()) {
                            return "Script editieren";
                        }
                        return "Script anlegen";
                    }
                });
                targetToModel = new EMFUpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER);
                ctx.bindValue((IObservableValue)widgetValue, modelValue, (UpdateValueStrategy)targetToModel, (UpdateValueStrategy)modelToTarget);
                btnScript.setLayoutData((Object)new GridData(4, 4, true, false));
                btnScript.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        String newScript;
                        InputDialog inputDialog = new InputDialog(FindingsDetailComposite.this.getShell(), "Script editieren", "Bitte geben Sie das Script ein", inputDataNumeric.getScript(), null, 2626);
                        if (inputDialog.open() == 0 && (newScript = inputDialog.getValue()) != null) {
                            inputDataNumeric.setScript(newScript);
                        }
                    }
                });
                this.selection.setInputData((InputData)inputDataNumeric);
                this.compositeInputData.layout();
                break;
            }
            case TEXT: {
                InputDataText inputDataText = this.selection.getInputData() instanceof InputDataText ? (InputDataText)this.selection.getInputData() : ModelFactory.eINSTANCE.createInputDataText();
                this.selection.setInputData((InputData)inputDataText);
                break;
            }
            case BOOLEAN: {
                InputDataBoolean inputDataBoolean = this.selection.getInputData() instanceof InputDataBoolean ? (InputDataBoolean)this.selection.getInputData() : ModelFactory.eINSTANCE.createInputDataBoolean();
                this.selection.setInputData((InputData)inputDataBoolean);
                break;
            }
            case DATE: {
                InputDataDate inputDataDate = this.selection.getInputData() instanceof InputDataDate ? (InputDataDate)this.selection.getInputData() : ModelFactory.eINSTANCE.createInputDataDate();
                this.selection.setInputData((InputData)inputDataDate);
                break;
            }
        }
    }

    private String getInputDataGroupText(InputData inputData) {
        EList findingsTemplates = new ArrayList();
        if (inputData instanceof InputDataGroup) {
            findingsTemplates = ((InputDataGroup)inputData).getFindingsTemplates();
        } else if (inputData instanceof InputDataGroupComponent) {
            if (this.openedFromDialog) {
                findingsTemplates.addAll(this.findingTemplatesToMove);
            } else {
                findingsTemplates = ((InputDataGroupComponent)inputData).getFindingsTemplates();
            }
        }
        StringBuffer buf = new StringBuffer();
        for (FindingsTemplate findingsTemplate : findingsTemplates) {
            if (buf.length() > 0) {
                buf.append("\n");
            }
            buf.append(findingsTemplate.getTitle());
        }
        return buf.length() == 0 ? "Nicht definiert" : buf.toString();
    }

    public void setSelection(FindingsTemplates model, FindingsTemplate selection) {
        this.model = model;
        this.selection = selection;
        if (selection != null) {
            this.item.setValue((Object)selection);
            this.comboType.setSelection((ISelection)new StructuredSelection((Object)selection.getType()));
            if (selection.getInputData() instanceof InputDataNumeric) {
                this.comboInputData.setSelection((ISelection)new StructuredSelection((Object)DataType.NUMERIC));
            } else if (selection.getInputData() instanceof InputDataText) {
                this.comboInputData.setSelection((ISelection)new StructuredSelection((Object)DataType.TEXT));
            } else if (selection.getInputData() instanceof InputDataGroup) {
                this.comboInputData.setSelection((ISelection)new StructuredSelection((Object)((InputDataGroup)selection.getInputData()).getDataType()));
            } else if (selection.getInputData() instanceof InputDataGroupComponent) {
                this.comboInputData.setSelection((ISelection)new StructuredSelection((Object)((InputDataGroupComponent)selection.getInputData()).getDataType()));
            } else if (selection.getInputData() instanceof InputDataDate) {
                this.comboInputData.setSelection((ISelection)new StructuredSelection((Object)DataType.DATE));
            } else if (selection.getInputData() instanceof InputDataBoolean) {
                this.comboInputData.setSelection((ISelection)new StructuredSelection((Object)DataType.BOOLEAN));
            }
            if (selection.getColor() != null && StringUtils.isNotBlank((CharSequence)selection.getColor())) {
                this.lblColorCooser.setBackground(CoreUiUtil.getColorForString((String)selection.getColor()));
            } else {
                this.lblColorCooser.setBackground(UiDesk.getColor((String)"hellgrau"));
            }
            this.selectCode(null);
            this.setVisible(true);
        } else {
            this.setVisible(false);
        }
        this.layout();
    }

    public void moveCachedFindingsTemplates() {
        if (this.selection.getInputData() instanceof InputDataGroupComponent) {
            ArrayList<FindingsTemplate> findingsToMoveToRoot = new ArrayList<FindingsTemplate>();
            if (!this.openedFromDialog) {
                for (FindingsTemplate findingsTemplate : ((InputDataGroupComponent)this.selection.getInputData()).getFindingsTemplates()) {
                    if (this.findingTemplatesToMove.contains(findingsTemplate)) continue;
                    findingsToMoveToRoot.add(findingsTemplate);
                }
            }
            ((InputDataGroupComponent)this.selection.getInputData()).getFindingsTemplates().clear();
            for (FindingsTemplate findingsTemplate : this.findingTemplatesToMove) {
                EcoreUtil.remove((EObject)findingsTemplate);
                ((InputDataGroupComponent)this.selection.getInputData()).getFindingsTemplates().add((Object)findingsTemplate);
            }
            for (FindingsTemplate findingsTemplate : findingsToMoveToRoot) {
                EcoreUtil.remove((EObject)findingsTemplate);
                this.model.getFindingsTemplates().add((Object)findingsTemplate);
            }
        }
        this.findingTemplatesToMove.clear();
    }

    public FindingsTemplate getResult() {
        if (this.openedFromDialog) {
            this.moveCachedFindingsTemplates();
        }
        return this.selection;
    }

    class ComboInputDataTypeLabelProvider
    extends LabelProvider {
        ComboInputDataTypeLabelProvider() {
        }

        public String getText(Object element) {
            return FindingsServiceHolder.findingsTemplateService.getDataTypeAsText((DataType)element);
        }
    }

    class ComboTypeLabelProvider
    extends LabelProvider {
        ComboTypeLabelProvider() {
        }

        public String getText(Object element) {
            return FindingsServiceHolder.findingsTemplateService.getTypeAsText((Type)element);
        }
    }
}

