/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.ac.EvACE;
import ch.elexis.core.ac.EvaluatableACE;
import ch.elexis.core.ac.Right;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.interfaces.IPersistentObject;
import ch.elexis.core.data.service.CoreModelServiceHolder;
import ch.elexis.core.events.MessageEvent;
import ch.elexis.core.jdt.Nullable;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IInvoice;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.services.holder.AccessControlServiceHolder;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.data.AccountTransaction;
import ch.elexis.data.Artikel;
import ch.elexis.data.Brief;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Kontakt;
import ch.elexis.data.LabResult;
import ch.elexis.data.Mandant;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Person;
import ch.elexis.data.Prescription;
import ch.elexis.data.Query;
import ch.elexis.data.Rechnung;
import ch.elexis.data.Rezept;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.Money;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.LoggerFactory;

public class Patient
extends Person {
    public static final String FLD_ALLERGIES = "Allergien";
    public static final String FLD_RISKS = "Risiken";
    public static final String FLD_GROUP = "Gruppe";
    public static final String FLD_DIAGNOSES = "Diagnosen";
    public static final String FLD_PATID = "PatientNr";
    public static final String FLD_NAME = "Name";
    public static final String FLD_FIRSTNAME = "Vorname";
    public static final String FLD_SEX = "Geschlecht";
    public static final String FLD_DOB = "Geburtsdatum";
    public static final String FLD_STREET = "Strasse";
    public static final String FLD_ZIP = "Plz";
    public static final String FLD_PLACE = "Ort";
    public static final String FLD_PHONE1 = "Telefon1";
    public static final String FLD_FAX = "Fax";
    public static final String FLD_BALANCE = "Konto";
    public static final String FLD_PERS_ANAMNESE = "PersAnamnese";
    public static final String FLD_SYS_ANAMNESE = "SysAnamnese";
    public static final String FLD_FAM_ANAMNESE = "FamilienAnamnese";
    public static final String[] DEFAULT_SORT = new String[]{"Name", "Vorname", "Geburtsdatum"};

    static {
        Patient.addMapping("KONTAKT", "Diagnosen    \t=S:C:Diagnosen", "PersAnamnese\t=S:C:PersAnamnese", "SystemAnamnese\t \t=S:C:SysAnamnese", "FamilienAnamnese\t=S:C:FamAnamnese", FLD_RISKS, FLD_ALLERGIES, "Faelle\t\t\t\t=LIST:PatientID:FAELLE:DatumVon", "Garanten\t\t\t=JOINT:GarantID:PatientID:PATIENT_GARANT_JOINT:" + Kontakt.class.getCanonicalName(), "Dauermedikation\t=JOINT:ArtikelID:PatientID:PATIENT_ARTIKEL_JOINT:" + Artikel.class.getCanonicalName(), "Konto\t\t\t=LIST:PatientID:KONTO", FLD_GROUP, FLD_PATID, "istPatient");
    }

    public String getDiagnosen() {
        return this.get(FLD_DIAGNOSES);
    }

    public String getPersAnamnese() {
        return this.get(FLD_PERS_ANAMNESE);
    }

    public String getSystemAnamnese() {
        return this.get("Systemanamnese");
    }

    protected Patient() {
    }

    @Override
    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        String geb = this.get(FLD_DOB);
        if (geb.equals("WERT?")) {
            return false;
        }
        String g = this.get(FLD_SEX);
        return g.equals("m") || g.equals("w");
    }

    public Patient(String Name, String Vorname, String Geburtsdatum, String s) {
        super(Name, Vorname, Geburtsdatum, s);
        this.getPatCode();
    }

    public Patient(String name, String vorname, TimeTool gebDat, String s) throws Person.PersonDataException {
        super(name, vorname, gebDat, s);
        this.getPatCode();
    }

    public Fall[] getFaelle() {
        List<String> cas = this.getList("Faelle", true);
        Fall[] ret = new Fall[cas.size()];
        int i = 0;
        for (String id : cas) {
            Fall fall = Fall.load(id);
            fall.setDBConnection(this.getDBConnection());
            ret[i++] = fall;
        }
        return ret;
    }

    public List<Prescription> getMedication(EntryType ... filterType) {
        Query qbe = new Query(Prescription.class, null, null, "PATIENT_ARTIKEL_JOINT", new String[]{"DateUntil", "RezeptID", "prescType", "Artikel"});
        qbe.add("PatientID", "=", this.getId());
        List prescriptions = qbe.execute();
        TimeTool now = new TimeTool();
        now.add(13, 10);
        if (filterType != null && filterType.length > 0) {
            EnumSet<EntryType> entryTypes = EnumSet.copyOf(Arrays.asList(filterType));
            return prescriptions.parallelStream().filter(p -> entryTypes.contains(p.getEntryType()) && !p.isStopped(now)).collect(Collectors.toList());
        }
        return prescriptions.parallelStream().filter(p -> !p.isStopped(now)).collect(Collectors.toList());
    }

    public String getMedicationText(@Nullable EntryType filterType) {
        List<Prescription> prescriptions = this.getMedication(filterType);
        StringBuilder sb = new StringBuilder();
        prescriptions.stream().forEach(p -> {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(p.getLabel());
        });
        return sb.toString();
    }

    public Prescription[] getFixmedikation() {
        Query qbe = new Query(Prescription.class);
        qbe.add("PatientID", "=", this.getId());
        qbe.add("RezeptID", "", null);
        String today = new TimeTool().toString(9);
        qbe.startGroup();
        qbe.add("DateUntil", ">=", today);
        qbe.or();
        qbe.add("DateUntil", "", null);
        qbe.endGroup();
        List<Prescription> l = qbe.execute();
        return l.toArray(new Prescription[0]);
    }

    public String getSymptomatischeMedikation() {
        return this.getMedicationText(EntryType.SYMPTOMATIC_MEDICATION);
    }

    public String getReserveMedikation() {
        return this.getMedicationText(EntryType.RESERVE_MEDICATION);
    }

    public String getMedikation() {
        return this.getMedicationText(EntryType.FIXED_MEDICATION);
    }

    public Konsultation getLetzteKons(boolean create) {
        return this.getKonsulationByDate(create, null);
    }

    public Konsultation getKonsulationByDate(boolean create, Date konsDate) {
        Fall[] faelle;
        Mandant mandator;
        if (ElexisEventDispatcher.getSelectedMandator() == null) {
            MessageEvent.fireError((String)"Kein Mandant angemeldet", (String)"Es ist kein Mandant angemeldet.");
            return null;
        }
        Query qbe = new Query(Konsultation.class);
        if (!ConfigServiceHolder.getUser((String)"fall/load_consall", (boolean)false) && (mandator = ElexisEventDispatcher.getSelectedMandator()) != null) {
            qbe.add("MandantID", "=", mandator.getId());
        }
        if (konsDate != null) {
            qbe.add("Datum", "=", new TimeTool(konsDate).toString(9));
        }
        if ((faelle = this.getFaelle()) == null || faelle.length == 0) {
            return create ? this.createFallUndKons() : null;
        }
        qbe.startGroup();
        boolean termInserted = false;
        Fall[] fallArray = faelle;
        int n = faelle.length;
        int n2 = 0;
        while (n2 < n) {
            Fall fall = fallArray[n2];
            if (fall.isOpen()) {
                qbe.add("FallID", "=", fall.getId());
                qbe.or();
                termInserted = true;
            }
            ++n2;
        }
        if (!termInserted) {
            return create ? this.createFallUndKons() : null;
        }
        qbe.endGroup();
        qbe.orderBy(true, "Datum");
        List list = qbe.execute();
        if (list == null || list.isEmpty()) {
            return null;
        }
        return (Konsultation)list.get(0);
    }

    public Konsultation getLastKonsultation() {
        Konsultation fromDB = null;
        if (this.getId() != null) {
            PreparedStatement preparedStatement = PersistentObject.getDefaultConnection().getPreparedStatement("SELECT BH.id FROM BEHANDLUNGEN BH LEFT JOIN FAELLE FA ON BH.FallID = FA.id AND BH.deleted = FA.deleted WHERE FA.PatientID = ? and FA.deleted = '0' order by BH.Datum desc, BH.lastupdate desc limit 1");
            try {
                try {
                    preparedStatement.setString(1, this.getId());
                    ResultSet results = preparedStatement.executeQuery();
                    if (results != null && results.next()) {
                        String consId = results.getString(1);
                        fromDB = Konsultation.load(consId);
                    }
                }
                catch (SQLException e) {
                    LoggerFactory.getLogger(Patient.class).error("Could not load consultations of patient [" + this.getId() + "]", (Throwable)e);
                    PersistentObject.getDefaultConnection().releasePreparedStatement(preparedStatement);
                }
            }
            finally {
                PersistentObject.getDefaultConnection().releasePreparedStatement(preparedStatement);
            }
        }
        return fromDB;
    }

    public Konsultation createFallUndKons() {
        Fall fall = this.neuerFall(Fall.getDefaultCaseLabel(), Fall.getDefaultCaseReason(), Fall.getDefaultCaseLaw());
        Konsultation k = fall.neueKonsultation();
        k.setMandant(ElexisEventDispatcher.getSelectedMandator());
        return k;
    }

    public Fall neuerFall(String Bezeichnung, String grund, String Abrechnungsmethode) {
        Fall fall = new Fall(this.getId(), Bezeichnung, grund, Abrechnungsmethode);
        ElexisEventDispatcher.reload(Fall.class);
        return fall;
    }

    public String getPatCode() {
        String exists;
        String rc = this.get(FLD_PATID);
        if (!StringTool.isNothing((Object)rc)) {
            return rc;
        }
        do {
            String lockid = PersistentObject.lock("PatNummer", true);
            String pid = this.getDBConnection().queryString("SELECT WERT FROM CONFIG WHERE PARAM='PatientNummer'");
            if (StringTool.isNothing((Object)pid)) {
                pid = "0";
                this.getDBConnection().exec("INSERT INTO CONFIG (PARAM,WERT) VALUES ('PatientNummer','0')");
            }
            int lastNum = Integer.parseInt(pid) + 1;
            rc = Integer.toString(lastNum);
            this.getDBConnection().exec("UPDATE CONFIG set wert='" + rc + "', lastupdate=" + Long.toString(System.currentTimeMillis()) + " where param='PatientNummer'");
            PersistentObject.unlock("PatNummer", lockid);
        } while ((exists = this.getDBConnection().queryString("SELECT ID FROM KONTAKT WHERE PatientNr=" + JdbcLink.wrap((String)rc))) != null);
        this.set(FLD_PATID, rc);
        return rc;
    }

    public Money getKontostand() {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT betrag FROM KONTO WHERE PatientID=").append(this.getWrappedId());
        JdbcLink.Stm stm = this.getDBConnection().getStatement();
        Money konto = new Money();
        try {
            ResultSet res = stm.query(sql.toString());
            while (res.next()) {
                int buchung = res.getInt(1);
                konto.addCent(buchung);
            }
            Money money = konto;
            return money;
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
            return null;
        }
        finally {
            this.getDBConnection().releaseStatement(stm);
        }
    }

    public String getBalance() {
        return this.getKontostand().getAmountAsString();
    }

    public Money getAccountExcess() {
        List rechnungen;
        Fall[] faelle;
        Mandant mandator;
        Money prepayment = new Money();
        Query rQuery = new Query(Rechnung.class);
        if (!AccessControlServiceHolder.get().evaluate((EvaluatableACE)EvACE.of(IInvoice.class, (Right)Right.READ)) && (mandator = ElexisEventDispatcher.getSelectedMandator()) != null) {
            rQuery.add("MandantID", "=", mandator.getId());
        }
        if ((faelle = this.getFaelle()) != null && faelle.length > 0) {
            rQuery.startGroup();
            Fall[] fallArray = faelle;
            int n = faelle.length;
            int n2 = 0;
            while (n2 < n) {
                Fall fall = fallArray[n2];
                rQuery.add("FallID", "=", fall.getId());
                rQuery.or();
                ++n2;
            }
            rQuery.endGroup();
        }
        if ((rechnungen = rQuery.execute()) != null) {
            for (Rechnung rechnung : rechnungen) {
                Fall fall = rechnung.getFall();
                if (fall == null) continue;
                Query atQuery = new Query(AccountTransaction.class);
                atQuery.add("PatientID", "=", this.getId());
                atQuery.add("RechnungsID", "=", rechnung.getId());
                List transactions = atQuery.execute();
                if (transactions == null) continue;
                Money sum = new Money();
                for (AccountTransaction transaction : transactions) {
                    sum.addMoney(transaction.getAmount());
                }
                if (sum.getCents() <= 0) continue;
                prepayment.addMoney(sum);
            }
        }
        Query atQuery = new Query(AccountTransaction.class);
        atQuery.add("PatientID", "=", this.getId());
        List transactions = atQuery.execute();
        if (transactions != null) {
            Money sum = new Money();
            for (AccountTransaction transaction : transactions) {
                Rechnung rechnung = transaction.getRechnung();
                if (rechnung != null && rechnung.exists()) continue;
                sum.addMoney(transaction.getAmount());
            }
            prepayment.addMoney(sum);
        }
        return prepayment;
    }

    public static Patient load(String id) {
        Patient ret = new Patient(id);
        return ret;
    }

    public static Patient loadByPatientID(String patientNr) {
        String patID = new Query(Patient.class).findSingle(FLD_PATID, "=", patientNr);
        return Patient.load(patID);
    }

    private Patient(String id) {
        super(id);
    }

    @Override
    protected String getConstraint() {
        return "istPatient" + "=" + JdbcLink.wrap((String)"1");
    }

    @Override
    protected void setConstraint() {
        this.set(new String[]{"istPatient", "istPerson"}, "1", "1");
    }

    @Override
    public String getLabel(boolean shortLabel) {
        if (shortLabel) {
            return super.getLabel(true);
        }
        return this.getPersonalia();
    }

    @Override
    public boolean delete() {
        return this.delete(false);
    }

    public boolean delete(boolean force) {
        Fall[] fl = this.getFaelle();
        if (fl.length == 0 || force && AccessControlServiceHolder.get().evaluate(EvACE.of(ICoverage.class, (Right)Right.DELETE).and(Right.EXECUTE))) {
            Fall[] fallArray = fl;
            int n = fl.length;
            int n2 = 0;
            while (n2 < n) {
                Fall f = fallArray[n2];
                f.delete(true);
                ++n2;
            }
            this.delete_dependent();
            return super.delete();
        }
        return false;
    }

    private boolean delete_dependent() {
        for (LabResult lr : new Query(LabResult.class, "PatientID", this.getId()).execute()) {
            lr.delete();
        }
        for (Rezept rp : new Query(Rezept.class, "PatientID", this.getId()).execute()) {
            rp.delete();
        }
        for (Brief br : new Query(Brief.class, "PatientID", this.getId()).execute()) {
            br.delete();
        }
        for (AccountTransaction at : new Query(AccountTransaction.class, "PatientID", this.getId()).execute()) {
            at.delete();
        }
        return true;
    }

    @Override
    public boolean isDragOK() {
        return true;
    }

    public String getAuftragsnummer() {
        String pid = String.valueOf(StringTool.addModulo10((String)this.getPatCode())) + "-" + new TimeTool().toString(8);
        return pid;
    }

    public String getAlter() {
        return Long.toString(this.getAgeAt(LocalDateTime.now(), ChronoUnit.YEARS));
    }

    public List<Rechnung> getRechnungen() {
        ArrayList<Rechnung> rechnungen = new ArrayList<Rechnung>();
        Fall[] faelle = this.getFaelle();
        if (faelle != null && faelle.length > 0) {
            Query query = new Query(Rechnung.class);
            query.insertTrue();
            query.startGroup();
            Fall[] fallArray = faelle;
            int n = faelle.length;
            int n2 = 0;
            while (n2 < n) {
                Fall fall = fallArray[n2];
                query.add("FallID", "=", fall.getId());
                query.or();
                ++n2;
            }
            query.endGroup();
            List rnList = query.execute();
            if (rnList != null) {
                rechnungen.addAll(rnList);
            }
        }
        return rechnungen;
    }

    public String getAllergies() {
        return this.get(FLD_ALLERGIES);
    }

    public void setAllergies(String allergien) {
        this.set(FLD_ALLERGIES, allergien);
    }

    public String getPersonalAnamnese() {
        return this.get(FLD_PERS_ANAMNESE);
    }

    public void setPersonalAnamnese(String anamnese) {
        this.set(FLD_PERS_ANAMNESE, anamnese);
    }

    public String getComment() {
        return this.get("Bemerkung");
    }

    public void setComment(String bemerkungen) {
        this.set("Bemerkung", bemerkungen);
    }

    public String getFamilyAnamnese() {
        return this.get(FLD_FAM_ANAMNESE);
    }

    public void setFamilyAnamnese(String anamnese) {
        this.set(FLD_FAM_ANAMNESE, anamnese);
    }

    public void setDiagnosen(String diagnosen) {
        this.set(FLD_DIAGNOSES, diagnosen);
    }

    public String getRisk() {
        return this.get(FLD_RISKS);
    }

    public void setRisk(String risk) {
        this.set(FLD_RISKS, risk);
    }

    public void removeStammarzt() {
        this.removeFromExtInfo("Stammarzt_");
    }

    public void setStammarzt(Kontakt stammarzt) {
        if (stammarzt == null) {
            return;
        }
        this.setExtInfoStoredObjectByKey("Stammarzt_", stammarzt.getId());
    }

    public Kontakt getStammarzt() {
        return this.getExtInfoStoredObjectByKey("Stammarzt_") != null ? Kontakt.load((String)this.getExtInfoStoredObjectByKey("Stammarzt_")) : null;
    }

    public void setLegalGuardian(Kontakt legalGuardian) {
        if (legalGuardian == null) {
            this.removeFromExtInfo("LegalGuardian");
            return;
        }
        this.setExtInfoStoredObjectByKey("LegalGuardian", legalGuardian.getId());
    }

    public Kontakt getLegalGuardian() {
        Object guardianId = this.getExtInfoStoredObjectByKey("LegalGuardian");
        if (guardianId != null && !((String)guardianId).isEmpty()) {
            return Kontakt.load((String)guardianId);
        }
        return null;
    }

    private void removeFromExtInfo(String key) {
        Map h = this.getMap("ExtInfo");
        h.remove(key);
        this.setMap("ExtInfo", h);
    }

    public long getAgeAt(LocalDateTime dateTime, ChronoUnit chronoUnit) {
        LocalDateTime birthDateTime = new TimeTool(this.getGeburtsdatum()).toLocalDateTime();
        return chronoUnit.between(birthDateTime, dateTime);
    }

    public IPatient toIPatient() {
        return (IPatient)CoreModelServiceHolder.get().load(this.getId(), IPatient.class).orElseThrow(() -> new IllegalStateException("Could not convert patient [" + this.getId() + "]"));
    }

    public IPersistentObject getReferencedObject(String fieldl) {
        if (fieldl != null && "Stammarzt".equals(fieldl)) {
            return this.getStammarzt();
        }
        return null;
    }
}

