/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.ac.EvaluatableACE;
import ch.elexis.core.ac.ObjectEvaluatableACE;
import ch.elexis.core.ac.Right;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.model.IBlob;
import ch.elexis.core.services.holder.AccessControlServiceHolder;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.rgw.compress.CompEx;
import ch.rgw.io.FileTool;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.IFilter;
import ch.rgw.tools.TimeTool;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.List;

public class NamedBlob
extends PersistentObject {
    public static final String TABLENAME = "HEAP";
    public static final String CONTENTS = "inhalt";

    static {
        NamedBlob.addMapping(TABLENAME, CONTENTS, "Datum=S:D:datum");
    }

    public Hashtable getHashtable() {
        return (Hashtable)this.getMap(CONTENTS);
    }

    public void put(Hashtable in) {
        this.setMap(CONTENTS, in);
        this.set("Datum", new TimeTool().toString(4));
    }

    public String getString() {
        byte[] comp = this.getBinary(CONTENTS);
        if (comp == null || comp.length == 0) {
            return "";
        }
        byte[] exp = CompEx.expand((byte[])comp);
        try {
            return new String(exp, "utf-8");
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void putString(String string) {
        byte[] comp = CompEx.Compress((String)string, (int)-1610612736);
        this.setBinary(CONTENTS, comp);
        this.set("Datum", new TimeTool().toString(4));
    }

    @Override
    public String getLabel() {
        return this.getId();
    }

    @Override
    protected String getTableName() {
        return TABLENAME;
    }

    public static boolean exists(String id) {
        StringBuilder path = new StringBuilder();
        path.append(CoreHub.getTempDir());
        path.append(File.separator);
        String idr = id.replaceAll("\\:", "\\\\");
        path.append(idr);
        File file = new File(path.toString());
        if (file.exists()) {
            return true;
        }
        NamedBlob ni = new NamedBlob(id);
        return ni.exists();
    }

    public static NamedBlob load(String id) {
        NamedBlob ni = new NamedBlob(id);
        if (ni.state() < 2) {
            if (!ni.create(id)) {
                return null;
            }
            File file = new File("c:\\temp" + File.separator + id.replaceAll(":", "\\\\"));
            if (file.exists()) {
                String fi = null;
                try {
                    fi = FileTool.readTextFile((File)file);
                    ni.putString(fi);
                }
                catch (IOException e) {
                    ExHandler.handle((Throwable)e);
                }
            }
        }
        return ni;
    }

    protected NamedBlob() {
    }

    protected NamedBlob(String id) {
        super(id);
    }

    public static List<NamedBlob> findFromPrefix(String prefix) {
        Query qbe = new Query(NamedBlob.class);
        qbe.add("ID", "Like", String.valueOf(prefix) + "%");
        return qbe.execute();
    }

    public static List<NamedBlob> findSimilar(final String name) {
        Query qbe = new Query(NamedBlob.class);
        qbe.addPostQueryFilter(new IFilter(){

            public boolean select(Object toTest) {
                NamedBlob nb = (NamedBlob)toTest;
                return nb.getId().matches(name);
            }
        });
        return qbe.execute();
    }

    public static void cleanup(String prefix, TimeTool older) {
        if (AccessControlServiceHolder.get().evaluate((EvaluatableACE)new ObjectEvaluatableACE(IBlob.class, Right.REMOVE))) {
            Query qbe = new Query(NamedBlob.class);
            qbe.add("Datum", "<", older.toString(9));
            for (NamedBlob nb : qbe.execute()) {
                if (!nb.getId().startsWith(prefix)) continue;
                nb.delete();
            }
        }
    }
}

