/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.beans.ContactBean;
import ch.elexis.core.data.interfaces.IContact;
import ch.elexis.core.data.interfaces.ILabItem;
import ch.elexis.core.data.interfaces.ILabOrder;
import ch.elexis.core.data.interfaces.ILabResult;
import ch.elexis.core.data.interfaces.IPatient;
import ch.elexis.core.data.lab.LabResultEvaluationResult;
import ch.elexis.core.data.lab.LabResultEvaluator;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.jdt.Nullable;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.types.Gender;
import ch.elexis.core.types.LabItemTyp;
import ch.elexis.core.types.PathologicDescription;
import ch.elexis.data.Kontakt;
import ch.elexis.data.LabItem;
import ch.elexis.data.LabOrder;
import ch.elexis.data.Labor;
import ch.elexis.data.NamedBlob;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.LoggerFactory;

public class LabResult
extends PersistentObject
implements ILabResult {
    public static final String LABRESULT_UNSEEN = "Labresult:unseen";
    public static final String DATE = "Datum";
    public static final String TIME = "Zeit";
    public static final String FLAGS = "Flags";
    public static final String COMMENT = "Kommentar";
    public static final String RESULT = "Resultat";
    public static final String ITEM_ID = "ItemID";
    public static final String PATIENT_ID = "PatientID";
    public static final String EXTINFO = "ExtInfo";
    public static final String UNIT = "unit";
    public static final String ANALYSETIME = "analysetime";
    public static final String OBSERVATIONTIME = "observationtime";
    public static final String TRANSMISSIONTIME = "transmissiontime";
    public static final String REFMALE = "refmale";
    public static final String REFFEMALE = "reffemale";
    public static final String ORIGIN_ID = "OriginID";
    public static final String PATHODESC = "pathodesc";
    public static final String EXTINFO_HL7_SUBID = "Hl7SubId";
    private static final String TABLENAME = "LABORWERTE";
    private final String SMALLER = "<";
    private final String BIGGER = ">";
    private PathologicDescription pathologicDescription;
    private static Pattern refValuesPattern = Pattern.compile("\\((.*?)\\)");
    private static String[] VALID_ABS_VALUES = new String[]{"positiv", "negativ", "pos.", "neg.", "pos", "neg", ">0", "<0"};
    @Deprecated(forRemoval=true)
    private static final String QUERY_GROUP_ORDER;

    static {
        LabResult.addMapping(TABLENAME, PATIENT_ID, "Datum=S:D:Datum", ITEM_ID, RESULT, COMMENT, FLAGS, "Quelle=Origin", TIME, UNIT, ANALYSETIME, OBSERVATIONTIME, TRANSMISSIONTIME, REFMALE, REFFEMALE, ORIGIN_ID, PATHODESC);
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT LW.ID, LW.observationtime, LW.Datum, LW.Zeit, ");
        sb.append("LW.pathodesc, LW.ItemID, LW.Flags, LW.Resultat, LW.unit, LW.refmale, LW.reffemale, ");
        sb.append("LI.Gruppe, LI.kuerzel, LI.Einheit, LI.titel, LI.RefMann, LI.RefFrauOrTx, LI.digits, LI.prio ");
        sb.append("FROM LABORWERTE AS LW LEFT JOIN ");
        sb.append("LABORITEMS AS LI ON LW.ItemID=LI.ID ");
        sb.append("WHERE LW.PatientID = ? AND LW.DELETED = '0'");
        QUERY_GROUP_ORDER = sb.toString();
    }

    @Override
    protected String getTableName() {
        return TABLENAME;
    }

    protected LabResult() {
    }

    protected LabResult(String id) {
        super(id);
    }

    public LabResult(Patient p, TimeTool date, LabItem item, String result, String comment) {
        this(p, date, item, result, comment, null, null);
    }

    public LabResult(Patient p, TimeTool date, LabItem item, String result, String comment, Kontakt origin) {
        this(p, date, item, result, comment, null, origin);
    }

    public LabResult(IPatient p, TimeTool date, ILabItem item, String result, String comment, IContact origin) {
        this(p.getId(), p.getGender(), date, item, result, comment, null, origin != null ? origin.getId() : null);
    }

    public LabResult(Patient p, TimeTool date, ILabItem item, String result, String comment, @Nullable String refVal, @Nullable Kontakt origin) {
        this(p.getId(), p.getGender(), date, item, result, comment, refVal, origin != null ? origin.getId() : null);
    }

    public LabResult(String patientId, Gender gender, TimeTool date, ILabItem item, String result, String comment, @Nullable String refVal, @Nullable String originId) {
        this(patientId, gender, date, item, result, comment, refVal, originId, true);
    }

    public LabResult(String patientId, Gender gender, TimeTool date, ILabItem item, String result, String comment, @Nullable String refVal, @Nullable String originId, boolean sendEvent) {
        this.create(null, null, null, false);
        String _date = date == null ? new TimeTool().toString(9) : date.toString(9);
        String[] fields = new String[]{PATIENT_ID, DATE, ITEM_ID, RESULT, COMMENT, ORIGIN_ID};
        String[] vals = new String[]{patientId, _date, item.getId(), result, comment, originId};
        this.set(fields, vals);
        if (refVal != null) {
            if (Gender.MALE == gender) {
                this.setRefMale(refVal);
            } else {
                this.setRefFemale(refVal);
            }
        }
        int flags = this.isPathologic(gender, item, result) ? 1 : 0;
        this.set(FLAGS, Integer.toString(flags));
        this.addToUnseen();
        if (sendEvent) {
            this.sendElexisEvent(1);
        }
    }

    public static LabResult createLabResultAndAssertLabOrder(Patient pat, TimeTool date, LabItem item, String result, String comment, @Nullable Labor origin, String refVal, ILabOrder labOrder, String orderId, String mandantId, TimeTool time, String groupName) {
        LabResult labResult = new LabResult(pat.getId(), pat.getGender(), date, item, result, comment, refVal, origin != null ? origin.getId() : null, false);
        if (labOrder == null) {
            if (time == null) {
                LoggerFactory.getLogger(LabResult.class).warn("Could not resolve observation time and time for ILabResult [{}], defaulting to now.", (Object)labResult.getId());
                time = new TimeTool();
            }
            new LabOrder(CoreHub.getLoggedInContact().getId(), mandantId, pat.getId(), (ILabItem)item, labResult.getId(), orderId, groupName, time);
        } else {
            ((LabOrder)labOrder).setLabResultIdAsString(labResult.getId());
        }
        labResult.sendElexisEvent(1);
        return labResult;
    }

    @Override
    public int getCacheTime() {
        return 60;
    }

    @Override
    @Nullable
    public LabOrder getLabOrder() {
        Query qre = new Query(LabOrder.class, "result", this.getId());
        List execute = qre.execute();
        if (!execute.isEmpty()) {
            if (execute.size() > 1) {
                log.warn("Multiple LabOrders for LabResult [{}] found, please check", (Object)this.getId());
            }
            return (LabOrder)execute.get(0);
        }
        return null;
    }

    private boolean isPathologic(Gender g, ILabItem item, String result, boolean updateDescription) {
        String nr;
        LabResultEvaluationResult er = new LabResultEvaluator().evaluate(this);
        if (er.isFinallyDetermined()) {
            if (updateDescription && er.getPathologicDescription() != null) {
                this.setPathologicDescription(er.getPathologicDescription());
            }
            return er.isPathologic();
        }
        boolean usedItemRef = false;
        if (g == Gender.MALE) {
            nr = this.getRefMale();
            usedItemRef = this.isUsingItemRef(REFMALE);
        } else {
            nr = this.getRefFemale();
            usedItemRef = this.isUsingItemRef(REFFEMALE);
        }
        List<String> refStrings = LabResult.parseRefString(nr);
        if (result != null && !refStrings.isEmpty() && !refStrings.get(0).isEmpty()) {
            Boolean testResult;
            if (updateDescription) {
                if (usedItemRef) {
                    this.setPathologicDescription(new PathologicDescription(PathologicDescription.Description.PATHO_REF_ITEM, refStrings.get(0)));
                } else {
                    this.setPathologicDescription(new PathologicDescription(PathologicDescription.Description.PATHO_REF, refStrings.get(0)));
                }
            }
            if ((testResult = this.testRef(refStrings.get(0), result)) != null) {
                return testResult;
            }
            if (updateDescription) {
                this.setPathologicDescription(new PathologicDescription(PathologicDescription.Description.PATHO_NOREF, refStrings.get(0)));
            }
            return false;
        }
        if (updateDescription) {
            this.setPathologicDescription(new PathologicDescription(PathologicDescription.Description.PATHO_NOREF));
        }
        return false;
    }

    private boolean isPathologic(Gender g, ILabItem item, String result) {
        return this.isPathologic(g, item, result, true);
    }

    public boolean isLongText() {
        return this.getItem().getTyp() == LabItemTyp.TEXT && this.getResult().equalsIgnoreCase("text") && !this.getComment().isEmpty();
    }

    private Boolean testRef(String ref, String result) {
        try {
            String[] range;
            if (ref.trim().startsWith("<") || ref.trim().startsWith(">")) {
                String resultSign = null;
                double refVal = Double.parseDouble(ref.substring(1).trim());
                if (result.trim().startsWith("<") || result.trim().startsWith(">")) {
                    resultSign = result.substring(0, 1).trim();
                    result = result.substring(1).trim();
                }
                double val = Double.parseDouble(result);
                if (ref.trim().startsWith("<")) {
                    if (val >= refVal && (val != refVal || !"<".equals(resultSign))) {
                        return true;
                    }
                    return false;
                }
                if (val <= refVal && (val != refVal || !">".equals(resultSign))) {
                    return true;
                }
                return false;
            }
            if (ref.contains("-") && (range = ref.split("\\s*-\\s*")).length == 2) {
                double lower = Double.parseDouble(range[0]);
                double upper = Double.parseDouble(range[1]);
                double val = Double.parseDouble(result);
                if (!(val < lower) && !(val > upper)) {
                    return false;
                }
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    private static List<String> parseRefString(String ref) {
        ArrayList<String> result = new ArrayList<String>();
        Matcher m = refValuesPattern.matcher(ref);
        while (m.find()) {
            result.add(m.group(1).trim());
        }
        if (result.isEmpty()) {
            result.add(ref.trim());
        }
        return result;
    }

    public static LabResult load(String id) {
        return new LabResult(id);
    }

    public Patient getPatient() {
        return Patient.load(this.get(PATIENT_ID));
    }

    @Override
    @Deprecated
    public String getDate() {
        return this.get(DATE);
    }

    @Override
    public void setDate(String value) {
        this.set(DATE, value);
    }

    @Deprecated
    public TimeTool getDateTime() {
        String[] vals = this.get(false, TIME, DATE);
        return LabResult.translateDateTime(vals[0], vals[1]);
    }

    private static TimeTool translateDateTime(String time, String date) {
        if (time == null || "".equals(time)) {
            time = "000000";
        }
        while (time.length() < 6) {
            time = String.valueOf(time) + "0";
        }
        return new TimeTool(String.valueOf(date) + " " + time.substring(0, 2) + ":" + time.substring(2, 4) + ":" + time.substring(4, 6));
    }

    @Override
    public ILabItem getItem() {
        return LabItem.load(this.get(ITEM_ID));
    }

    @Override
    public void setItem(ILabItem value) {
        this.set(ITEM_ID, value.getId());
    }

    @Override
    public String getResult() {
        String result = LabResult.checkNull(this.get(RESULT));
        if (this.getItem().getTyp() == LabItemTyp.FORMULA) {
            String value = null;
            List<LabOrder> orders = LabOrder.getLabOrders(null, null, this.getItem(), this, null, null, null);
            if (orders != null && !orders.isEmpty()) {
                value = this.evaluteWithOrderContext(orders.get(0));
            }
            if (value == null || value.equals("?formel?")) {
                TimeTool time = this.getObservationTime();
                if (time == null) {
                    time = this.getDateTime();
                }
                value = this.evaluateWithDateContext(time);
            }
            if (!result.equals(value)) {
                this.setResult(value);
                result = LabResult.checkNull(this.get(RESULT));
            }
        }
        return result;
    }

    private String evaluteWithOrderContext(LabOrder order) {
        String ret = null;
        try {
            ret = ((LabItem)this.getItem()).evaluate(this.getPatient(), order.getLabResults());
        }
        catch (ElexisException e) {
            ret = "?formel?";
        }
        return ret;
    }

    private String evaluateWithDateContext(TimeTool time) {
        String ret = null;
        try {
            ret = ((LabItem)this.getItem()).evaluate(this.getPatient(), time);
        }
        catch (ElexisException e) {
            ret = "?formel?";
        }
        return ret;
    }

    @Override
    public void setResult(String res) {
        int flags = this.isPathologic(this.getPatient().getGender(), this.getItem(), res) ? 1 : 0;
        this.set(new String[]{RESULT, FLAGS}, LabResult.checkNull(res), Integer.toString(flags));
    }

    @Override
    public String getComment() {
        return LabResult.checkNull(this.get(COMMENT));
    }

    @Override
    public void setComment(String comment) {
        this.set(COMMENT, comment);
    }

    public boolean isFlag(int flag) {
        return (this.getFlags() & flag) != 0;
    }

    public void setFlag(int flag, boolean set) {
        int flags = this.getFlags();
        flags = set ? (flags |= flag) : (flags &= ~flag);
        this.setInt(FLAGS, flags);
    }

    @Override
    public int getFlags() {
        return LabResult.checkZero(this.get(FLAGS));
    }

    public boolean isPathologicFlagIndetermined(PathologicDescription pathologicDescription) {
        PathologicDescription.Description desc;
        if (pathologicDescription == null) {
            pathologicDescription = this.getPathologicDescription();
        }
        return PathologicDescription.Description.PATHO_NOREF == (desc = pathologicDescription.getDescription()) || PathologicDescription.Description.UNKNOWN == desc || PathologicDescription.Description.PATHO_IMPORT_NO_INFO == desc;
    }

    @Override
    public void setFlags(int value) {
        this.set(FLAGS, Integer.toString(value));
    }

    @Override
    public String getUnit() {
        String ret = LabResult.checkNull(this.get(UNIT));
        if (ret.isEmpty()) {
            ret = this.getItem().getUnit();
        }
        return ret;
    }

    @Override
    public void setUnit(String unit) {
        this.set(UNIT, unit);
    }

    @Override
    public TimeTool getAnalyseTime() {
        String timestr = LabResult.checkNull(this.get(ANALYSETIME));
        if (timestr.isEmpty()) {
            return null;
        }
        return new TimeTool(timestr);
    }

    @Override
    public void setAnalyseTime(TimeTool time) {
        this.set(ANALYSETIME, time.toString(13));
    }

    @Override
    public TimeTool getObservationTime() {
        String timestr = LabResult.checkNull(this.get(OBSERVATIONTIME));
        if (timestr.isEmpty()) {
            return null;
        }
        return new TimeTool(timestr);
    }

    @Override
    public void setObservationTime(TimeTool time) {
        if (time != null) {
            this.set(OBSERVATIONTIME, time.toString(13));
        }
    }

    @Override
    public TimeTool getTransmissionTime() {
        String timestr = LabResult.checkNull(this.get(TRANSMISSIONTIME));
        if (timestr.isEmpty()) {
            return null;
        }
        return new TimeTool(timestr);
    }

    @Override
    public void setTransmissionTime(TimeTool time) {
        this.set(TRANSMISSIONTIME, time.toString(13));
    }

    @Override
    public String getRefMale() {
        return this.resolvePreferedRefValue(this.getItem().getReferenceMale(), REFMALE);
    }

    @Override
    public void setRefMale(String value) {
        this.set(REFMALE, value);
        this.setFlag(1, this.isPathologic(this.getPatient().getGender(), this.getItem(), this.getResult()));
    }

    @Override
    public String getRefFemale() {
        return this.resolvePreferedRefValue(this.getItem().getReferenceFemale(), REFFEMALE);
    }

    @Override
    public void setRefFemale(String value) {
        this.set(REFFEMALE, value);
        this.setFlag(1, this.isPathologic(this.getPatient().getGender(), this.getItem(), this.getResult()));
    }

    private String resolvePreferedRefValue(String localRef, String refField) {
        boolean useLocalRefs = ConfigServiceHolder.getUser((String)"lab/localRefValues", (boolean)true);
        if (useLocalRefs && localRef != null && !localRef.isEmpty()) {
            return localRef;
        }
        String ref = LabResult.checkNull(this.get(refField));
        if (ref.isEmpty()) {
            log.info("using local LabRefVal [{}] as none could be resolved from labResult", (Object)localRef);
            return localRef;
        }
        return ref;
    }

    private boolean isUsingItemRef(String refField) {
        boolean useLocalRefs = ConfigServiceHolder.getUser((String)"lab/localRefValues", (boolean)true);
        String localRef = REFMALE.equals(refField) ? this.getItem().getReferenceMale() : this.getItem().getReferenceFemale();
        if (useLocalRefs && localRef != null && !localRef.isEmpty()) {
            return true;
        }
        String ref = LabResult.checkNull(this.get(refField));
        return ref.isEmpty();
    }

    public void setDetail(String key, String value) {
        Map ext = this.getMap(EXTINFO);
        if (value == null) {
            ext.remove(key);
        } else {
            ext.put(key, value);
        }
        this.setMap(EXTINFO, ext);
    }

    public String getDetail(String key) {
        Map ext = this.getMap(EXTINFO);
        return (String)ext.get(key);
    }

    @Override
    public String getLabel() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getItem().getLabel()).append(", ").append(this.getDate()).append(": ").append(this.getResult());
        return sb.toString();
    }

    public static LabResult getForDate(Patient pat, TimeTool date, LabItem item) {
        Query qbe = new Query(LabResult.class);
        qbe.add(ITEM_ID, "=", item.getId());
        qbe.add(PATIENT_ID, "=", pat.getId());
        qbe.add(DATE, "=", date.toString(9));
        List res = qbe.execute();
        if (res != null && !res.isEmpty()) {
            return (LabResult)res.get(0);
        }
        return null;
    }

    public static LabResult getForObservationTime(Patient pat, TimeTool fromObservationTime, TimeTool toObservationTime, LabItem item) {
        return LabResult.getForObservationTime(pat.getId(), fromObservationTime, toObservationTime, item);
    }

    public static LabResult getForObservationTime(String patientId, TimeTool fromObservationTime, TimeTool toObservationTime, LabItem item) {
        Query qbe = new Query(LabResult.class);
        qbe.add(ITEM_ID, "=", item.getId());
        qbe.add(PATIENT_ID, "=", patientId);
        if (fromObservationTime != null) {
            fromObservationTime.set(11, 0);
            fromObservationTime.set(12, 0);
            fromObservationTime.set(13, 0);
            fromObservationTime.set(14, 0);
            qbe.add(OBSERVATIONTIME, ">=", fromObservationTime.toString(13));
        }
        if (toObservationTime != null) {
            toObservationTime.set(11, 23);
            toObservationTime.set(12, 59);
            toObservationTime.set(13, 59);
            toObservationTime.set(14, 999);
            qbe.add(OBSERVATIONTIME, "<=", toObservationTime.toString(13));
        }
        qbe.orderBy(true, OBSERVATIONTIME);
        List res = qbe.execute();
        if (res != null && !res.isEmpty()) {
            return (LabResult)res.get(0);
        }
        return null;
    }

    public void addToUnseen() {
        List<LabResult> o = LabResult.getUnseen();
        LinkedList<String> n = new LinkedList<String>();
        n.add(this.getId());
        TimeTool limit = new TimeTool();
        try {
            limit.addHours(-24 * Integer.parseInt(ConfigServiceHolder.getGlobal((String)"lab/keepUnseen", (String)"3")));
        }
        catch (NumberFormatException nex) {
            ExHandler.handle((Throwable)nex);
            limit.addHours(-168);
        }
        TimeTool tr = new TimeTool();
        for (LabResult lr : o) {
            if (!tr.set(lr.getDate()) || !tr.isAfter(limit)) continue;
            n.add(lr.getId());
        }
        NamedBlob unseen = NamedBlob.load(LABRESULT_UNSEEN);
        String results = StringTool.join(n, (String)",");
        unseen.putString(results);
    }

    public void removeFromUnseen() {
        NamedBlob unseen = NamedBlob.load(LABRESULT_UNSEEN);
        String results = unseen.getString();
        results = results.replaceAll(this.getId(), "");
        unseen.putString(results.replaceAll(",,", ","));
    }

    public static List<LabResult> getUnseen() {
        LinkedList<LabResult> ret = new LinkedList<LabResult>();
        NamedBlob unseen = NamedBlob.load(LABRESULT_UNSEEN);
        String results = unseen.getString();
        if (results.length() > 0) {
            String[] stringArray = results.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                LabResult lr = LabResult.load(id);
                if (lr.exists()) {
                    ret.add(lr);
                }
                ++n2;
            }
        }
        return ret;
    }

    public static long getLastUpdateUnseen() {
        NamedBlob unseen = NamedBlob.load(LABRESULT_UNSEEN);
        long lastup = unseen.getLastUpdate();
        return lastup;
    }

    public String toString() {
        return this.getLabel();
    }

    @Override
    public IContact getOriginContact() {
        Kontakt origin = this.getOrigin();
        if (origin == null) {
            return null;
        }
        return new ContactBean(origin);
    }

    @Override
    public void setOriginContact(IContact value) {
        Kontakt load = Kontakt.load(value.getId());
        this.setOrigin(load);
    }

    public void setOrigin(Kontakt origin) {
        if (origin != null && origin.exists()) {
            this.set(ORIGIN_ID, origin.getId());
        } else {
            this.set(ORIGIN_ID, "");
        }
    }

    public Kontakt getOrigin() {
        String id = this.get(ORIGIN_ID);
        if (id != null && !id.isEmpty()) {
            return Kontakt.load(id);
        }
        return null;
    }

    @Override
    public PathologicDescription getPathologicDescription() {
        if (this.pathologicDescription == null) {
            this.pathologicDescription = PathologicDescription.of((String)this.get(PATHODESC));
        }
        return this.pathologicDescription;
    }

    @Override
    public void setPathologicDescription(PathologicDescription description) {
        this.pathologicDescription = description;
        this.set(PATHODESC, description.toString());
    }

    public static boolean isValidNumericRefValue(String value) {
        List<String> refs = LabResult.parseRefString(value);
        for (String string : refs) {
            try {
                if (string.trim().startsWith("<") || string.trim().startsWith(">")) {
                    Double.parseDouble(string.substring(1).trim());
                    continue;
                }
                String[] range = string.split("\\s*-\\s*");
                if (range.length == 2) {
                    Double.parseDouble(range[0]);
                    Double.parseDouble(range[1]);
                    continue;
                }
                return false;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        return true;
    }

    public static boolean isValidAbsoluteRefValue(String value) {
        String[] stringArray = VALID_ABS_VALUES;
        int n = VALID_ABS_VALUES.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (value.trim().equals(string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HashMap<String, HashMap<String, HashMap<String, List<LabResult>>>> getGrouped(Patient pat) {
        HashMap<String, HashMap<String, HashMap<String, List<LabResult>>>> ret = new HashMap<String, HashMap<String, HashMap<String, List<LabResult>>>>();
        if (pat == null) {
            return ret;
        }
        PreparedStatement ps = PersistentObject.getConnection().getPreparedStatement(QUERY_GROUP_ORDER);
        try {
            try {
                ps.setString(1, pat.getId());
                log.debug(ps.toString());
                ResultSet resi = ps.executeQuery();
                while (resi != null) {
                    HashMap<String, List<LabResult>> itemMap;
                    if (!resi.next()) {
                        return ret;
                    }
                    String val_id = resi.getString(1);
                    String val_ot = resi.getString(2);
                    String val_date = resi.getString(3);
                    String val_time = resi.getString(4);
                    String val_pathodesc = resi.getString(5);
                    String val_itemid = resi.getString(6);
                    String val_flags = resi.getString(7);
                    String val_result = resi.getString(8);
                    String val_unit = resi.getString(9);
                    String val_refmale = resi.getString(10);
                    String val_reffemale = resi.getString(11);
                    String val_itemgroup = LabResult.getNotNull(resi, 12);
                    String val_itemshortname = LabResult.getNotNull(resi, 13);
                    String val_itemunit = LabResult.getNotNull(resi, 14);
                    String val_itemtitle = LabResult.getNotNull(resi, 15);
                    String val_itemrefmale = LabResult.getNotNull(resi, 16);
                    String val_itemreffemale = LabResult.getNotNull(resi, 17);
                    String val_itemdigits = LabResult.getNotNull(resi, 18);
                    String val_itemprio = LabResult.getNotNull(resi, 19);
                    HashMap<String, HashMap<String, List<LabResult>>> groupMap = ret.get(val_itemgroup);
                    if (groupMap == null) {
                        groupMap = new HashMap();
                        ret.put(val_itemgroup, groupMap);
                    }
                    if ((itemMap = groupMap.get(val_itemshortname)) == null) {
                        itemMap = new HashMap();
                        groupMap.put(val_itemshortname, itemMap);
                    }
                    TimeTool time = null;
                    time = val_ot != null ? new TimeTool(val_ot) : LabResult.translateDateTime(val_time, val_date);
                    String date = time.toString(9);
                    List<LabResult> resultList = itemMap.get(date);
                    if (resultList == null) {
                        resultList = new ArrayList<LabResult>();
                        itemMap.put(date, resultList);
                    }
                    LabResult labResult = new LabResult(val_id);
                    labResult.putInCache(OBSERVATIONTIME, val_ot);
                    labResult.putInCache(PATHODESC, val_pathodesc);
                    labResult.putInCache(ITEM_ID, val_itemid);
                    labResult.putInCache(FLAGS, val_flags);
                    labResult.putInCache(RESULT, val_result);
                    labResult.putInCache(UNIT, val_unit);
                    labResult.putInCache(REFMALE, val_refmale);
                    labResult.putInCache(REFFEMALE, val_reffemale);
                    LabItem item = new LabItem(val_itemid);
                    item.putInCache("kuerzel", val_itemshortname);
                    item.putInCache("titel", val_itemtitle);
                    item.putInCache("Gruppe", val_itemgroup);
                    item.putInCache("Einheit", val_itemunit);
                    item.putInCache("RefMann", val_itemrefmale);
                    item.putInCache("RefFrauOrTx", val_itemreffemale);
                    item.putInCache("prio", val_itemprio);
                    item.putInCache("digits", val_itemdigits);
                    resultList.add(labResult);
                }
                return ret;
            }
            catch (SQLException e) {
                log.error("Error in fetching labitem groups", (Throwable)e);
                PersistentObject.getConnection().releasePreparedStatement(ps);
                return ret;
            }
        }
        finally {
            PersistentObject.getConnection().releasePreparedStatement(ps);
        }
    }

    private static String getNotNull(ResultSet set, int index) throws SQLException {
        String ret = set.getString(index);
        if (ret == null) {
            ret = "";
        }
        return ret;
    }

    public static void changeObservationTime(Patient patient, TimeTool from, TimeTool to) {
        Query qbe = new Query(LabResult.class);
        qbe.add(PATIENT_ID, "=", patient.getId());
        List res = qbe.execute();
        ArrayList<LabResult> changeList = new ArrayList<LabResult>();
        for (LabResult labResult : res) {
            TimeTool obsTime = labResult.getObservationTime();
            if (obsTime == null) {
                obsTime = labResult.getDateTime();
            }
            if (!obsTime.isSameDay(from)) continue;
            changeList.add(labResult);
        }
        for (LabResult labResult : changeList) {
            labResult.setObservationTime(to);
        }
    }
}

