/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.data.util;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.interfaces.IDiagnose;
import ch.elexis.core.data.interfaces.IFall;
import ch.elexis.core.data.service.LocalLockServiceHolder;
import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IInvoice;
import ch.elexis.core.model.IXid;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ch.BillingLaw;
import ch.elexis.core.services.holder.BillingServiceHolder;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.CoverageServiceHolder;
import ch.elexis.core.services.holder.EncounterServiceHolder;
import ch.elexis.core.services.holder.InvoiceServiceHolder;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Mandant;
import ch.elexis.data.Query;
import ch.elexis.data.Rechnung;
import ch.elexis.data.Rechnungssteller;
import ch.elexis.data.dto.DiagnosesDTO;
import ch.elexis.data.dto.InvoiceCorrectionDTO;
import ch.elexis.data.dto.InvoiceHistoryEntryDTO;
import ch.elexis.data.dto.KonsultationDTO;
import ch.elexis.data.dto.LeistungDTO;
import ch.rgw.tools.Money;
import ch.rgw.tools.Result;
import ch.rgw.tools.TimeTool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BillingUtil {
    public static String BILLINGCHECK_ENABLED_CFG = "ch.elexis.core.data/billablecheck/";
    private static final Logger log = LoggerFactory.getLogger(BillingUtil.class);
    public static IBillableCheck[] billableChecks = new IBillableCheck[]{new IBillableCheck(){

        @Override
        public boolean isBillable(Konsultation konsultation, Result<Konsultation> result) {
            boolean fail;
            boolean bl = fail = konsultation.getRechnung() != null && !Rechnung.isStorno(konsultation.getRechnung());
            if (fail) {
                result.add(Result.SEVERITY.ERROR, 1, this.getDescription(), (Object)konsultation, false);
            }
            return !fail;
        }

        @Override
        public String getId() {
            return "alreadyBilled";
        }

        @Override
        public String getDescription() {
            return "Behandlung ist bereits verrechnet.";
        }
    }, new IBillableCheck(){

        @Override
        public boolean isBillable(Konsultation konsultation, Result<Konsultation> result) {
            boolean fail = BillingUtil.getTotal(konsultation).isZero();
            if (fail) {
                result.add(Result.SEVERITY.ERROR, 1, this.getDescription(), (Object)konsultation, false);
            }
            return !fail;
        }

        @Override
        public String getId() {
            return "zeroSales";
        }

        @Override
        public String getDescription() {
            return "Behandlung mit Umsatz 0";
        }
    }, new IBillableCheck(){

        @Override
        public boolean isBillable(Konsultation konsultation, Result<Konsultation> result) {
            boolean fail;
            Mandant mandant = konsultation.getMandant();
            boolean bl = fail = mandant == null || !mandant.isValid();
            if (fail) {
                result.add(Result.SEVERITY.ERROR, 1, this.getDescription(), (Object)konsultation, false);
            }
            return !fail;
        }

        @Override
        public String getId() {
            return "invalidMandant";
        }

        @Override
        public String getDescription() {
            return "Ung\u00fcltiger Mandant";
        }
    }, new IBillableCheck(){

        @Override
        public boolean isBillable(Konsultation konsultation, Result<Konsultation> result) {
            boolean fail;
            Fall fall = konsultation.getFall();
            boolean bl = fail = fall == null;
            if (fail) {
                result.add(Result.SEVERITY.ERROR, 1, this.getDescription(), (Object)konsultation, false);
            }
            return !fail;
        }

        @Override
        public String getId() {
            return "noCoverage";
        }

        @Override
        public String getDescription() {
            return "Fehlender Fall";
        }
    }, new IBillableCheck(){

        @Override
        public boolean isBillable(Konsultation konsultation, Result<Konsultation> result) {
            boolean fail;
            Fall fall = konsultation.getFall();
            boolean bl = fail = fall != null && ConfigServiceHolder.getUser((String)"billing/strict", (boolean)true) && !fall.isValid();
            if (fail) {
                result.add(Result.SEVERITY.ERROR, 1, this.getDescription(), (Object)konsultation, false);
            }
            return !fail;
        }

        @Override
        public String getId() {
            return "invalidCoverage";
        }

        @Override
        public String getDescription() {
            return "Fall nicht g\u00fcltig";
        }
    }, new IBillableCheck(){

        @Override
        public boolean isBillable(Konsultation konsultation, Result<Konsultation> result) {
            boolean fail;
            ArrayList<IDiagnose> diagnosen = konsultation.getDiagnosen();
            boolean bl = fail = diagnosen == null || diagnosen.isEmpty();
            if (fail) {
                result.add(Result.SEVERITY.ERROR, 1, this.getDescription(), (Object)konsultation, false);
            }
            return !fail;
        }

        @Override
        public String getId() {
            return "noDiagnose";
        }

        @Override
        public String getDescription() {
            return "Keine Diagnose";
        }
    }, new IBillableCheck(){
        private TimeTool checkTool = new TimeTool();

        @Override
        public boolean isBillable(Konsultation konsultation, Result<Konsultation> result) {
            boolean fail;
            boolean bl = fail = !this.checkTool.set(konsultation.getDatum());
            if (fail) {
                result.add(Result.SEVERITY.ERROR, 1, this.getDescription(), (Object)konsultation, false);
            }
            return !fail;
        }

        @Override
        public String getId() {
            return "invalidDate";
        }

        @Override
        public String getDescription() {
            return "Ung\u00fcltiges Datum";
        }
    }, new IBillableCheck(){

        @Override
        public boolean isBillable(Konsultation konsultation, Result<Konsultation> result) {
            boolean fail = false;
            ArrayList<IDiagnose> diagnosen = konsultation.getDiagnosen();
            if (diagnosen == null || diagnosen.isEmpty()) {
                fail = true;
                Query query = new Query(Konsultation.class);
                query.add("RechnungsID", "=", null);
                query.add("FallID", "=", konsultation.getFall().getId());
                List openKonsultationen = query.execute();
                for (Konsultation openKons : openKonsultationen) {
                    ArrayList<IDiagnose> diag = openKons.getDiagnosen();
                    if (diag == null || diag.isEmpty()) continue;
                    fail = false;
                    break;
                }
                if (fail) {
                    result.add(Result.SEVERITY.ERROR, 1, this.getDescription(), (Object)konsultation, false);
                }
            }
            return !fail;
        }

        @Override
        public String getId() {
            return "noDiagnoseInSeries";
        }

        @Override
        public String getDescription() {
            return "Keine Diagnose in der Behandlungsserie";
        }
    }, new IBillableCheck(){

        @Override
        public boolean isBillable(Konsultation konsultation, Result<Konsultation> result) {
            ICoverage coverage;
            if (konsultation.getFall() != null && konsultation.getFall().getConfiguredBillingSystemLaw() == BillingLaw.IV && (coverage = (ICoverage)CoreModelServiceHolder.get().load(konsultation.getFall().getId(), ICoverage.class).get()).getPatient() != null && StringUtils.isBlank((CharSequence)BillingUtil.getSSN(coverage))) {
                result.add(Result.SEVERITY.ERROR, 1, this.getDescription(), (Object)konsultation, false);
                return false;
            }
            return true;
        }

        @Override
        public String getId() {
            return "ivNoSSN";
        }

        @Override
        public String getDescription() {
            return "IV Fall ohne AHV Nummer";
        }
    }, new IBillableCheck(){

        @Override
        public boolean isBillable(Konsultation konsultation, Result<Konsultation> result) {
            String ssn;
            ICoverage coverage;
            if (konsultation.getFall() != null && (coverage = (ICoverage)CoreModelServiceHolder.get().load(konsultation.getFall().getId(), ICoverage.class).get()).getPatient() != null && StringUtils.isNotBlank((CharSequence)(ssn = BillingUtil.getSSN(coverage))) && !ssn.matches("[0-9]{4,10}|[1-9][0-9]{10}|756[0-9]{10}|438[0-9]{10}")) {
                result.add(Result.SEVERITY.ERROR, 1, this.getDescription(), (Object)konsultation, false);
                return false;
            }
            return true;
        }

        @Override
        public String getId() {
            return "invalidSSN";
        }

        @Override
        public String getDescription() {
            return "Fehlerhafte AHV Nummer";
        }
    }};
    private static Integer[] splitBillYears = new Integer[]{2018};

    private static String getSSN(ICoverage coverage) {
        String ahv;
        IXid ahvXid = coverage.getPatient().getXid("www.ahv.ch/xid");
        String string = ahv = ahvXid != null ? ahvXid.getDomainId() : "";
        if (StringUtils.isBlank((CharSequence)ahv)) {
            ahv = StringUtils.defaultString((String)((String)coverage.getPatient().getExtInfo((Object)"AHV-Nummer")));
        }
        if (StringUtils.isBlank((CharSequence)(ahv = ahv.replaceAll("[^0-9]", "")))) {
            ahv = CoverageServiceHolder.get().getRequiredString(coverage, "AHV-Nummer").replaceAll("[^0-9]", "");
        }
        return StringUtils.isNotBlank((CharSequence)ahv) ? ahv : null;
    }

    public static boolean isCheckEnabled(IBillableCheck check) {
        return ConfigServiceHolder.getGlobal((String)(String.valueOf(BILLINGCHECK_ENABLED_CFG) + check.getId()), (boolean)true);
    }

    public static void setCheckEnabled(IBillableCheck check, boolean enabled) {
        ConfigServiceHolder.setGlobal((String)(String.valueOf(BILLINGCHECK_ENABLED_CFG) + check.getId()), (boolean)enabled);
    }

    public static Result<Konsultation> getBillableResult(Konsultation konsultation) {
        Result result = new Result((Object)konsultation);
        IBillableCheck[] iBillableCheckArray = billableChecks;
        int n = billableChecks.length;
        int n2 = 0;
        while (n2 < n) {
            IBillableCheck iBillableCheck = iBillableCheckArray[n2];
            if (BillingUtil.isCheckEnabled(iBillableCheck)) {
                iBillableCheck.isBillable(konsultation, (Result<Konsultation>)result);
            }
            ++n2;
        }
        return result;
    }

    public static Money getTotal(Konsultation konsultation) {
        IEncounter encounter = NoPoUtil.loadAsIdentifiable(konsultation, IEncounter.class).get();
        return EncounterServiceHolder.get().getSales(encounter);
    }

    public static List<Konsultation> filterNotBillable(List<Konsultation> konsultationen) {
        return konsultationen.parallelStream().filter(k -> BillingUtil.getBillableResult(k).isOK()).collect(Collectors.toList());
    }

    public static Map<Rechnungssteller, Map<Fall, List<Konsultation>>> getGroupedBillable(List<Konsultation> konsultationen) {
        HashMap<Rechnungssteller, Map<Fall, List<Konsultation>>> ret = new HashMap<Rechnungssteller, Map<Fall, List<Konsultation>>>();
        for (Konsultation konsultation : konsultationen) {
            List<Konsultation> list;
            Rechnungssteller invoicer = konsultation.getMandant().getRechnungssteller();
            Map<Fall, List<Konsultation>> fallMap = ret.get(invoicer);
            if (fallMap == null) {
                fallMap = new HashMap<Fall, List<Konsultation>>();
            }
            if ((list = fallMap.get(konsultation.getFall())) == null) {
                list = new ArrayList<Konsultation>();
            }
            list.add(konsultation);
            fallMap.put(konsultation.getFall(), list);
            ret.put(invoicer, fallMap);
        }
        return ret;
    }

    public static List<Result<IInvoice>> createBills(Map<Rechnungssteller, Map<Fall, List<Konsultation>>> toBillMap) {
        ArrayList<Result<IInvoice>> ret = new ArrayList<Result<IInvoice>>();
        Set<Rechnungssteller> invoicers = toBillMap.keySet();
        for (Rechnungssteller invoicer : invoicers) {
            Set<Fall> faelle = toBillMap.get(invoicer).keySet();
            for (Fall fall : faelle) {
                List<IEncounter> encounters = NoPoUtil.loadAsIdentifiable(toBillMap.get(invoicer).get(fall), IEncounter.class);
                ret.add((Result<IInvoice>)InvoiceServiceHolder.get().invoice(encounters));
            }
        }
        return ret;
    }

    public static List<Konsultation> getKonsultationsFromSameYear(List<Konsultation> konsultations) {
        ArrayList<Konsultation> items = new ArrayList<Konsultation>();
        int year = 0;
        for (Konsultation b : konsultations) {
            if (year == 0) {
                year = new TimeTool(b.getDatum()).get(1);
            }
            if (year != new TimeTool(b.getDatum()).get(1)) continue;
            items.add(b);
        }
        return items;
    }

    @Deprecated
    public static Map<Integer, List<Konsultation>> getSortedByYear(List<Konsultation> consultations) {
        HashMap<Integer, List<Konsultation>> ret = new HashMap<Integer, List<Konsultation>>();
        TimeTool konsDate = new TimeTool();
        for (Konsultation consultation : consultations) {
            konsDate.set(consultation.getDatum());
            Integer year = konsDate.get(1);
            ArrayList<Konsultation> list = (ArrayList<Konsultation>)ret.get(year);
            if (list == null) {
                list = new ArrayList<Konsultation>();
            }
            list.add(consultation);
            ret.put(year, list);
        }
        return ret;
    }

    public static Map<Integer, List<IEncounter>> getSortedEncountersByYear(List<IEncounter> consultations) {
        HashMap<Integer, List<IEncounter>> ret = new HashMap<Integer, List<IEncounter>>();
        for (IEncounter consultation : consultations) {
            Integer year = consultation.getDate().getYear();
            ArrayList<IEncounter> list = (ArrayList<IEncounter>)ret.get(year);
            if (list == null) {
                list = new ArrayList<IEncounter>();
            }
            list.add(consultation);
            ret.put(year, list);
        }
        return ret;
    }

    public static boolean canBillYears(List<Integer> years) {
        Integer[] integerArray = splitBillYears;
        int n = splitBillYears.length;
        int n2 = 0;
        while (n2 < n) {
            Integer splitYear = integerArray[n2];
            boolean aboveSplitYear = false;
            boolean belowSplitYear = false;
            for (Integer year : years) {
                if (year >= splitYear) {
                    aboveSplitYear = true;
                } else {
                    belowSplitYear = true;
                }
                if (!aboveSplitYear || !belowSplitYear) continue;
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static void doBillCorrection(InvoiceCorrectionDTO invoiceCorrectionDTO, BillCallback billCallback) {
        BillCorrection billCorrection = new BillCorrection(invoiceCorrectionDTO, billCallback);
        billCorrection.doCorrection();
    }

    public static interface BillCallback {
        public List<Konsultation> storno(Rechnung var1);
    }

    private static class BillCorrection {
        private boolean success = true;
        private StringBuilder output = new StringBuilder();
        private final Rechnung rechnung;
        private Optional<Fall> srcFall = Optional.empty();
        private Optional<Fall> copyFall = Optional.empty();
        private List<Konsultation> releasedKonsultations = new ArrayList<Konsultation>();
        private List<Konsultation> transferedKonsultations = new ArrayList<Konsultation>();
        private LeistungDTO leistungDTO = null;
        private DiagnosesDTO diagnosesDTO = null;
        private Konsultation konsultation = null;
        private IBilled verrechnet = null;
        private List<Object> locks = new ArrayList<Object>();
        private final InvoiceCorrectionDTO invoiceCorrectionDTO;
        private final BillCallback billCallback;
        private static volatile /* synthetic */ int[] $SWITCH_TABLE$ch$elexis$data$dto$InvoiceHistoryEntryDTO$OperationType;

        public BillCorrection(InvoiceCorrectionDTO invoiceCorrectionDTO, BillCallback billCallback) {
            this.invoiceCorrectionDTO = invoiceCorrectionDTO;
            this.rechnung = Rechnung.load(invoiceCorrectionDTO.getId());
            this.billCallback = billCallback;
        }

        /*
         * Exception decompiling
         */
        public void doCorrection() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 4[CASE]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void removeDiagnose(Object base, Object item) {
            this.konsultation = Konsultation.load(((KonsultationDTO)base).getId());
            this.diagnosesDTO = (DiagnosesDTO)item;
            IEncounter encounter = NoPoUtil.loadAsIdentifiable(this.konsultation, IEncounter.class).get();
            encounter.removeDiagnosis(this.diagnosesDTO.getiDiagnose());
            CoreModelServiceHolder.get().save((Identifiable)encounter);
            log.debug("invoice correction: removed diagnose id [{}] from kons id [{}]", (Object)this.diagnosesDTO.getId(), (Object)this.konsultation.getId());
        }

        private void addDiagnose(Object base, Object item) {
            this.konsultation = Konsultation.load(((KonsultationDTO)base).getId());
            this.diagnosesDTO = (DiagnosesDTO)item;
            IEncounter encounter = NoPoUtil.loadAsIdentifiable(this.konsultation, IEncounter.class).get();
            encounter.addDiagnosis(this.diagnosesDTO.getiDiagnose());
            CoreModelServiceHolder.get().save((Identifiable)encounter);
            log.debug("invoice correction: added diagnose id [{}] to kons id [{}]", (Object)this.diagnosesDTO.getId(), (Object)this.konsultation.getId());
        }

        private void changePriceLeistung(Object item) {
            this.leistungDTO = (LeistungDTO)item;
            this.verrechnet = this.leistungDTO.getVerrechnet();
            if (this.verrechnet != null) {
                this.acquireLock(this.locks, this.verrechnet, false);
                int tp = this.leistungDTO.getTp();
                int tpOld = this.verrechnet.getPoints();
                if (tpOld != tp) {
                    this.verrechnet.setPoints(tp);
                    log.debug("invoice correction: price changed to [{}] for leistung id [{}]", (Object)this.leistungDTO.getPrice().getAmountAsString(), (Object)this.leistungDTO.getId());
                }
                CoreModelServiceHolder.get().save((Identifiable)this.verrechnet);
            } else {
                log.warn("invoice correction: leistung id [{}] no verrechnet exists cannot change price", (Object)this.leistungDTO.getId());
            }
        }

        private void changeCountLeistung(Object item) {
            this.leistungDTO = (LeistungDTO)item;
            this.verrechnet = this.leistungDTO.getVerrechnet();
            if (this.verrechnet != null) {
                this.acquireLock(this.locks, this.verrechnet, false);
                IStatus ret = BillingServiceHolder.get().changeAmountValidated(this.verrechnet, this.leistungDTO.getCount());
                log.debug("invoice correction: changed count from leistung id [{}]", (Object)this.leistungDTO.getId());
                if (ret.isOK()) {
                    CoreModelServiceHolder.get().save((Identifiable)this.verrechnet);
                } else {
                    this.addToOutput(this.output, ret.getMessage());
                    this.success = false;
                    log.warn("invoice correction: cannot change count from leistung with id [{}]", (Object)this.leistungDTO.getId());
                }
            }
        }

        public void transferKonsultation(Object base, Object item) {
            KonsultationDTO konsultationDTO = (KonsultationDTO)base;
            Fall fallToTransfer = Fall.load(((IFall)item).getId());
            log.debug("invoice correction: transfer kons with id [{}] to fall id [{}]", (Object)konsultationDTO.getId(), (Object)fallToTransfer.getId());
            Konsultation konsultation = Konsultation.load(konsultationDTO.getId());
            Fall oldFall = konsultation.getFall();
            this.acquireLock(this.locks, oldFall, false);
            this.acquireLock(this.locks, fallToTransfer, false);
            this.acquireLock(this.locks, konsultation, false);
            EncounterServiceHolder.get().transferToCoverage(NoPoUtil.loadAsIdentifiable(konsultation, IEncounter.class).get(), NoPoUtil.loadAsIdentifiable(fallToTransfer, ICoverage.class).get(), true);
            Iterator<Konsultation> it = this.transferedKonsultations.iterator();
            while (it.hasNext()) {
                Konsultation k = it.next();
                if (!konsultation.getId().equals(k.getId())) continue;
                it.remove();
                log.debug("invoice correction: removed transfered kons with id [{}] from released konsultations", (Object)k.getId());
            }
            log.debug("invoice correction: transfered kons id [{}] from fall id [{}] to fall id  [{}]", new Object[]{konsultation.getId(), oldFall.getId(), fallToTransfer.getId()});
        }

        private void transferLeistungen(Object base, Object item, Object additional) {
            List leistungenDTOs = (List)item;
            this.konsultation = Konsultation.load(((KonsultationDTO)base).getId());
            Fall fallToTransfer = Fall.load(((IFall)additional).getId());
            ArrayList<LeistungDTO> removedleistungDTOs = new ArrayList<LeistungDTO>();
            for (LeistungDTO itemLeistung : leistungenDTOs) {
                log.debug("invoice correction: transfer leistung id [{}] from kons id [{}]", (Object)itemLeistung.getId(), (Object)this.konsultation.getId());
                if (itemLeistung.getVerrechnet() != null) {
                    this.acquireLock(this.locks, itemLeistung.getVerrechnet(), false);
                    Result resRemove = BillingServiceHolder.get().removeBilled(itemLeistung.getVerrechnet(), NoPoUtil.loadAsIdentifiable(this.konsultation, IEncounter.class).get());
                    log.debug("invoice correction: removed leistung id [{}] from kons id [{}]", (Object)itemLeistung.getId(), (Object)this.konsultation.getId());
                    if (resRemove.isOK()) {
                        itemLeistung.setVerrechnet(null);
                        removedleistungDTOs.add(itemLeistung);
                        continue;
                    }
                    this.addToOutput(this.output, "Die Leistung " + itemLeistung.getVerrechnet().getText() + " konnte nicht auf einen neuen Fall/Konsultation transferiert werden. Das Entfernen der Leistung ist fehlgeschlagen.");
                    this.success = false;
                    log.warn("invoice correction: cannot transfer/remove leistung with id [{}] from kons id [{}]", (Object)itemLeistung.getId(), (Object)this.konsultation.getId());
                    continue;
                }
                removedleistungDTOs.add(itemLeistung);
            }
            if (!removedleistungDTOs.isEmpty()) {
                Konsultation newKons = this.konsultation.createCopy(fallToTransfer, this.rechnung);
                IEncounter newEncounter = NoPoUtil.loadAsIdentifiable(newKons, IEncounter.class).get();
                this.acquireLock(this.locks, newKons, true);
                log.debug("invoice correction: copied kons from id [{}] to kons id [{}] and added kons to fall id [{}] ", new Object[]{this.konsultation.getId(), newKons.getId(), newKons.getFall().getId()});
                for (LeistungDTO itemLeistung : removedleistungDTOs) {
                    Result resAddLeistung = BillingServiceHolder.get().bill(itemLeistung.getIVerrechenbar(), newEncounter, 1.0);
                    log.debug("invoice correction: add leistung id [{}] to kons id [{}]", (Object)itemLeistung.getId(), (Object)newKons.getId());
                    if (resAddLeistung.isOK()) {
                        this.verrechnet = EncounterServiceHolder.get().getBilledByBillable(newEncounter, itemLeistung.getIVerrechenbar()).stream().findFirst().orElse(null);
                        if (this.verrechnet != null) {
                            itemLeistung.setVerrechnet(this.verrechnet);
                            if (this.verrechnet.getAmount() != itemLeistung.getCount()) {
                                IStatus ret = BillingServiceHolder.get().changeAmountValidated(this.verrechnet, itemLeistung.getCount());
                                log.debug("invoice correction: count changed from [{}] to {[]} - for leistung id [{}]", (Object)itemLeistung.getId());
                                if (ret.isOK()) {
                                    CoreModelServiceHolder.get().save((Identifiable)this.verrechnet);
                                } else {
                                    this.verrechnet = null;
                                    log.warn("invoice correction: cannot change count for leistung with id [{}]", (Object)itemLeistung.getId());
                                }
                            }
                        }
                    } else {
                        this.addToOutput(this.output, resAddLeistung);
                        this.verrechnet = null;
                    }
                    if (this.verrechnet != null) continue;
                    this.addToOutput(this.output, "Die Leistung " + itemLeistung.getIVerrechenbar().getText() + " konnte nicht auf einen neuen Fall/Konsultation transferiert werden. Das Hinzuf\u00fcgen der Leistung ist fehlgeschlagen.");
                    this.success = false;
                    log.warn("invoice correction: cannot transfer/add leistung with id [{}] to new kons id [{}]", (Object)itemLeistung.getId(), (Object)newKons.getId());
                }
            }
            if (!this.success) {
                this.addToOutput(this.output, "Nicht alle Leistungen konnten erfolgreich transferiert werden.");
                log.warn("invoice correction: not all leistungen could be transfered.");
            }
        }

        private void removeLeistung(Object base, Object item) {
            this.leistungDTO = (LeistungDTO)item;
            if (this.leistungDTO.getVerrechnet() != null) {
                this.acquireLock(this.locks, this.leistungDTO.getVerrechnet(), false);
                Result resRemove = BillingServiceHolder.get().removeBilled(this.leistungDTO.getVerrechnet(), (IEncounter)CoreModelServiceHolder.get().load(((KonsultationDTO)base).getId(), IEncounter.class).get());
                log.debug("invoice correction: removed leistung id [{}] from kons id [{}]", (Object)this.leistungDTO.getId(), (Object)((KonsultationDTO)base).getId());
                if (resRemove.isOK()) {
                    ((LeistungDTO)item).setVerrechnet(null);
                } else {
                    this.addToOutput(this.output, "Die Leistung " + this.leistungDTO.getVerrechnet().getText() + " konnte nicht entfernt werden.");
                    this.success = false;
                    log.warn("invoice correction: cannot remove leistung with id [{}] from kons id [{}]", (Object)this.leistungDTO.getId(), (Object)((KonsultationDTO)base).getId());
                }
            }
        }

        private void addLeistung(Object base, Object item) {
            this.konsultation = Konsultation.load(((KonsultationDTO)base).getId());
            IEncounter encounter = NoPoUtil.loadAsIdentifiable(this.konsultation, IEncounter.class).get();
            this.leistungDTO = (LeistungDTO)item;
            Result res = BillingServiceHolder.get().bill(this.leistungDTO.getIVerrechenbar(), encounter, 1.0);
            log.debug("invoice correction: added leistung id [{}] to kons id [{}]", (Object)this.leistungDTO.getId(), (Object)((KonsultationDTO)base).getId());
            if (res.isOK()) {
                this.verrechnet = EncounterServiceHolder.get().getBilledByBillable(encounter, this.leistungDTO.getIVerrechenbar()).stream().findFirst().orElse(null);
                if (this.verrechnet != null) {
                    this.leistungDTO.setVerrechnet(this.verrechnet);
                    this.acquireLock(this.locks, this.verrechnet, false);
                }
            } else {
                this.addToOutput(this.output, res);
                this.verrechnet = null;
            }
            if (this.verrechnet == null) {
                this.addToOutput(this.output, "Die Leistung " + this.leistungDTO.getIVerrechenbar().getText() + " konnte nicht verrechnet werden.");
                this.success = false;
                log.warn("invoice correction: cannot add leistung with id [{}] to kons id [{}]", (Object)this.leistungDTO.getId(), (Object)this.konsultation.getId());
            }
        }

        private void changeMandantKonsultation(Object base) {
            Konsultation.load(((KonsultationDTO)base).getId()).setMandant(((KonsultationDTO)base).getMandant());
            log.debug("invoice correction: changed mandant of kons id [{}]", (Object)((KonsultationDTO)base).getId());
        }

        private void changeDateKonsultation(Object base) {
            Konsultation.load(((KonsultationDTO)base).getId()).setDatum(((KonsultationDTO)base).getDate(), true);
            log.debug("invoice correction: changed date of kons id [{}]", (Object)((KonsultationDTO)base).getId());
        }

        private void transferKonsultations() {
            this.transferedKonsultations.clear();
            Konsultation[] consultations = this.srcFall.get().getBehandlungen(true);
            if (consultations != null) {
                Konsultation[] konsultationArray = consultations;
                int n = consultations.length;
                int n2 = 0;
                while (n2 < n) {
                    Rechnung bill;
                    Konsultation openedKons = konsultationArray[n2];
                    if (openedKons.exists() && (bill = openedKons.getRechnung()) == null) {
                        EncounterServiceHolder.get().transferToCoverage(NoPoUtil.loadAsIdentifiable(openedKons, IEncounter.class).get(), NoPoUtil.loadAsIdentifiable(this.copyFall.get(), ICoverage.class).get(), true);
                        log.debug("invoice correction: transfered kons id [{}] to copied fall id  [{}] ", (Object)openedKons.getId(), (Object)this.copyFall.get().getId());
                        this.transferedKonsultations.add(openedKons);
                        Result<Konsultation> result = BillingUtil.getBillableResult(openedKons);
                        if (!result.isOK()) {
                            StringBuilder preValidatioWarnings = new StringBuilder();
                            this.addToOutput(preValidatioWarnings, result);
                            log.warn("invoice correction: konsultation prevalidation failed - the invoice correction will be continued - because the current correction could fix it. Message: [{}]", (Object)preValidatioWarnings.toString());
                        }
                    }
                    ++n2;
                }
            }
        }

        private void changeFall() throws ElexisException {
            this.copyFall.get().persistDTO(this.invoiceCorrectionDTO.getFallDTO());
            this.copyFall.get().setEndDatum(null);
            log.debug("invoice correction: persisted fall changes to id  [{}] ", (Object)this.copyFall.get().getId());
        }

        private void copyFall() {
            this.srcFall = Optional.of(this.rechnung.getFall());
            ICoverage copy = CoverageServiceHolder.get().createCopy(NoPoUtil.loadAsIdentifiable(this.srcFall.get(), ICoverage.class).get());
            this.copyFall = Optional.of((Fall)NoPoUtil.loadAsPersistentObject((Identifiable)copy));
            this.acquireLock(this.locks, this.copyFall.get(), true);
            log.debug("invoice correction: copied fall from id [{}] to id [{}] ", (Object)this.srcFall.get().getId(), (Object)this.copyFall.get().getId());
        }

        private void createBill(InvoiceHistoryEntryDTO historyEntryDTO) {
            if (this.copyFall.isPresent()) {
                if (this.invoiceCorrectionDTO.getFallDTO().getEndDatum() != null) {
                    this.copyFall.get().setEndDatum(this.invoiceCorrectionDTO.getFallDTO().getEndDatum());
                    this.acquireLock(this.locks, this.copyFall.get(), false);
                }
                if ((this.srcFall.get().isOpen() || new TimeTool(this.srcFall.get().getEndDatum()).after((Object)new TimeTool())) && this.srcFall.get().getBehandlungen(true).length == 0) {
                    this.acquireLock(this.locks, this.srcFall.get(), false);
                    this.srcFall.get().setEndDatum(new TimeTool().toString(4));
                }
            }
            if (this.releasedKonsultations.isEmpty()) {
                log.debug("invoice correction: no konsultations exists for invoice id [{}]- a new invoice will not be created.", (Object)this.rechnung.getNr());
                this.output.append("Die Rechnung " + this.rechnung.getNr() + " wurde erfolgreich durch " + CoreHub.getLoggedInContact().getLabel() + " korrigiert.\nEs wurde keine neue Rechnung erstellt.");
                historyEntryDTO.setIgnored(true);
            } else {
                Result rechnungResult = InvoiceServiceHolder.get().invoice(NoPoUtil.loadAsIdentifiable(this.releasedKonsultations, IEncounter.class));
                if (!rechnungResult.isOK()) {
                    for (Result.msg message : rechnungResult.getMessages()) {
                        if (message.getSeverity() == Result.SEVERITY.OK) continue;
                        if (this.output.length() > 0) {
                            this.output.append("\n");
                        }
                        this.output.append(message.getText());
                    }
                    this.success = false;
                    log.error("invoice correction: error cannot create new invoice with id " + (rechnungResult.get() != null ? ((IInvoice)rechnungResult.get()).getId() : "null"));
                    log.error("invoice correction: error details: " + this.output.toString());
                } else {
                    Rechnung newRechnung = Rechnung.load(((IInvoice)rechnungResult.get()).getId());
                    this.invoiceCorrectionDTO.setNewInvoiceNumber(newRechnung.getNr());
                    log.debug("invoice correction: create new invoice with number [{}] old invoice number [{}] ", (Object)newRechnung.getNr(), (Object)this.rechnung.getNr());
                    this.output.append("Die Rechnung " + this.rechnung.getNr() + " wurde erfolgreich durch " + CoreHub.getLoggedInContact().getLabel() + " korrigiert.\nNeue Rechnungsnummer lautet: " + this.invoiceCorrectionDTO.getNewInvoiceNumber());
                }
            }
        }

        private boolean stornoBill() {
            List<Konsultation> konsultations = this.billCallback.storno(this.rechnung);
            if (konsultations != null) {
                konsultations.forEach(k -> NoPoUtil.loadAsIdentifiable(k, IEncounter.class).ifPresent(e -> {
                    CoreModelServiceHolder.get().refresh((Identifiable)e, true);
                    e.getBilled().forEach(b -> CoreModelServiceHolder.get().refresh((Identifiable)b, true));
                }));
                this.releasedKonsultations.addAll(konsultations);
            } else {
                this.success = false;
            }
            log.debug("invoice correction: storno invoice with number [{}] ", (Object)this.rechnung.getNr());
            return true;
        }

        private void addToOutput(StringBuilder output, Result<?> res) {
            StringBuilder warnings = new StringBuilder();
            for (Result.msg message : res.getMessages()) {
                if (message.getSeverity() == Result.SEVERITY.OK) continue;
                if (output.length() > 0) {
                    warnings.append(" / ");
                }
                warnings.append(message.getText());
            }
            if (warnings.length() > 0) {
                output.append(warnings.toString());
            }
        }

        private void addToOutput(StringBuilder output, String warning) {
            if (output.length() > 0) {
                output.append("\n");
            }
            if (warning.length() > 0) {
                output.append(warning);
            }
        }

        private boolean acquireLock(List<Object> currentLocks, Object persistentObjectToLock, boolean forceReleaseLock) {
            if (!currentLocks.contains(persistentObjectToLock) && LocalLockServiceHolder.get().acquireLock(persistentObjectToLock).isOk()) {
                if (!forceReleaseLock) {
                    currentLocks.add(persistentObjectToLock);
                } else {
                    LocalLockServiceHolder.get().releaseLock(persistentObjectToLock);
                }
                return true;
            }
            return false;
        }

        static /* synthetic */ int[] $SWITCH_TABLE$ch$elexis$data$dto$InvoiceHistoryEntryDTO$OperationType() {
            if ($SWITCH_TABLE$ch$elexis$data$dto$InvoiceHistoryEntryDTO$OperationType != null) {
                return $SWITCH_TABLE$ch$elexis$data$dto$InvoiceHistoryEntryDTO$OperationType;
            }
            int[] nArray = new int[InvoiceHistoryEntryDTO.OperationType.values().length];
            try {
                nArray[InvoiceHistoryEntryDTO.OperationType.DIAGNOSE_ADD.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[InvoiceHistoryEntryDTO.OperationType.DIAGNOSE_REMOVE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[InvoiceHistoryEntryDTO.OperationType.FALL_CHANGE.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[InvoiceHistoryEntryDTO.OperationType.FALL_COPY.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[InvoiceHistoryEntryDTO.OperationType.FALL_KONSULTATION_TRANSER.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[InvoiceHistoryEntryDTO.OperationType.KONSULTATION_CHANGE_DATE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[InvoiceHistoryEntryDTO.OperationType.KONSULTATION_CHANGE_MANDANT.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[InvoiceHistoryEntryDTO.OperationType.KONSULTATION_TRANSFER_TO_FALL.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[InvoiceHistoryEntryDTO.OperationType.LEISTUNG_ADD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[InvoiceHistoryEntryDTO.OperationType.LEISTUNG_CHANGE_COUNT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[InvoiceHistoryEntryDTO.OperationType.LEISTUNG_CHANGE_PRICE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[InvoiceHistoryEntryDTO.OperationType.LEISTUNG_REMOVE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[InvoiceHistoryEntryDTO.OperationType.LEISTUNG_TRANSFER_TO_FALL_KONS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[InvoiceHistoryEntryDTO.OperationType.RECHNUNG_NEW.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[InvoiceHistoryEntryDTO.OperationType.RECHNUNG_STORNO.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $SWITCH_TABLE$ch$elexis$data$dto$InvoiceHistoryEntryDTO$OperationType = nArray;
            return nArray;
        }
    }

    public static interface IBillableCheck {
        public String getId();

        public String getDescription();

        public boolean isBillable(Konsultation var1, Result<Konsultation> var2);
    }
}

