/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.data.service.internal;

import ch.elexis.core.common.InstanceStatus;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.service.ContextServiceHolder;
import ch.elexis.core.data.service.StoreToStringServiceHolder;
import ch.elexis.core.lock.types.LockInfo;
import ch.elexis.core.lock.types.LockRequest;
import ch.elexis.core.lock.types.LockResponse;
import ch.elexis.core.model.ISticker;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.IElexisServerService;
import ch.elexis.core.services.ILocalLockService;
import ch.elexis.core.services.IStickerService;
import ch.elexis.core.services.IStoreToStringService;
import ch.elexis.core.status.ElexisStatus;
import ch.elexis.data.PersistentObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.runtime.IProgressMonitor;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class LocalLockService
implements ILocalLockService {
    @Reference
    private IElexisServerService elexisServerService;
    @Reference
    private IContextService contextService;
    @Reference
    private IConfigService configService;
    @Reference
    private IStickerService stickerSerivce;
    @Reference
    private IStoreToStringService storeToStringService;
    private final HashMap<String, Integer> lockCount = new HashMap();
    private final HashMap<String, LockInfo> locks = new HashMap();
    private Logger logger = LoggerFactory.getLogger(LocalLockService.class);
    private Timer timer;

    @Activate
    public void activate() {
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new LockRefreshTask(), 10000L, 10000L);
    }

    public LockResponse releaseAllLocks() {
        if (this.elexisServerService.isStandalone()) {
            return LockResponse.OK;
        }
        ArrayList<LockInfo> lockList = new ArrayList<LockInfo>(this.locks.values());
        for (LockInfo lockInfo : lockList) {
            LockRequest lockRequest = new LockRequest(LockRequest.Type.RELEASE, lockInfo);
            LockResponse lr = this.acquireOrReleaseLocks(lockRequest);
            if (lr.isOk()) continue;
            return lr;
        }
        return LockResponse.OK;
    }

    public LockResponse releaseLock(Object object) {
        if (object == null) {
            return LockResponse.DENIED(null);
        }
        this.logger.debug("Releasing lock on [" + object + "]");
        return this.releaseLock(StoreToStringServiceHolder.getStoreToString(object));
    }

    public LockResponse releaseLock(LockInfo lockInfo) {
        if (lockInfo.getElementStoreToString() == null) {
            return LockResponse.DENIED(null);
        }
        this.logger.debug("Releasing lock on [" + lockInfo.getElementStoreToString() + "]");
        return this.releaseLock(lockInfo.getElementStoreToString());
    }

    public LockResponse releaseLock(String storeToString) {
        IUser user = ContextServiceHolder.get().getActiveUser().orElse(null);
        if (user != null) {
            LockInfo lil = new LockInfo(storeToString, user.getId(), this.elexisServerService.getSystemUuid().toString(), this.contextService.getStationIdentifier(), this.configService.getLocal("station/identText", ""));
            LockRequest lockRequest = new LockRequest(LockRequest.Type.RELEASE, lil);
            return this.acquireOrReleaseLocks(lockRequest);
        }
        return LockResponse.ERROR;
    }

    private String getId(Object object) {
        if (object instanceof PersistentObject) {
            return ((PersistentObject)object).getId();
        }
        if (object instanceof Identifiable) {
            return ((Identifiable)object).getId();
        }
        throw new IllegalStateException("No id for [" + object + "]");
    }

    public LockResponse acquireLockBlocking(Object object, int secTimeout, IProgressMonitor monitor) {
        if (object == null) {
            return LockResponse.DENIED(null);
        }
        if (this.isReadOnly(object)) {
            return LockResponse.NOINFO(null);
        }
        if (monitor != null) {
            monitor.beginTask("Acquiring Lock ...", secTimeout * 10 + 1);
        }
        this.logger.debug("Acquiring lock blocking on [" + object + "]");
        String storeToString = StoreToStringServiceHolder.getStoreToString(object);
        LockResponse response = this.acquireLock(storeToString);
        int sleptMilli = 0;
        while (!response.isOk()) {
            if (response.getStatus() == LockResponse.Status.DENIED_PERMANENT) {
                return response;
            }
            try {
                Thread.sleep(100L);
                response = this.acquireLock(storeToString);
                if ((sleptMilli += 100) > secTimeout * 1000) {
                    return response;
                }
                if (monitor == null) continue;
                monitor.worked(1);
                if (!monitor.isCanceled()) continue;
                return LockResponse.DENIED((LockInfo)response.getLockInfo());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return response;
    }

    public LockResponse acquireLock(Object object) {
        if (object == null) {
            return LockResponse.DENIED(null);
        }
        if (this.isReadOnly(object)) {
            return LockResponse.NOINFO(null);
        }
        this.logger.debug("Acquiring lock on [" + object + "]");
        LockResponse lr = this.acquireLock(StoreToStringServiceHolder.getStoreToString(object));
        if (lr.getStatus() == LockResponse.Status.ERROR) {
            this.logger.warn("LockResponse ERROR");
        }
        return lr;
    }

    private LockResponse acquireLock(String storeToString) {
        if (storeToString == null) {
            return LockResponse.DENIED(null);
        }
        IUser user = ContextServiceHolder.get().getActiveUser().orElse(null);
        LockInfo lockInfo = new LockInfo(storeToString, user.getId(), this.elexisServerService.getSystemUuid().toString(), this.contextService.getStationIdentifier(), this.configService.getLocal("station/identText", ""));
        LockRequest lockRequest = new LockRequest(LockRequest.Type.ACQUIRE, lockInfo);
        return this.acquireOrReleaseLocks(lockRequest);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LockResponse acquireOrReleaseLocks(LockRequest lockRequest) {
        if (this.elexisServerService.isStandalone()) {
            return LockResponse.OK((LockInfo)lockRequest.getLockInfo());
        }
        if (this.elexisServerService == null) {
            String message = "System not configured for standalone mode, and elexis-server not available!";
            this.logger.error(message);
            ElexisStatus.fire((ElexisStatus)new ElexisStatus(4, "ch.elexis.core.data", 0, message, null));
            return new LockResponse(LockResponse.Status.ERROR, lockRequest.getLockInfo());
        }
        LockInfo lockInfo = lockRequest.getLockInfo();
        HashMap<String, LockInfo> hashMap = this.locks;
        synchronized (hashMap) {
            LockResponse lockResponse;
            LockResponse lr;
            block27: {
                if (LockRequest.Type.ACQUIRE == lockRequest.getRequestType() && this.locks.keySet().contains(lockInfo.getElementId())) {
                    this.incrementLockCount(lockInfo);
                    return LockResponse.OK((LockInfo)lockRequest.getLockInfo());
                }
                if (LockRequest.Type.RELEASE == lockRequest.getRequestType() && this.getCurrentLockCount(lockInfo) > 1) {
                    this.decrementLockCount(lockInfo);
                    return LockResponse.OK((LockInfo)lockRequest.getLockInfo());
                }
                if (LockRequest.Type.RELEASE == lockRequest.getRequestType()) {
                    Optional identifiable = this.storeToStringService.loadFromString(lockInfo.getElementStoreToString());
                    if (identifiable.isPresent()) {
                        this.postEvent("info/elexis/locking/prerelease", identifiable.get(), true);
                    } else {
                        PersistentObject po = CoreHub.poFactory.createFromString(lockInfo.getElementStoreToString());
                        if (po != null) {
                            ElexisEventDispatcher.getInstance().fire(new ElexisEvent((Object)po, po.getClass(), 8192, 1));
                        }
                    }
                }
                if ((lr = this.elexisServerService.acquireOrReleaseLocks(lockRequest)).isOk()) break block27;
                LockResponse lockResponse2 = lr;
                if (!LockRequest.Type.RELEASE.equals((Object)lockRequest.getRequestType())) return lockResponse2;
                this.decrementLockCount(lockInfo);
                this.locks.remove(lockInfo.getElementId());
                PersistentObject po = CoreHub.poFactory.createFromString(lockInfo.getElementStoreToString());
                if (po != null) {
                    ElexisEventDispatcher.getInstance().fire(new ElexisEvent(po, po.getClass(), 16384));
                } else {
                    Optional identifiable = this.storeToStringService.loadFromString(lockInfo.getElementStoreToString());
                    if (!identifiable.isPresent()) return lockResponse2;
                    this.postEvent("info/elexis/locking/released", identifiable.get(), false);
                }
                return lockResponse2;
            }
            try {
                if (LockRequest.Type.ACQUIRE == lockRequest.getRequestType()) {
                    this.locks.put(lockInfo.getElementId(), lockInfo);
                    this.incrementLockCount(lockInfo);
                    Optional identifiable = this.storeToStringService.loadFromString(lockInfo.getElementStoreToString());
                    if (identifiable.isPresent()) {
                        this.postEvent("info/elexis/locking/aquired", identifiable.get(), false);
                    } else {
                        PersistentObject po = CoreHub.poFactory.createFromString(lockInfo.getElementStoreToString());
                        if (po != null) {
                            ElexisEventDispatcher.getInstance().fire(new ElexisEvent(po, po.getClass(), 4096));
                        }
                    }
                }
                lockResponse = lr;
            }
            catch (Exception e) {
                LockResponse lockResponse2;
                try {
                    String message = "Error trying to acquireOrReleaseLocks.";
                    this.logger.error(message);
                    ElexisStatus.fire((ElexisStatus)new ElexisStatus(4, "ch.elexis.core.data", 0, message, e));
                    lockResponse2 = new LockResponse(LockResponse.Status.ERROR, lockRequest.getLockInfo());
                }
                catch (Throwable throwable) {
                    if (!LockRequest.Type.RELEASE.equals((Object)lockRequest.getRequestType())) throw throwable;
                    this.decrementLockCount(lockInfo);
                    this.locks.remove(lockInfo.getElementId());
                    PersistentObject po = CoreHub.poFactory.createFromString(lockInfo.getElementStoreToString());
                    if (po != null) {
                        ElexisEventDispatcher.getInstance().fire(new ElexisEvent(po, po.getClass(), 16384));
                        throw throwable;
                    }
                    Optional identifiable = this.storeToStringService.loadFromString(lockInfo.getElementStoreToString());
                    if (!identifiable.isPresent()) throw throwable;
                    this.postEvent("info/elexis/locking/released", identifiable.get(), false);
                    throw throwable;
                }
                if (!LockRequest.Type.RELEASE.equals((Object)lockRequest.getRequestType())) return lockResponse2;
                this.decrementLockCount(lockInfo);
                this.locks.remove(lockInfo.getElementId());
                PersistentObject po = CoreHub.poFactory.createFromString(lockInfo.getElementStoreToString());
                if (po != null) {
                    ElexisEventDispatcher.getInstance().fire(new ElexisEvent(po, po.getClass(), 16384));
                } else {
                    Optional identifiable = this.storeToStringService.loadFromString(lockInfo.getElementStoreToString());
                    if (!identifiable.isPresent()) return lockResponse2;
                    this.postEvent("info/elexis/locking/released", identifiable.get(), false);
                }
                return lockResponse2;
            }
            if (!LockRequest.Type.RELEASE.equals((Object)lockRequest.getRequestType())) return lockResponse;
            this.decrementLockCount(lockInfo);
            this.locks.remove(lockInfo.getElementId());
            PersistentObject po = CoreHub.poFactory.createFromString(lockInfo.getElementStoreToString());
            if (po != null) {
                ElexisEventDispatcher.getInstance().fire(new ElexisEvent(po, po.getClass(), 16384));
            } else {
                Optional identifiable = this.storeToStringService.loadFromString(lockInfo.getElementStoreToString());
                if (!identifiable.isPresent()) return lockResponse;
                this.postEvent("info/elexis/locking/released", identifiable.get(), false);
            }
            return lockResponse;
        }
    }

    private void incrementLockCount(LockInfo lockInfo) {
        Integer count = this.lockCount.get(lockInfo.getElementId());
        if (count == null) {
            count = 0;
        }
        count = count + 1;
        this.lockCount.put(lockInfo.getElementId(), count);
        this.logger.debug("Increment to " + count + " locks on " + lockInfo.getElementId());
    }

    private void decrementLockCount(LockInfo lockInfo) {
        Integer count = this.lockCount.get(lockInfo.getElementId());
        if (count != null) {
            count = count - 1;
            this.lockCount.put(lockInfo.getElementId(), count);
            this.logger.debug("Decrement to " + count + " locks on " + lockInfo.getElementId());
            if (count < 1) {
                this.lockCount.remove(lockInfo.getElementId());
            }
        }
    }

    private Integer getCurrentLockCount(LockInfo lockInfo) {
        Integer count = this.lockCount.get(lockInfo.getElementId());
        if (count == null) {
            count = 0;
        }
        this.logger.debug("Got currently " + count + " locks on " + lockInfo.getElementId());
        return count;
    }

    public boolean isLockedLocal(Object object) {
        if (object == null) {
            return false;
        }
        if (this.isReadOnly(object)) {
            return false;
        }
        if (!this.isLockable(object)) {
            return true;
        }
        if (this.elexisServerService.isStandalone()) {
            return true;
        }
        return this.locks.containsKey(this.getId(object));
    }

    private boolean isReadOnly(Object object) {
        if (object instanceof Identifiable) {
            Optional<ISticker> readOnlySticker = this.stickerSerivce.getStickers((Identifiable)object).stream().filter(s -> "readOnly".equals(s.getId())).findFirst();
            return readOnlySticker.isPresent();
        }
        if (object instanceof PersistentObject) {
            Optional<ch.elexis.core.data.interfaces.ISticker> readOnlySticker = ((PersistentObject)object).getStickers().stream().filter(s -> "readOnly".equals(s.getId())).findFirst();
            return readOnlySticker.isPresent();
        }
        return false;
    }

    private boolean isLockable(Object object) {
        return object instanceof Identifiable || object instanceof PersistentObject;
    }

    public boolean isLocked(Object object) {
        if (object == null) {
            return false;
        }
        if (!this.isLockable(object)) {
            return true;
        }
        this.logger.debug("Checking lock on [" + object + "]");
        String storeToString = StoreToStringServiceHolder.getStoreToString(object);
        return this.isLocked(storeToString);
    }

    public boolean isLocked(String storeToString) {
        if (storeToString == null) {
            return false;
        }
        IUser user = ContextServiceHolder.get().getActiveUser().orElse(null);
        LockInfo lockInfo = new LockInfo(storeToString, user.getId(), this.elexisServerService.getSystemUuid().toString(), this.contextService.getStationIdentifier(), this.configService.getLocal("station/identText", ""));
        LockRequest lockRequest = new LockRequest(LockRequest.Type.INFO, lockInfo);
        return this.isLocked(lockRequest);
    }

    public boolean isLocked(LockRequest lockRequest) {
        if (lockRequest == null || lockRequest.getLockInfo().getElementId() == null) {
            return false;
        }
        if (this.elexisServerService.isStandalone()) {
            return true;
        }
        if (this.locks.containsKey(lockRequest.getLockInfo().getElementId())) {
            return true;
        }
        try {
            return this.elexisServerService.isLocked(lockRequest);
        }
        catch (Exception e) {
            this.logger.error("Catched exception in isLocked: ", (Throwable)e);
            return false;
        }
    }

    public List<LockInfo> getCopyOfAllHeldLocks() {
        Collection<LockInfo> values = this.locks.values();
        if (values.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<LockInfo>(values);
    }

    public String getSystemUuid() {
        return this.elexisServerService.getSystemUuid().toString();
    }

    public LockInfo getLockInfo(String storeToString) {
        String elementId = LockInfo.getElementId((String)storeToString);
        LockInfo lockInfo = this.locks.get(elementId);
        return lockInfo;
    }

    private void postEvent(String topic, Object object, boolean synchronous) {
        if (synchronous) {
            this.contextService.postEvent(topic, object);
        } else {
            this.contextService.sendEvent(topic, object);
        }
    }

    public void shutdown() {
        this.timer.cancel();
        if (this.elexisServerService != null) {
            InstanceStatus instanceStatus = this.elexisServerService.createInstanceStatus();
            instanceStatus.setState(InstanceStatus.STATE.SHUTTING_DOWN);
            this.elexisServerService.updateInstanceStatus(instanceStatus);
        }
    }

    private class LockRefreshTask
    extends TimerTask {
        private LockRefreshTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                boolean publishUpdate = false;
                HashMap<String, LockInfo> hashMap = LocalLockService.this.locks;
                synchronized (hashMap) {
                    ArrayList<String> lockKeys = new ArrayList<String>();
                    lockKeys.addAll(LocalLockService.this.locks.keySet());
                    for (String key : lockKeys) {
                        boolean success = LocalLockService.this.elexisServerService.isLocked(new LockRequest(LockRequest.Type.INFO, LocalLockService.this.locks.get(key)));
                        if (success) continue;
                        publishUpdate = true;
                        LocalLockService.this.releaseLock(LocalLockService.this.locks.get(key).getElementStoreToString());
                    }
                }
                if (publishUpdate) {
                    ContextServiceHolder.get().postEvent("info/elexis/model/reload", LockInfo.class);
                }
            }
            catch (Exception e) {
                LoggerFactory.getLogger(LockRefreshTask.class).error("Execution error", (Throwable)e);
            }
        }
    }
}

