/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.data.beans;

import ch.elexis.core.data.beans.ContactType;
import ch.elexis.core.data.beans.base.BeanPersistentObject;
import ch.elexis.core.data.interfaces.IContact;
import ch.elexis.core.data.interfaces.IPatient;
import ch.elexis.core.data.interfaces.IPerson;
import ch.elexis.core.data.interfaces.IXid;
import ch.elexis.core.types.Country;
import ch.elexis.core.types.Gender;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Labor;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.TimeTool;
import java.util.List;

public class ContactBean
extends BeanPersistentObject<Kontakt>
implements IContact,
IPerson,
IPatient {
    private ContactCache cache = new ContactCache();

    public ContactBean(Kontakt kontakt) {
        super(kontakt);
    }

    public Patient getAsPatientEntity() {
        return (Patient)this.entity;
    }

    public Labor getAsLaboratoryEntity() {
        return (Labor)this.entity;
    }

    @Override
    protected void updateCache() {
        this.cache = new ContactCache();
    }

    @Override
    public ContactType getContactType() {
        if (this.cache.isOrganization) {
            return ContactType.ORGANIZATION;
        }
        if (this.cache.isPatient || this.cache.isPerson) {
            return ContactType.PERSON;
        }
        return ContactType.UNKNOWN;
    }

    @Override
    public void setContactType(ContactType type) {
        ContactType old = this.getContactType();
        switch (type) {
            case PERSON: {
                ((Kontakt)this.entity).set("istPerson", "1");
                ((Kontakt)this.entity).set("istOrganisation", "0");
                break;
            }
            case ORGANIZATION: {
                ((Kontakt)this.entity).set("istOrganisation", "1");
                ((Kontakt)this.entity).set("istPerson", "0");
                break;
            }
            case UNKNOWN: {
                ((Kontakt)this.entity).set("istOrganisation", "0");
                ((Kontakt)this.entity).set("istPerson", "0");
                break;
            }
        }
        this.firePropertyChange("contactType", (Object)old, (Object)type);
    }

    @Override
    public String getDescription1() {
        return this.cache.description1;
    }

    @Override
    public void setDescription1(String description) {
        String old = this.getDescription1();
        ((Kontakt)this.entity).set("Bezeichnung1", description);
        this.firePropertyChange("description1", old, description);
    }

    @Override
    public String getDescription2() {
        return this.cache.description2;
    }

    @Override
    public void setDescription2(String description) {
        String old = this.getDescription2();
        ((Kontakt)this.entity).set("Bezeichnung2", description);
        this.firePropertyChange("description2", old, description);
    }

    @Override
    public String getDescription3() {
        return this.cache.description3;
    }

    @Override
    public void setDescription3(String description) {
        String old = this.getDescription3();
        ((Kontakt)this.entity).set("Bezeichnung3", description);
        this.firePropertyChange("description3", old, description);
    }

    @Override
    public String getZip() {
        return ((Kontakt)this.entity).get("Plz");
    }

    @Override
    public void setZip(String zip) {
        String old = this.getZip();
        ((Kontakt)this.entity).set("Plz", zip);
        this.firePropertyChange("zip", old, zip);
    }

    @Override
    public String getCity() {
        return ((Kontakt)this.entity).get("Ort");
    }

    @Override
    public void setCity(String city) {
        String old = this.getCity();
        ((Kontakt)this.entity).set("Ort", city);
        this.firePropertyChange("city", old, city);
    }

    @Override
    public String getStreet() {
        return ((Kontakt)this.entity).get("Strasse");
    }

    @Override
    public void setStreet(String street) {
        String old = this.getStreet();
        ((Kontakt)this.entity).set("Strasse", street);
        this.firePropertyChange("street", old, street);
    }

    @Override
    public String getPhone1() {
        return ((Kontakt)this.entity).get("Telefon1");
    }

    @Override
    public void setPhone1(String phone) {
        String old = this.getPhone1();
        ((Kontakt)this.entity).set("Telefon1", phone);
        this.firePropertyChange("phone1", old, phone);
    }

    @Override
    public String getPhone2() {
        return ((Kontakt)this.entity).get("Telefon2");
    }

    @Override
    public void setPhone2(String phone) {
        String old = this.getPhone2();
        ((Kontakt)this.entity).set("Telefon2", phone);
        this.firePropertyChange("phone2", old, phone);
    }

    @Override
    public String getFax() {
        return ((Kontakt)this.entity).get("Fax");
    }

    @Override
    public void setFax(String fax) {
        String old = this.getFax();
        ((Kontakt)this.entity).set("Fax", fax);
        this.firePropertyChange("fax", old, fax);
    }

    @Override
    public String getEmail() {
        return ((Kontakt)this.entity).get("E-Mail");
    }

    @Override
    public void setEmail(String email) {
        String old = this.getEmail();
        ((Kontakt)this.entity).set("E-Mail", email);
        this.firePropertyChange("email", old, email);
    }

    @Override
    public String getWebsite() {
        return ((Kontakt)this.entity).get("Website");
    }

    @Override
    public void setWebsite(String website) {
        String old = this.getWebsite();
        ((Kontakt)this.entity).set("Website", website);
        this.firePropertyChange("website", old, website);
    }

    @Override
    public String getMobile() {
        return ((Kontakt)this.entity).get("NatelNr");
    }

    @Override
    public void setMobile(String mobile) {
        String old = this.getMobile();
        ((Kontakt)this.entity).set("NatelNr", mobile);
        this.firePropertyChange("mobile", old, mobile);
    }

    @Override
    public String getComment() {
        return ((Kontakt)this.entity).getBemerkung();
    }

    @Override
    public void setComment(String comment) {
        String old = this.getComment();
        ((Kontakt)this.entity).setBemerkung(comment);
        this.firePropertyChange("comment", old, comment);
    }

    @Override
    public String getId() {
        return ((Kontakt)this.entity).getId();
    }

    @Override
    public String getLabel() {
        return String.valueOf(this.getDescription1()) + " " + this.getDescription2() + ", " + this.getStreet() + ", " + this.getZip() + " " + this.getCity();
    }

    @Override
    public boolean isMandator() {
        return this.cache.isMandator;
    }

    @Override
    public void setMandator(boolean value) {
        boolean old = this.isMandator();
        ((Kontakt)this.entity).set("istMandant", value ? "1" : "0");
        this.firePropertyChange("mandator", old, value);
    }

    @Override
    public boolean isUser() {
        return this.cache.isUser;
    }

    @Override
    public void setUser(boolean value) {
        boolean old = this.isUser();
        ((Kontakt)this.entity).set("istAnwender", value ? "1" : "0");
        this.firePropertyChange("user", old, value);
    }

    @Override
    public boolean isPatient() {
        return this.cache.isPatient;
    }

    @Override
    public void setPatient(boolean value) {
        boolean old = this.isPatient();
        ((Kontakt)this.entity).set("istPatient", value ? "1" : "0");
        this.firePropertyChange("patient", old, value);
    }

    @Override
    public String getCode() {
        return this.cache.code;
    }

    @Override
    public void setCode(String value) {
        String old = this.getCode();
        ((Kontakt)this.entity).set("PatientNr", value);
        this.firePropertyChange("code", old, value);
    }

    @Override
    public Country getCountry() {
        Country ret;
        String countryVal = ((Kontakt)this.entity).get("Land");
        try {
            ret = Country.fromValue((String)countryVal);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            ret = Country.NDF;
        }
        return ret;
    }

    @Override
    public void setCountry(Country value) {
        Country old = this.getCountry();
        ((Kontakt)this.entity).set("Land", value.value());
        this.firePropertyChange("country", old, value);
    }

    @Override
    public boolean isDeleted() {
        return this.cache.isDeleted;
    }

    public void setDeleted(boolean value) {
        boolean old = this.isDeleted();
        ((Kontakt)this.entity).delete();
        this.firePropertyChange("deleted", old, value);
    }

    @Override
    public TimeTool getDateOfBirth() {
        return this.cache.dateOfBirth;
    }

    @Override
    public void setDateOfBirth(TimeTool value) {
        TimeTool old = this.getDateOfBirth();
        ((Kontakt)this.entity).set("Geburtsdatum", value.toString(9));
        this.firePropertyChange("dateOfBirth", old, value);
    }

    @Override
    public Gender getGender() {
        return this.cache.sex;
    }

    @Override
    public void setGender(Gender value) {
        Gender old = this.getGender();
        ((Kontakt)this.entity).set("Geschlecht", switch (value) {
            case Gender.MALE -> "m";
            case Gender.FEMALE -> "w";
            case Gender.UNDEFINED -> "u";
            default -> "";
        });
        this.firePropertyChange("gender", old, value);
    }

    @Override
    public String getTitel() {
        return this.cache.titel;
    }

    @Override
    public void setTitel(String value) {
        String old = this.getTitel();
        ((Kontakt)this.entity).set("Titel", value);
        this.firePropertyChange("titel", old, value);
    }

    @Override
    public String getTitelSuffix() {
        return this.cache.titelSuffix;
    }

    @Override
    public void setTitelSuffix(String value) {
        String old = this.getTitel();
        ((Kontakt)this.entity).set("TitelSuffix", value);
        this.firePropertyChange("titelSuffix", old, value);
    }

    @Override
    public String getDiagnosen() {
        return null;
    }

    @Override
    public void setDiagnosen(String value) {
    }

    @Override
    public String getRisk() {
        return null;
    }

    @Override
    public void setRisk(String value) {
    }

    @Override
    public String getFamilyAnamnese() {
        return null;
    }

    @Override
    public void setFamilyAnamnese(String value) {
    }

    @Override
    public String getPersonalAnamnese() {
        return null;
    }

    @Override
    public void setPersonalAnamnese(String value) {
    }

    @Override
    public String getAllergies() {
        return null;
    }

    @Override
    public void setAllergies(String value) {
    }

    @Override
    public String getPatientLabel() {
        return null;
    }

    @Override
    public String getPatientNr() {
        return this.getCode();
    }

    @Override
    public void setPatientNr(String value) {
        this.setCode(value);
    }

    @Override
    public String getFirstName() {
        return this.cache.description2;
    }

    @Override
    public String getFamilyName() {
        return this.cache.description1;
    }

    @Override
    public IXid getXid() {
        return null;
    }

    @Override
    public List<IXid> getXids() {
        return null;
    }

    @Override
    public long getLastUpdate() {
        return 0L;
    }

    @Override
    public boolean isValid() {
        return false;
    }

    @Override
    public String storeToString() {
        return null;
    }

    @Override
    public int state() {
        return 0;
    }

    @Override
    public boolean exists() {
        return false;
    }

    @Override
    public boolean isAvailable() {
        return false;
    }

    @Override
    public String getXid(String domain) {
        return null;
    }

    @Override
    public boolean addXid(String domain, String domain_id, boolean updateIfExists) {
        return false;
    }

    @Override
    public boolean get(String[] fields, String[] values) {
        return false;
    }

    @Override
    public String get(String field) {
        return null;
    }

    @Override
    public boolean set(String field, String value) {
        return false;
    }

    private class ContactCache {
        boolean isDeleted;
        boolean isPerson;
        boolean isOrganization;
        boolean isMandator;
        boolean isUser;
        boolean isPatient;
        String code;
        String description1;
        String description2;
        String description3;
        String titel;
        String titelSuffix;
        TimeTool dateOfBirth;
        Gender sex;

        public ContactCache() {
            if (PersistentObject.map("KONTAKT", "PatientNr").startsWith("**ERROR:")) {
                Patient.load("0");
            }
            String[] labels = new String[14];
            ((Kontakt)ContactBean.this.entity).get(new String[]{"deleted", "istPerson", "istOrganisation", "istMandant", "istAnwender", "istPatient", "Bezeichnung1", "Bezeichnung2", "Bezeichnung3", "Geburtsdatum", "Geschlecht", "PatientNr", "Titel", "TitelSuffix"}, labels);
            this.isDeleted = labels[0].equals("1");
            this.isPerson = labels[1].equals("1");
            this.isOrganization = labels[2].equals("1");
            this.isMandator = labels[3].equals("1");
            this.isUser = labels[4].equals("1");
            this.isPatient = labels[5].equals("1");
            this.description1 = labels[6];
            this.description2 = labels[7];
            this.description3 = labels[8];
            this.dateOfBirth = new TimeTool(labels[9]);
            this.sex = this.switchSex(labels[10]);
            this.code = labels[11];
            this.titel = labels[12];
            this.titelSuffix = labels[13];
        }

        private Gender switchSex(String labels) {
            if (labels == null || labels.length() < 1) {
                return Gender.UNKNOWN;
            }
            switch (labels.toLowerCase().charAt(0)) {
                case 'w': {
                    return Gender.FEMALE;
                }
                case 'f': {
                    return Gender.FEMALE;
                }
                case 'u': {
                    return Gender.UNDEFINED;
                }
                case 'm': {
                    return Gender.MALE;
                }
            }
            return Gender.UNKNOWN;
        }
    }
}

