/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.model.InvoiceState;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.data.AbstractPersistentObjectTest;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Mandant;
import ch.elexis.data.Messages;
import ch.elexis.data.Patient;
import ch.elexis.data.Rechnung;
import ch.rgw.tools.Money;
import org.junit.Assert;
import org.junit.Test;

public class Test_Rechnung
extends AbstractPersistentObjectTest {
    @Test
    public void testRemoveOpenReminders() {
        Mandant mandant = new Mandant("TestMandant", "TestMandant", "01.01.70", "w");
        Patient patient = new Patient("TestPatient", "TestPatient", "01.01.70", "w");
        Konsultation kons = patient.createFallUndKons();
        Fall fall = kons.getFall();
        ConfigServiceHolder.setGlobal((String)"rechnung/reminder/removeopen", (boolean)true);
        Rechnung rechnung = new Rechnung("1", mandant, fall, kons.getDatum(), kons.getDatum(), new Money(10000), InvoiceState.OPEN.getState());
        rechnung.setStatus(InvoiceState.DEMAND_NOTE_1);
        rechnung.addZahlung(new Money(10).multiply(-1.0), Messages.Rechnung_Mahngebuehr1, null);
        Assert.assertTrue((rechnung.getInvoiceState() == InvoiceState.DEMAND_NOTE_1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)rechnung.hasReminders());
        rechnung.addZahlung(new Money(10000), "initial amount", null);
        Assert.assertTrue((rechnung.getInvoiceState() == InvoiceState.PAID ? 1 : 0) != 0);
        Assert.assertFalse((boolean)rechnung.hasReminders());
        rechnung = new Rechnung("2", mandant, fall, kons.getDatum(), kons.getDatum(), new Money(10000), InvoiceState.OPEN.getState());
        rechnung.setStatus(InvoiceState.DEMAND_NOTE_1);
        rechnung.addZahlung(new Money(10).multiply(-1.0), Messages.Rechnung_Mahngebuehr1, null);
        Assert.assertTrue((rechnung.getInvoiceState() == InvoiceState.DEMAND_NOTE_1 ? 1 : 0) != 0);
        rechnung.setStatus(InvoiceState.DEMAND_NOTE_2);
        rechnung.addZahlung(new Money(10).multiply(-1.0), Messages.Rechnung_Mahngebuehr2, null);
        Assert.assertTrue((rechnung.getInvoiceState() == InvoiceState.DEMAND_NOTE_2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)rechnung.hasReminders());
        rechnung.addZahlung(new Money(5000), "partial amount", null);
        Assert.assertTrue((rechnung.getInvoiceState() == InvoiceState.PARTIAL_PAYMENT ? 1 : 0) != 0);
        rechnung.addZahlung(new Money(5000), "partial amount", null);
        Assert.assertTrue((rechnung.getInvoiceState() == InvoiceState.PAID ? 1 : 0) != 0);
        Assert.assertFalse((boolean)rechnung.hasReminders());
    }

    @Test
    public void testDontRemoveOpenReminders() {
        Mandant mandant = new Mandant("TestMandant", "TestMandant", "01.01.70", "w");
        Patient patient = new Patient("TestPatient", "TestPatient", "01.01.70", "w");
        Konsultation kons = patient.createFallUndKons();
        Fall fall = kons.getFall();
        ConfigServiceHolder.setGlobal((String)"rechnung/reminder/removeopen", (boolean)false);
        Rechnung rechnung = new Rechnung("1", mandant, fall, kons.getDatum(), kons.getDatum(), new Money(10000), InvoiceState.OPEN.getState());
        rechnung.setStatus(InvoiceState.DEMAND_NOTE_1);
        rechnung.addZahlung(new Money(10).multiply(-1.0), Messages.Rechnung_Mahngebuehr1, null);
        Assert.assertTrue((rechnung.getInvoiceState() == InvoiceState.DEMAND_NOTE_1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)rechnung.hasReminders());
        rechnung.addZahlung(new Money(10000), "initial amount", null);
        Assert.assertFalse((rechnung.getInvoiceState() == InvoiceState.PAID ? 1 : 0) != 0);
        Assert.assertTrue((boolean)rechnung.hasReminders());
    }
}

