/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.model.IContact;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.data.AbstractPersistentObjectTest;
import ch.elexis.data.Organisation;
import ch.elexis.data.Patient;
import ch.elexis.data.Person;
import ch.elexis.data.Query;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class Test_Patient
extends AbstractPersistentObjectTest {
    @Test
    public void testNameWithApostrophe() {
        String familyNameWithApostrophe = "D'Andrea";
        Patient male = new Patient("Mustermann", "Max", "1.1.2000", "m");
        male.set("Name", "D'Andrea");
        assert (male.getName() == "D'Andrea");
        Query qbe = new Query(Patient.class);
        qbe.add("Name", "LIKE", "D'Andrea");
        List res = qbe.execute();
        assert (res.size() == 1);
        male.delete();
    }

    @Test
    public void TestVorname() {
        String givenName = "Maria";
        Patient female = new Patient("Musterfrau", "Erika", "1.1.2000", "f");
        female.set("Name", "Maria");
        System.out.println("female.getVorname() is " + female.getVorname());
        assert (female.getVorname() == "Maria");
        Query qbe = new Query(Patient.class);
        qbe.add("Name", "LIKE", "Maria");
        List res = qbe.execute();
        assert (res.size() == 1);
    }

    @Test
    public void getPostAnschriftPatient() {
        Person person = new Person("Name", "Vorname", "26.07.1979", "m");
        person.set("Strasse", "Strasse 14");
        person.set("Land", "CH");
        person.set("Ort", "City");
        person.set("Titel", "Dr.");
        person.set("Plz", "4433");
        String postAnschrift = person.getPostAnschrift(true);
        person.set("Anschrift", null);
        IContact contact = (IContact)CoreModelServiceHolder.get().load(person.getId(), IContact.class).orElseThrow();
        String postalAddress = contact.getPostalAddress();
        Assert.assertEquals((Object)postAnschrift, (Object)postalAddress);
        person.removeFromDatabase();
    }

    @Test
    public void getPostAnschriftOrganisation() {
        Organisation organization = new Organisation("Name", "Zusatz1");
        organization.set("Strasse", "Strasse 14");
        organization.set("Land", "CH");
        organization.set("Ort", "City");
        organization.set("Plz", "4433");
        String postAnschrift = organization.getPostAnschrift(true);
        organization.set("Anschrift", null);
        IContact contact = (IContact)CoreModelServiceHolder.get().load(organization.getId(), IContact.class).orElseThrow();
        String postalAddress = contact.getPostalAddress();
        Assert.assertEquals((Object)postAnschrift, (Object)postalAddress);
        organization.removeFromDatabase();
    }
}

