/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.text.docx;

import at.medevit.elexis.text.docx.print.PrintProcess;
import at.medevit.elexis.text.docx.print.ScriptInitializer;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.preferences.Messages;
import ch.elexis.core.ui.text.ITextPlugin;
import ch.elexis.core.ui.views.textsystem.TextTemplatePrintSettings;
import ch.elexis.core.utils.CoreUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.Properties;
import org.docx4j.Docx4J;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.LoggerFactory;

public class DocxTextPlugin
extends ch.elexis.core.text.docx.DocxTextPlugin
implements ITextPlugin {
    private static final String DOCX_PREF = "textplugins/docx/";
    public static final String PRINT_PROCESS_TIMEOUT = "textplugins/docx/printtimeout";
    public static final String PRINT_COMMAND_PREF = "textplugins/docx/printcommand";
    public static final String PRINTTOPRINTER_COMMAND_PREF = "textplugins/docx/printtoprintercommand";
    public static final String USE_PRINT_SCRIPT = "textplugins/docx/printcommand";
    private static TextTemplatePrintSettings printSettings;
    private Composite composite;
    private Button openButton;

    public void setFocus() {
        if (this.composite != null && !this.composite.isDisposed()) {
            this.composite.setFocus();
        }
    }

    public void dispose() {
        this.composite.dispose();
    }

    public void showMenu(boolean b) {
    }

    public void showToolbar(boolean b) {
    }

    public void setSaveOnFocusLost(boolean bSave) {
    }

    public boolean createEmptyDocument() {
        boolean ret = super.createEmptyDocument();
        if (ret && this.openButton != null && !this.openButton.isDisposed()) {
            this.openButton.setEnabled(true);
        }
        return ret;
    }

    public boolean loadFromByteArray(byte[] bs, boolean asTemplate) {
        if (this.checkTextPreferences()) {
            boolean ret = super.loadFromByteArray(bs, asTemplate);
            if (ret && this.openButton != null && !this.openButton.isDisposed()) {
                this.openButton.setEnabled(true);
            }
            return ret;
        }
        return false;
    }

    private boolean checkTextPreferences() {
        boolean editLocal = CoreHub.localCfg.get("briefe/Textmodul_Edit_Local", false);
        boolean externFile = ConfigServiceHolder.getGlobal((String)"briefe/Textmodul_Extern_File", (boolean)false);
        if (editLocal && externFile) {
            return true;
        }
        StringBuilder missingOptionText = new StringBuilder();
        if (!editLocal && !externFile) {
            missingOptionText.append("Es sind aktuell beide Optionen nicht aktiviert.");
        } else {
            missingOptionText.append("Die Option [");
            if (!editLocal) {
                missingOptionText.append(Messages.Texterstellung_texteditlocaldesc);
            } else if (!externFile) {
                missingOptionText.append("Brief extern speichern");
            }
            missingOptionText.append("] ist aktuell nicht aktiviert.");
        }
        return MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)"Warnung", (String)("Bei Benutzung der Docx-Document Textausgabe wird empfohlen unter Einstellungen > Textverarbeitung folgende Optionen zu aktivieren.\n\n* " + Messages.Texterstellung_texteditlocaldesc + "\n" + "* " + "Brief extern speichern" + "\n\n" + missingOptionText.toString() + "\n" + "Wollen Sie trotzdem weiter machen?"));
    }

    public boolean loadFromStream(InputStream is, boolean asTemplate) {
        boolean ret = super.loadFromStream(is, asTemplate);
        if (ret && this.openButton != null && !this.openButton.isDisposed()) {
            this.openButton.setEnabled(true);
        }
        return ret;
    }

    public boolean clear() {
        return false;
    }

    public boolean print(String toPrinter, String toTray, boolean waitUntilFinished) {
        if (this.getCurrentDocument() != null) {
            if (CoreUtil.isWindows() && ConfigServiceHolder.getGlobal((String)"textplugins/docx/printcommand", (boolean)false) && !this.isScriptWinInitialized()) {
                this.initializeScriptWin();
            }
            if (printSettings != null) {
                toPrinter = printSettings.getPrinter() == null ? toPrinter : printSettings.getPrinter();
                toTray = printSettings.getTray() == null ? toTray : printSettings.getTray();
            }
            String printCommand = null;
            printCommand = toPrinter != null && !toPrinter.isEmpty() ? this.getPrintPrinterCommand() : this.getPrintNoPrinterCommand();
            if (printCommand != null) {
                Optional<File> tempFile = this.getCurrentDocumentTempFile();
                if (tempFile.isPresent()) {
                    PrintProcess process = new PrintProcess(printCommand);
                    process.setPrinter(toPrinter);
                    process.setTray(toTray);
                    process.setFilename(tempFile.get().getAbsolutePath());
                    return process.execute();
                }
            } else {
                this.openCurrentDocument();
            }
            return true;
        }
        return false;
    }

    public void initTemplatePrintSettings(String template) {
        printSettings = new TextTemplatePrintSettings(template, this.getMimeType());
    }

    private String getPrintNoPrinterCommand() {
        Properties commandsProperties;
        if (CoreUtil.isWindows() && ConfigServiceHolder.getGlobal((String)"textplugins/docx/printcommand", (boolean)false) && (commandsProperties = ScriptInitializer.getPrintCommands("/rsc/script/win/printcommands.properties")) != null && commandsProperties.get("noprinter") != null) {
            return (String)commandsProperties.get("noprinter");
        }
        return CoreHub.localCfg.get("textplugins/docx/printcommand", null);
    }

    private String getPrintPrinterCommand() {
        Properties commandsProperties;
        if (CoreUtil.isWindows() && ConfigServiceHolder.getGlobal((String)"textplugins/docx/printcommand", (boolean)false) && (commandsProperties = ScriptInitializer.getPrintCommands("/rsc/script/win/printcommands.properties")) != null && commandsProperties.get("printer") != null) {
            return (String)commandsProperties.get("printer");
        }
        return CoreHub.localCfg.get(PRINTTOPRINTER_COMMAND_PREF, null);
    }

    private void openCurrentDocument() {
        if (this.getCurrentDocument() != null) {
            Optional<File> tempFile = this.getCurrentDocumentTempFile();
            tempFile.ifPresent(f -> {
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).debug("Open temporary document from [" + f.getAbsolutePath() + "]");
                Program.launch((String)f.getAbsolutePath());
            });
        }
    }

    private Optional<File> getCurrentDocumentTempFile() {
        try {
            File tempFile = File.createTempFile("dtp_", "_" + System.currentTimeMillis() + ".docx");
            tempFile.deleteOnExit();
            Docx4J.save((OpcPackage)((WordprocessingMLPackage)this.getCurrentDocument()), (File)tempFile, (int)1);
            return Optional.of(tempFile);
        }
        catch (IOException | Docx4JException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error saving docx temp file", e);
            return Optional.empty();
        }
    }

    public boolean isDirectOutput() {
        return false;
    }

    public Composite createContainer(Composite parent, ITextPlugin.ICallback handler) {
        if (this.composite == null) {
            this.composite = new Composite(parent, 0);
            RowLayout layout = new RowLayout(512);
            layout.wrap = true;
            layout.fill = false;
            layout.justify = false;
            layout.marginBottom = 9;
            this.composite.setLayout((Layout)layout);
            RowData data = new RowData();
            Label label = new Label(this.composite, 8);
            label.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
            label.setText("docx Dokumente Generator ohne Editor\n");
            label.setLayoutData((Object)data);
            data.width = 400;
            this.openButton = new Button(this.composite, 8);
            this.openButton.setText("Dokument \u00f6ffnen");
            this.openButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    DocxTextPlugin.this.openCurrentDocument();
                }
            });
            data = new RowData();
            this.openButton.setLayoutData((Object)data);
            this.openButton.setEnabled(false);
            this.composite.pack();
        }
        return this.composite;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    private boolean isScriptWinInitialized() {
        ScriptInitializer initializer = new ScriptInitializer("/rsc/script/win/doc2sumatraprint.ps1");
        if (!initializer.existsInScriptFolder()) {
            return false;
        }
        if (!initializer.matchingFileSize()) {
            return false;
        }
        initializer = new ScriptInitializer("/rsc/script/win/SumatraPDF.exe");
        if (!initializer.existsInScriptFolder()) {
            return false;
        }
        return initializer.matchingFileSize();
    }

    private void initializeScriptWin() {
        ScriptInitializer initializer = new ScriptInitializer("/rsc/script/win/doc2sumatraprint.ps1");
        if (initializer.existsInScriptFolder()) {
            if (MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)"Script existiert bereits", (String)("Script [" + initializer.getFilename() + "] existiert bereits, soll die Datei \u00fcberschrieben werden?"))) {
                initializer.init();
            }
        } else {
            initializer.init();
        }
        if ((initializer = new ScriptInitializer("/rsc/script/win/SumatraPDF.exe")).existsInScriptFolder()) {
            if (MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)"Script existiert bereits", (String)("Script [" + initializer.getFilename() + "] existiert bereits, soll die Datei \u00fcberschrieben werden?"))) {
                initializer.init();
            }
        } else {
            initializer.init();
        }
    }
}

