/*
 * Decompiled with CFR 0.152.
 */
package waelti.statistics.queries;

import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import ch.rgw.tools.Money;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import waelti.statistics.queries.AbstractTimeSeries;
import waelti.statistics.queries.QueryUtil;
import waelti.statistics.queries.providers.QueryContentProvider;
import waelti.statistics.queries.providers.QueryLabelProvider;

public class PatientCosts
extends AbstractTimeSeries {
    private List<String> headings;
    private final Query<Patient> patientQuery = new Query(Patient.class);
    private IProgressMonitor monitor;
    private int size = 0;

    public PatientCosts() {
        super("Kosten pro Patient");
        this.initHeading();
    }

    private void initHeading() {
        this.headings = new ArrayList<String>();
        this.headings.add("Patient");
        this.headings.add("Gesamtkosten");
    }

    @Override
    public IStatus execute(IProgressMonitor monitor) {
        this.monitor = monitor;
        this.createContent();
        this.initProvider();
        this.monitor.done();
        return Status.OK_STATUS;
    }

    private void initProvider() {
        QueryContentProvider content = new QueryContentProvider(this.getList());
        QueryLabelProvider label = new QueryLabelProvider();
        this.setContentProvider(content);
        this.setLabelProvider(label);
    }

    private void createContent() {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        Object[] patients = this.patientQuery.execute().toArray();
        this.size = patients.length;
        this.monitor.beginTask("querying database", this.size);
        Object[] objectArray = patients;
        int n = patients.length;
        int n2 = 0;
        while (n2 < n) {
            Object pat = objectArray[n2];
            Patient patient = (Patient)pat;
            this.monitor.worked(1);
            Money costs = this.handleCases(patient);
            if (costs.getCents() != 0) {
                Object[] row = new Object[]{patient.getLabel(), costs};
                list.add(row);
            }
            ++n2;
        }
        this.setList(list);
    }

    private Money handleCases(Patient patient) {
        Fall[] faelle;
        double costs = 0.0;
        Fall[] fallArray = faelle = patient.getFaelle();
        int n = faelle.length;
        int n2 = 0;
        while (n2 < n) {
            Fall fall = fallArray[n2];
            costs += this.handleConsultation(fall);
            ++n2;
        }
        return new Money(costs /= 100.0);
    }

    private double handleConsultation(Fall fall) {
        Konsultation[] cons;
        double costs = 0.0;
        Konsultation[] konsultationArray = cons = fall.getBehandlungen(false);
        int n = cons.length;
        int n2 = 0;
        while (n2 < n) {
            Konsultation konsultation = konsultationArray[n2];
            if (this.inPeriod(konsultation.getDatum())) {
                costs += konsultation.getUmsatz();
            }
            ++n2;
        }
        return costs;
    }

    private boolean inPeriod(String date) {
        Calendar givenDate = Calendar.getInstance();
        try {
            givenDate = QueryUtil.convertToCalendar(date);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return givenDate.compareTo(this.getStartDate()) >= 0 && givenDate.compareTo(this.getEndDate()) <= 0;
    }

    @Override
    public String getDescription() {
        return "Erstellt eine Liste mit allen Patienten, die in der gegebenen Zeitspanne eine Konsultation hatten und die gesamten Kosten, die bei diesen Patienten anfielen.";
    }

    @Override
    public List<String> getTableHeadings() {
        return this.headings;
    }

    @Override
    public String getTitle() {
        return "Kosten pro Patient";
    }

    @Override
    public String getHeader() {
        String str = super.getHeader();
        str = String.valueOf(str) + "\nAuswertungszeitraum: " + QueryUtil.convertFromCalendar(this.getStartDate());
        str = String.valueOf(str) + " - " + QueryUtil.convertFromCalendar(this.getEndDate());
        return str;
    }

    public int getSize() {
        return this.size;
    }
}

