/*
 * Decompiled with CFR 0.152.
 */
package waelti.statistics.queries;

import ch.elexis.core.ui.actions.BackgroundJob;
import java.util.Calendar;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import waelti.statistics.queries.QueryUtil;
import waelti.statistics.queries.ResultMatrix;

public abstract class AbstractQuery
extends BackgroundJob {
    private List<Object[]> list;
    private ITableLabelProvider labelProvider;
    private IStructuredContentProvider contentProvider;

    protected AbstractQuery(String name) {
        super(name);
    }

    public abstract List<String> getTableHeadings();

    public String getHeader() {
        String header = "Auswertungsname: ";
        header = String.valueOf(header) + this.getTitle() + "\n";
        header = String.valueOf(header) + "Auswertungsdatum: " + QueryUtil.convertFromCalendar(Calendar.getInstance());
        return header;
    }

    public abstract String getTitle();

    public abstract String getDescription();

    public abstract IStatus execute(IProgressMonitor var1);

    public IStructuredContentProvider getContentProvider() {
        return this.contentProvider;
    }

    public ITableLabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public ResultMatrix getMatrix() {
        return new ResultMatrix(this.list, this.getTableHeadings());
    }

    protected void setList(List<Object[]> list) {
        this.list = list;
    }

    protected List<Object[]> getList() {
        return this.list;
    }

    protected void setLabelProvider(ITableLabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    protected void setContentProvider(IStructuredContentProvider contentProvider) {
        this.contentProvider = contentProvider;
    }
}

