/*
 * Decompiled with CFR 0.152.
 */
package org.iatrix.messwerte.views;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.Heartbeat;
import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.types.LabItemTyp;
import ch.elexis.core.types.PathologicDescription;
import ch.elexis.core.ui.dialogs.DateSelectorDialog;
import ch.elexis.core.ui.dialogs.DisplayTextDialog;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.events.RefreshingPartListener;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.views.IRefreshable;
import ch.elexis.data.LabGroup;
import ch.elexis.data.LabItem;
import ch.elexis.data.LabResult;
import ch.elexis.data.Labor;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MesswerteView
extends ViewPart
implements IRefreshable,
Heartbeat.HeartListener {
    public static final String ID = "org.iatrix.messwerte.views.MesswerteView";
    protected static Logger log = LoggerFactory.getLogger((String)"org.iatrix.messwerte.views.MesswerteView");
    private static final String GROUPS_ALL = "Alle Resultate";
    private static final String GROUPS_PRAXIS = "Praxislabor";
    private static final String FEMININ = "w";
    private static int columnsPerPage;
    private static final int PARAMETER_INDEX = 0;
    private static final int REF_INDEX = 1;
    private static final int DATES_OFFSET = 2;
    private static final int COLUMN_NAME_DEFAULT_WITH = 200;
    private static final int COLUMN_REF_DEFAULT_WITH = 110;
    private static final int COLUMN_DATE_DEFAULT_WITH = 110;
    private static final int COLUMN_DATE_INITIAL_MIN_WIDTH = 50;
    private Label pagesLabel;
    private TableViewer viewer;
    private TableViewerColumn tableNameColumn;
    private TableViewerColumn tableRefColumn;
    private TableViewerColumn[] tableDateColumns;
    private TableDate[] tableDates;
    private TableViewerFocusCellManager focusCellManager;
    private List<TimeTool> availableDates = new ArrayList<TimeTool>();
    private List<DateColumn> dateColumns = new ArrayList<DateColumn>();
    private List<TableDate> dateColumnsExpanded = new ArrayList<TableDate>();
    private Action newDateAction;
    private Action fwdAction;
    private Action backAction;
    private Action pathologicAction;
    private ComboViewer laborGroupsViewer;
    private List<BaseLabGroupElement> labGroupElements = new ArrayList<BaseLabGroupElement>();
    private Patient actPatient = null;
    private int currentPage = 0;
    private int lastPage = 0;
    private List<LabRow> viewerRows = new ArrayList<LabRow>();
    private List<Labor> ownLabors = new ArrayList<Labor>();
    private static final String LABORWRTE_TABLENAME = "LABORWERTE";
    private RefreshingPartListener udpateOnVisible = new RefreshingPartListener((ViewPart)this);
    private static Font boldFont;

    static {
        boldFont = null;
    }

    public static List<TimeTool> getAvailableDates(Patient patient) {
        ArrayList<TimeTool> dates = new ArrayList<TimeTool>();
        String sql = "SELECT Datum FROM LABORWERTE WHERE PatientID = ? GROUP BY Datum ORDER BY Datum";
        try {
            PreparedStatement ps = PersistentObject.getConnection().prepareStatement(sql);
            if (ps != null) {
                ps.setString(1, patient.getId());
                if (ps.execute()) {
                    ResultSet rs = ps.getResultSet();
                    while (rs.next()) {
                        String date = rs.getString(1);
                        dates.add(new TimeTool(date));
                    }
                }
            }
        }
        catch (SQLException ex) {
            ExHandler.handle((Throwable)ex);
            log.error("Fehler beim Ausf\u00fchren von " + sql);
        }
        log.debug("getAvailableDates: return " + dates.size() + " dates for " + patient.getPersonalia());
        return dates;
    }

    public static List<TimeTool> getAvailableDatesOfGroup(Patient patient, List<LabItem> labItems) {
        ArrayList<TimeTool> dates = new ArrayList<TimeTool>();
        String sql = "SELECT Datum, ItemID FROM LABORWERTE WHERE PatientID = ? GROUP BY Datum, ItemID ORDER BY Datum";
        try {
            ArrayList<String> dateStrings = new ArrayList<String>();
            PreparedStatement ps = PersistentObject.getConnection().prepareStatement(sql);
            if (ps != null) {
                ps.setString(1, patient.getId());
                if (ps.execute()) {
                    ResultSet rs = ps.getResultSet();
                    block2: while (rs.next()) {
                        String date = rs.getString(1);
                        String itemId = rs.getString(2);
                        if (dateStrings.contains(date)) continue;
                        for (LabItem labItem : labItems) {
                            if (!itemId.equals(labItem.getId())) continue;
                            dateStrings.add(date);
                            dates.add(new TimeTool(date));
                            continue block2;
                        }
                    }
                }
            }
        }
        catch (SQLException ex) {
            ExHandler.handle((Throwable)ex);
            log.error("Fehler beim Ausf\u00fchren von " + sql);
        }
        log.debug("getAvailableDatesOfGroup: return " + dates.size() + " for " + patient.getPersonalia());
        return dates;
    }

    public static List<LabItem> getAvailableItems(Patient patient) {
        ArrayList<LabItem> items = new ArrayList<LabItem>();
        String sql = "SELECT ItemID FROM LABORWERTE WHERE PatientID = ? GROUP BY ItemID";
        try {
            PreparedStatement ps = PersistentObject.getConnection().prepareStatement(sql);
            if (ps != null) {
                ps.setString(1, patient.getId());
                if (ps.execute()) {
                    ResultSet rs = ps.getResultSet();
                    while (rs.next()) {
                        String itemId = rs.getString(1);
                        LabItem item = LabItem.load((String)itemId);
                        if (item == null) continue;
                        items.add(item);
                    }
                }
            }
        }
        catch (SQLException ex) {
            ExHandler.handle((Throwable)ex);
            log.error("Fehler beim Ausf\u00fchren von " + sql);
        }
        log.debug("getAvailableItems: return " + items.size() + " items for " + patient.getPersonalia());
        return items;
    }

    private int getInitialColumnWidth(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return CoreHub.localCfg.get("org.iatrix.messwerte/messwerte_view_column_width_" + columnIndex, 200);
            }
            case 1: {
                return CoreHub.localCfg.get("org.iatrix.messwerte/messwerte_view_column_width_" + columnIndex, 110);
            }
        }
        return CoreHub.localCfg.get("org.iatrix.messwerte/messwerte_view_column_width_" + columnIndex, 110);
    }

    private void setInitialColumnWidth(int columnIndex, int width) {
        CoreHub.localCfg.set("org.iatrix.messwerte/messwerte_view_column_width_" + columnIndex, width);
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        columnsPerPage = CoreHub.localCfg.get("org.iatrix.messwerte/messwerte_view_number_of_columns", new Integer(7).intValue());
        this.tableDateColumns = new TableViewerColumn[columnsPerPage];
        this.tableDates = new TableDate[columnsPerPage];
        Composite headerArea = new Composite(parent, 0);
        headerArea.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        headerArea.setLayout((Layout)new GridLayout(2, false));
        Composite filterArea = new Composite(headerArea, 0);
        filterArea.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        filterArea.setLayout((Layout)new GridLayout(2, false));
        Label filterLabel = new Label(filterArea, 0);
        filterLabel.setText("Messwert-Gruppen:");
        this.laborGroupsViewer = new ComboViewer(filterArea, 772);
        this.laborGroupsViewer.setContentProvider((IContentProvider)new LabGroupsContentProvider());
        this.laborGroupsViewer.setInput((Object)this);
        this.laborGroupsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MesswerteView.this.reload();
            }
        });
        Composite infoArea = new Composite(headerArea, 0);
        infoArea.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        infoArea.setLayout((Layout)new GridLayout(1, false));
        this.pagesLabel = new Label(infoArea, 131072);
        this.pagesLabel.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.pagesLabel.setText("");
        this.viewer = new TableViewer(parent, 66306);
        Table table = this.viewer.getTable();
        table.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.focusCellManager = new TableViewerFocusCellManager(this.viewer, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)this.viewer));
        ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)this.viewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 5 || event.eventType == 3 || event.eventType == 1 && event.keyCode == 13 || event.eventType == 4;
            }
        };
        TableViewerEditor.create((TableViewer)this.viewer, (SWTFocusCellManager)this.focusCellManager, (ColumnViewerEditorActivationStrategy)actSupport, (int)58);
        this.tableNameColumn = new TableViewerColumn(this.viewer, 16384);
        this.tableNameColumn.getColumn().setWidth(this.getInitialColumnWidth(0));
        this.tableNameColumn.getColumn().addControlListener((ControlListener)new ColumnWidthSafer(0));
        this.tableNameColumn.getColumn().setText("Parameter");
        this.tableNameColumn.setLabelProvider((CellLabelProvider)new ViewLabelProvider(0));
        this.tableRefColumn = new TableViewerColumn(this.viewer, 16384);
        this.tableRefColumn.getColumn().setWidth(this.getInitialColumnWidth(1));
        this.tableRefColumn.getColumn().addControlListener((ControlListener)new ColumnWidthSafer(1));
        this.tableRefColumn.getColumn().setText("Ref");
        this.tableRefColumn.setLabelProvider((CellLabelProvider)new ViewLabelProvider(1));
        int i = 0;
        while (i < columnsPerPage) {
            this.tableDateColumns[i] = new TableViewerColumn(this.viewer, 16384);
            this.tableDateColumns[i].getColumn().setWidth(50);
            this.tableDates[i] = null;
            this.tableDateColumns[i].setEditingSupport((EditingSupport)new DateEditingSupport(this.viewer, i));
            this.tableDateColumns[i].setLabelProvider((CellLabelProvider)new ViewLabelProvider(2 + i));
            ++i;
        }
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setInput((Object)this.getViewSite());
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        this.initialize();
        this.viewer.getTable().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                MesswerteView.this.updateDateColumnWidths();
            }
        });
        this.getSite().getPage().addPartListener((IPartListener2)this.udpateOnVisible);
    }

    private void updateDateColumnWidths() {
        int refColumnWidth;
        int tableWidth = this.viewer.getTable().getSize().x;
        int nameColumnWidth = this.getInitialColumnWidth(0);
        int dateColumnsWidth = tableWidth - nameColumnWidth - (refColumnWidth = this.getInitialColumnWidth(1));
        if (dateColumnsWidth > 0) {
            int dateColumnWidth = dateColumnsWidth / columnsPerPage;
            int usedWidth = 0;
            int i = 0;
            while (i < this.tableDateColumns.length - 1) {
                this.tableDateColumns[i].getColumn().setWidth(dateColumnWidth);
                usedWidth += dateColumnWidth;
                ++i;
            }
            int remainingWidth = dateColumnsWidth - usedWidth;
            this.tableDateColumns[this.tableDateColumns.length - 1].getColumn().setWidth(remainingWidth);
        }
    }

    private void initialize() {
        this.loadLaborGroups();
        this.loadOwnLaborsFromConfig();
        this.reload();
    }

    public void dispose() {
        this.getSite().getPage().removePartListener((IPartListener2)this.udpateOnVisible);
        super.dispose();
    }

    private void loadLaborGroups() {
        this.labGroupElements = new ArrayList<BaseLabGroupElement>();
        this.labGroupElements.add(new AllGroupElement());
        this.labGroupElements.add(new OwnLabsElement());
        List<LabGroup> labGroups = this.getLabGroups();
        for (LabGroup labGroup : labGroups) {
            Group group = new Group(labGroup);
            this.labGroupElements.add(new GroupElement(group));
        }
        List<String> labItemGroups = this.getLabItemGroups();
        for (String labItemGroup : labItemGroups) {
            Group group = new Group(labItemGroup);
            this.labGroupElements.add(new GroupElement(group));
        }
        this.laborGroupsViewer.refresh();
        this.selectLabGroup(this.labGroupElements.get(0));
    }

    private void selectLabGroup(BaseLabGroupElement element) {
        StructuredSelection sel = new StructuredSelection((Object)element);
        this.laborGroupsViewer.setSelection((ISelection)sel);
    }

    private BaseLabGroupElement getSelectedLabGroupElement() {
        IStructuredSelection sel = (IStructuredSelection)this.laborGroupsViewer.getSelection();
        BaseLabGroupElement labGroupElement = (BaseLabGroupElement)sel.getFirstElement();
        return labGroupElement;
    }

    private List<LabGroup> getLabGroups() {
        Query query = new Query(LabGroup.class);
        query.orderBy(false, new String[]{"Name"});
        ArrayList labGroups = query.execute();
        if (labGroups == null) {
            labGroups = new ArrayList();
        }
        return labGroups;
    }

    private List<String> getLabItemGroups() {
        ArrayList<String> labItemGroups = new ArrayList<String>();
        Query query = new Query(LabItem.class);
        query.orderBy(false, new String[]{"Gruppe"});
        List items = query.execute();
        if (items != null) {
            for (LabItem item : items) {
                String groupName = item.getGroup();
                if (labItemGroups.contains(groupName)) continue;
                labItemGroups.add(groupName);
            }
        }
        return labItemGroups;
    }

    private void loadOwnLaborsFromConfig() {
        String[] laborIds;
        this.ownLabors = new ArrayList<Labor>();
        String localLabors = ConfigServiceHolder.getGlobal((String)"org.iatrix.messwerte/local_labors", (String)"");
        String[] stringArray = laborIds = localLabors.split("\\s*,\\s*");
        int n = laborIds.length;
        int n2 = 0;
        while (n2 < n) {
            Labor labor;
            String laborId = stringArray[n2];
            if (!StringTool.isNothing((Object)laborId) && (labor = Labor.load((String)laborId)) != null && labor.exists()) {
                this.ownLabors.add(labor);
            }
            ++n2;
        }
    }

    private boolean isOwnLabor(Labor labor) {
        if (labor == null) {
            return false;
        }
        return this.ownLabors.contains(labor);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                MesswerteView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.newDateAction);
        manager.add((IAction)this.backAction);
        manager.add((IAction)this.fwdAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new Separator("additions"));
        Object element = this.viewer.getColumnViewerEditor().getFocusCell().getElement();
        int columnIndex = this.viewer.getColumnViewerEditor().getFocusCell().getColumnIndex();
        if (element instanceof LabRowValues) {
            int datesIndex;
            TableDate tableDate;
            LabRowValues labRowValues = (LabRowValues)element;
            if (columnIndex >= 2 && (tableDate = this.tableDates[datesIndex = columnIndex - 2]) != null) {
                List<LabResult> labResults;
                String date = tableDate.date;
                int valueIndex = tableDate.index;
                if (!StringTool.isNothing((Object)date) && (labResults = labRowValues.results.get(date)) != null && labResults.size() > valueIndex) {
                    LabResult labResult = labResults.get(valueIndex);
                    boolean isPathologic = false;
                    if (labResult.isFlag(1)) {
                        isPathologic = true;
                    }
                    this.pathologicAction.setChecked(isPathologic);
                    manager.add((IAction)this.pathologicAction);
                }
            }
        }
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.newDateAction);
        manager.add((IAction)this.backAction);
        manager.add((IAction)this.fwdAction);
    }

    private void makeActions() {
        this.newDateAction = new Action(){

            public void run() {
                DateSelectorDialog dsd = new DateSelectorDialog(MesswerteView.this.getViewSite().getShell());
                if (dsd.open() == 0) {
                    TimeTool date = dsd.getSelectedDate();
                    int i = MesswerteView.this.dateColumns.size() - 1;
                    while (i >= 0) {
                        DateColumn dateColumn = MesswerteView.this.dateColumns.get(i);
                        if (dateColumn.date.equals((Object)date)) {
                            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"Datumskonflikt", (String)"Es existiert bereits ein Eintrag f\u00fcr dieses Datum.");
                            return;
                        }
                        --i;
                    }
                    boolean found = false;
                    int i2 = MesswerteView.this.dateColumns.size() - 1;
                    while (i2 >= 0) {
                        DateColumn dateColumn = MesswerteView.this.dateColumns.get(i2);
                        TimeTool currentDate = dateColumn.date;
                        int cmp = currentDate.compareTo((Calendar)date);
                        if (cmp < 0) {
                            DateColumn newDateColumn = new DateColumn(date, 1);
                            MesswerteView.this.dateColumns.add(i2 + 1, newDateColumn);
                            found = true;
                            break;
                        }
                        if (cmp == 0) {
                            ++dateColumn.numberOfColumns;
                            found = true;
                            break;
                        }
                        --i2;
                    }
                    if (!found) {
                        DateColumn newDateColumn = new DateColumn(date, 1);
                        MesswerteView.this.dateColumns.add(0, newDateColumn);
                    }
                    MesswerteView.this.prepareViewerPages();
                    MesswerteView.this.currentPage = MesswerteView.this.lastPage;
                    int index = -1;
                    int i3 = MesswerteView.this.dateColumnsExpanded.size() - 1;
                    while (i3 >= 0) {
                        TableDate tableDate = MesswerteView.this.dateColumnsExpanded.get(i3);
                        if (tableDate.date.equals(date)) {
                            index = i3;
                            break;
                        }
                        --i3;
                    }
                    if (index >= 0) {
                        int numberOfDates = MesswerteView.this.dateColumnsExpanded.size();
                        int firstPageColumnOffset = (columnsPerPage - numberOfDates % columnsPerPage) % columnsPerPage;
                        int indexInPages = index + firstPageColumnOffset;
                        MesswerteView.this.currentPage = indexInPages / columnsPerPage;
                    }
                    MesswerteView.this.updateViewerPage();
                }
            }
        };
        this.newDateAction.setText("Neues Datum...");
        this.newDateAction.setToolTipText("Neue Datum-Spalte erstellen");
        this.newDateAction.setImageDescriptor(Images.IMG_ADDITEM.getImageDescriptor());
        this.fwdAction = new Action(){

            public void run() {
                if (MesswerteView.this.currentPage < MesswerteView.this.lastPage) {
                    ++MesswerteView.this.currentPage;
                    MesswerteView.this.updateViewerPage();
                }
            }
        };
        this.fwdAction.setText("N\u00e4chste Seite");
        this.fwdAction.setToolTipText("N\u00e4chste Seite");
        this.fwdAction.setImageDescriptor(Images.IMG_NEXT.getImageDescriptor());
        this.backAction = new Action(){

            public void run() {
                if (MesswerteView.this.currentPage > 0) {
                    --MesswerteView.this.currentPage;
                    MesswerteView.this.updateViewerPage();
                }
            }
        };
        this.backAction.setText("Vorherige Seite");
        this.backAction.setToolTipText("Vorherige Seite");
        this.backAction.setImageDescriptor(Images.IMG_PREVIOUS.getImageDescriptor());
        this.pathologicAction = new Action(){

            public void run() {
                Object element = MesswerteView.this.viewer.getColumnViewerEditor().getFocusCell().getElement();
                int columnIndex = MesswerteView.this.viewer.getColumnViewerEditor().getFocusCell().getColumnIndex();
                if (element instanceof LabRowValues) {
                    int datesIndex;
                    TableDate tableDate;
                    LabRowValues labRowValues = (LabRowValues)element;
                    if (columnIndex >= 2 && (tableDate = MesswerteView.this.tableDates[datesIndex = columnIndex - 2]) != null) {
                        List<LabResult> labResults;
                        String date = tableDate.date;
                        int valueIndex = tableDate.index;
                        if (!StringTool.isNothing((Object)date) && (labResults = labRowValues.results.get(date)) != null && labResults.size() > valueIndex) {
                            LabResult labResult = labResults.get(valueIndex);
                            boolean isPathologic = this.isChecked();
                            labResult.setFlag(1, isPathologic);
                            labResult.setPathologicDescription(new PathologicDescription(PathologicDescription.Description.PATHO_MANUAL));
                            MesswerteView.this.viewer.refresh();
                        }
                    }
                }
            }
        };
        this.pathologicAction.setText("Pathologisch");
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                MesswerteView.this.doubleClicked();
            }
        });
    }

    private void doubleClicked() {
        log.debug("doubleClicked");
        ViewerCell cell = this.focusCellManager.getFocusCell();
        Object element = cell.getElement();
        if (element instanceof LabRowValues) {
            LabRowValues labRowValues = (LabRowValues)element;
            int columnIndex = cell.getColumnIndex();
            if (columnIndex >= 2) {
                int datesIndex = columnIndex - 2;
                LabItem labItem = labRowValues.labItem;
                log.debug("index+" + datesIndex + ", item: " + labItem.getShortLabel());
                if (labItem.getTyp() == LabItemTyp.TEXT) {
                    StringBuffer sb = new StringBuffer();
                    System.getProperty("line.separator");
                    TableDate tableDate = this.tableDates[datesIndex];
                    if (tableDate != null) {
                        List<LabResult> labResults;
                        String date = tableDate.date;
                        int valueIndex = tableDate.index;
                        if (!StringTool.isNothing((Object)date) && (labResults = labRowValues.results.get(date)) != null && labResults.size() > valueIndex) {
                            LabResult labResult = labResults.get(valueIndex);
                            sb.append(labResult.getComment());
                            new DisplayTextDialog(this.getViewSite().getShell(), "Textbefund " + date, labItem.getName(), sb.toString()).open();
                        }
                    }
                }
            }
        }
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private void setPatient(Patient patient) {
        boolean changed = false;
        if (patient != null || this.actPatient != null) {
            if (patient == null || this.actPatient == null) {
                changed = true;
            } else if (!patient.getId().equals(this.actPatient.getId())) {
                changed = true;
            }
        }
        if (changed) {
            this.actPatient = patient;
            this.loadOwnLaborsFromConfig();
            this.reload();
        }
    }

    private void reload() {
        ArrayList<LabRow> newViewerRows = new ArrayList<LabRow>();
        this.availableDates = new ArrayList<TimeTool>();
        this.dateColumns = new ArrayList<DateColumn>();
        HashMap<String, DateColumn> dateColumnsLookup = new HashMap<String, DateColumn>();
        if (this.actPatient != null) {
            BaseLabGroupElement currentLabGroupElement = this.getSelectedLabGroupElement();
            List<LabItem> items = currentLabGroupElement.getLabItems();
            if (items != null) {
                this.availableDates = MesswerteView.getAvailableDatesOfGroup(this.actPatient, items);
            } else {
                items = MesswerteView.getAvailableItems(this.actPatient);
                this.availableDates = MesswerteView.getAvailableDates(this.actPatient);
            }
            for (TimeTool time : this.availableDates) {
                DateColumn dateColumn = new DateColumn(time, 1);
                this.dateColumns.add(dateColumn);
                dateColumnsLookup.put(time.toString(15), dateColumn);
            }
            Collections.sort(items, new Comparator<LabItem>(){

                @Override
                public int compare(LabItem item1, LabItem item2) {
                    String otherGroup;
                    if (item1 == null) {
                        return 1;
                    }
                    if (item2 == null) {
                        return -1;
                    }
                    String mineGroup = item1.getGroup();
                    if (!mineGroup.equals(otherGroup = item2.getGroup())) {
                        return mineGroup.compareTo(otherGroup);
                    }
                    String mine = item1.getPrio();
                    String others = item2.getPrio();
                    if (mine.matches("[0-9]+") && others.matches("[0-9]+")) {
                        Integer iMine = Integer.parseInt(mine);
                        Integer iOthers = Integer.parseInt(others);
                        return iMine.compareTo(iOthers);
                    }
                    return mine.compareTo(others);
                }
            });
            if (!items.isEmpty()) {
                HashMap<String, LabRowValues> itemsLookup = new HashMap<String, LabRowValues>();
                ArrayList<String> groupNames = new ArrayList<String>();
                boolean isFirstGroup = true;
                for (LabItem item : items) {
                    String groupName = item.getGroup();
                    if (groupName != null && !groupNames.contains(groupName)) {
                        if (isFirstGroup) {
                            isFirstGroup = false;
                        } else {
                            newViewerRows.add(new LabRowSeparator());
                        }
                        groupNames.add(groupName);
                        Group group = new Group(groupName);
                        LabRowGroup labRowGroup = new LabRowGroup(group);
                        newViewerRows.add(labRowGroup);
                    }
                    LabRowValues labRowValues = new LabRowValues(item, new HashMap<String, List<LabResult>>());
                    newViewerRows.add(labRowValues);
                    itemsLookup.put(item.getId(), labRowValues);
                }
                Query query = new Query(LabResult.class);
                query.add("PatientID", "=", this.actPatient.getId());
                List labResults = query.execute();
                if (labResults != null) {
                    for (LabResult labResult : labResults) {
                        String dateDisplay = new TimeTool(labResult.getDate()).toString(15);
                        String dateSqlColumn = new TimeTool(labResult.getDate()).toString(9);
                        LabRowValues labRowValues = (LabRowValues)itemsLookup.get(labResult.getItem().getId());
                        if (labRowValues == null) continue;
                        List<LabResult> values = labRowValues.results.get(dateSqlColumn);
                        if (values == null) {
                            values = new ArrayList<LabResult>();
                            labRowValues.results.put(dateSqlColumn, values);
                        }
                        values.add(labResult);
                        DateColumn dateColumn = (DateColumn)dateColumnsLookup.get(dateDisplay);
                        if (dateColumn != null) {
                            if (dateColumn.numberOfColumns >= values.size()) continue;
                            dateColumn.numberOfColumns = values.size();
                            continue;
                        }
                        log.error("Serious error for " + dateDisplay);
                    }
                }
            }
        }
        this.viewerRows = newViewerRows;
        this.prepareViewerPages();
        this.currentPage = this.lastPage;
        this.updateViewerPage();
        this.updateDateColumnWidths();
    }

    private void prepareViewerPages() {
        this.dateColumnsExpanded = new ArrayList<TableDate>();
        for (DateColumn dateColumn : this.dateColumns) {
            int i = 0;
            while (i < dateColumn.numberOfColumns) {
                TableDate tableDate = new TableDate(dateColumn.date, i);
                this.dateColumnsExpanded.add(tableDate);
                ++i;
            }
        }
        int numberOfDates = this.dateColumnsExpanded.size();
        this.lastPage = (numberOfDates - 1) / columnsPerPage;
    }

    private void updateViewerPage() {
        int numberOfDates = this.dateColumnsExpanded.size();
        int pageOffset = this.currentPage * columnsPerPage;
        int minColumnIndex = 0;
        int i = 0;
        while (i < this.tableDateColumns.length) {
            if (numberOfDates > 0 && i >= minColumnIndex) {
                try {
                    TableDate tableDate = null;
                    if (i + pageOffset < numberOfDates) {
                        tableDate = this.dateColumnsExpanded.get(i + pageOffset);
                        String strDate = new TimeTool(tableDate.date).toString(15);
                        this.tableDateColumns[i].getColumn().setText(strDate);
                    } else {
                        this.tableDateColumns[i].getColumn().setText("");
                    }
                    this.tableDates[i] = tableDate;
                }
                catch (IndexOutOfBoundsException e) {
                    System.out.println(e);
                }
            } else {
                this.tableDateColumns[i].getColumn().setText("");
                this.tableDates[i] = null;
            }
            ++i;
        }
        this.viewer.refresh();
        if (this.actPatient != null) {
            this.pagesLabel.setText("Seite " + (this.currentPage + 1) + "/" + (this.lastPage + 1));
        } else {
            this.pagesLabel.setText("");
        }
        this.backAction.setEnabled(this.currentPage > 0);
        this.fwdAction.setEnabled(this.currentPage < this.lastPage);
    }

    public void heartbeat() {
    }

    @Optional
    @Inject
    public void setFixLayout(MPart part, @Named(value="perspectives/fix_layout") @Named(value="perspectives/fix_layout") boolean currentState) {
        CoreUiUtil.updateFixLayout((MPart)part, (boolean)currentState);
    }

    @Inject
    void activePatient(@Optional IPatient patient) {
        CoreUiUtil.runAsyncIfActive(() -> this.setPatient((Patient)NoPoUtil.loadAsPersistentObject((Identifiable)patient)), (Object)this.viewer);
    }

    public void refresh() {
        this.activePatient(ContextServiceHolder.get().getActivePatient().orElse(null));
    }

    class AllGroupElement
    extends BaseLabGroupElement {
        @Override
        public String getLabel() {
            return MesswerteView.GROUPS_ALL;
        }

        @Override
        public List<LabItem> getLabItems() {
            return null;
        }
    }

    abstract class BaseLabGroupElement {
        BaseLabGroupElement() {
        }

        public abstract String getLabel();

        public String toString() {
            return this.getLabel();
        }

        public abstract List<LabItem> getLabItems();
    }

    class ColumnWidthSafer
    extends ControlAdapter {
        private int columnIndex;

        ColumnWidthSafer(int columnIndex) {
            this.columnIndex = columnIndex;
        }

        public void controlResized(ControlEvent e) {
            if (e.widget instanceof TableColumn) {
                TableColumn eventTableColumn = (TableColumn)e.widget;
                int width = eventTableColumn.getWidth();
                MesswerteView.this.setInitialColumnWidth(this.columnIndex, width);
            }
            MesswerteView.this.updateDateColumnWidths();
        }
    }

    class DateColumn {
        TimeTool date;
        int numberOfColumns;

        DateColumn(TimeTool date, int numberOfColumns) {
            this.date = date;
            this.numberOfColumns = numberOfColumns;
        }
    }

    class DateEditingSupport
    extends EditingSupport {
        private final CellEditor valueEditor;

        DateEditingSupport(TableViewer viewer, int datesIndex) {
            super((ColumnViewer)viewer);
            this.valueEditor = new TextCellEditor((Composite)viewer.getTable());
        }

        public CellEditor getCellEditor(Object element) {
            if (element instanceof LabRowValues) {
                log.debug("getCellEditor");
                return this.valueEditor;
            }
            log.debug("no getCellEditor for " + element.getClass().getName());
            return null;
        }

        public boolean canEdit(Object element) {
            ViewerCell cell = MesswerteView.this.focusCellManager.getFocusCell();
            int columnIndex = cell.getColumnIndex();
            if (element instanceof LabRowValues && columnIndex >= 2) {
                LabRowValues labRowValues = (LabRowValues)element;
                LabItem labItem = labRowValues.labItem;
                Labor labor = labItem.getLabor();
                log.debug("canEdit preIsOwnLabor");
                return MesswerteView.this.isOwnLabor(labor);
            }
            log.debug("canEdit false for " + element.getClass().getName());
            return false;
        }

        public Object getValue(Object element) {
            String value = "";
            ViewerCell cell = MesswerteView.this.focusCellManager.getFocusCell();
            int columnIndex = cell.getColumnIndex();
            if (element instanceof LabRowValues) {
                LabRowValues labRowValues = (LabRowValues)element;
                if (columnIndex >= 2) {
                    int datesIndex = columnIndex - 2;
                    LabItem labItem = labRowValues.labItem;
                    TableDate tableDate = MesswerteView.this.tableDates[datesIndex];
                    if (tableDate != null) {
                        List<LabResult> results;
                        String date = tableDate.date;
                        int valueIndex = tableDate.index;
                        if (!StringTool.isNothing((Object)date) && (results = labRowValues.results.get(date)) != null && results.size() > valueIndex) {
                            LabResult labResult = results.get(valueIndex);
                            if (labItem.getTyp() == LabItemTyp.TEXT) {
                                value = labResult.getComment();
                                if (StringTool.isNothing((Object)value)) {
                                    value = labResult.getResult();
                                }
                            } else {
                                value = labResult.getResult();
                            }
                        }
                    }
                }
            }
            return value;
        }

        public void setValue(Object element, Object value) {
            ViewerCell cell = MesswerteView.this.focusCellManager.getFocusCell();
            int columnIndex = cell.getColumnIndex();
            if (element instanceof LabRowValues && value instanceof String) {
                LabRowValues labRowValues = (LabRowValues)element;
                String newValue = (String)value;
                if (columnIndex >= 2) {
                    int datesIndex = columnIndex - 2;
                    LabItem labItem = labRowValues.labItem;
                    TableDate tableDate = MesswerteView.this.tableDates[datesIndex];
                    if (tableDate != null) {
                        String date = tableDate.date;
                        int valueIndex = tableDate.index;
                        if (!StringTool.isNothing((Object)date)) {
                            List<LabResult> results = labRowValues.results.get(date);
                            if (results == null) {
                                results = new ArrayList<LabResult>();
                                labRowValues.results.put(date, results);
                            }
                            if (results.size() <= valueIndex) {
                                TimeTool timeTool = new TimeTool(date);
                                LabResult labResult = labItem.getTyp() == LabItemTyp.TEXT ? new LabResult(MesswerteView.this.actPatient, timeTool, labItem, "text", newValue) : new LabResult(MesswerteView.this.actPatient, timeTool, labItem, newValue, "");
                                results.add(labResult);
                            } else {
                                LabResult labResult = results.get(valueIndex);
                                if (labItem.getTyp() == LabItemTyp.TEXT) {
                                    labResult.set("Kommentar", newValue);
                                } else {
                                    labResult.setResult(newValue);
                                }
                            }
                            MesswerteView.this.viewer.update((Object)labRowValues, null);
                        }
                    }
                }
            }
        }
    }

    class Group {
        private boolean isLabGroup = false;
        private LabGroup labGroup = null;
        private String groupName = "";

        Group(LabGroup labGroup) {
            this.labGroup = labGroup;
            this.groupName = labGroup.getName();
            this.isLabGroup = true;
        }

        Group(String groupName) {
            this.groupName = groupName;
            this.isLabGroup = false;
        }
    }

    class GroupElement
    extends BaseLabGroupElement {
        private Group group;

        public GroupElement(Group group) {
            this.group = group;
        }

        @Override
        public String getLabel() {
            return this.group.groupName;
        }

        @Override
        public List<LabItem> getLabItems() {
            ArrayList<LabItem> labItems = new ArrayList<LabItem>();
            if (this.group.isLabGroup) {
                LabGroup labGroup = this.group.labGroup;
                labItems.addAll(labGroup.getItems());
            } else {
                String groupName = this.group.groupName;
                Query query = new Query(LabItem.class);
                List groupLabItems = query.execute();
                if (groupLabItems != null) {
                    for (LabItem labItem : groupLabItems) {
                        if (!labItem.getGroup().equals(groupName)) continue;
                        labItems.add(labItem);
                    }
                }
            }
            return labItems;
        }
    }

    class LabGroupsContentProvider
    implements IStructuredContentProvider {
        LabGroupsContentProvider() {
        }

        public Object[] getElements(Object parent) {
            return MesswerteView.this.labGroupElements.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }
    }

    static interface LabRow {
    }

    class LabRowGroup
    implements LabRow {
        Group group;

        LabRowGroup(Group group) {
            this.group = group;
        }
    }

    class LabRowSeparator
    implements LabRow {
        LabRowSeparator() {
        }
    }

    class LabRowValues
    implements LabRow {
        LabItem labItem;
        HashMap<String, List<LabResult>> results;

        LabRowValues(LabItem labItem, HashMap<String, List<LabResult>> results) {
            this.labItem = labItem;
            this.results = results;
            if (this.results == null) {
                this.results = new HashMap();
            }
        }
    }

    class OwnLabsElement
    extends BaseLabGroupElement {
        @Override
        public String getLabel() {
            return MesswerteView.GROUPS_PRAXIS;
        }

        @Override
        public List<LabItem> getLabItems() {
            ArrayList<LabItem> ownLabsItems = new ArrayList<LabItem>();
            Query query = new Query(LabItem.class);
            List labItems = query.execute();
            if (labItems != null) {
                for (LabItem labItem : labItems) {
                    for (Labor ownLabor : MesswerteView.this.ownLabors) {
                        if (labItem.getLabor() == null || labItem.getLabor().getId() == null || !labItem.getLabor().getId().equals(ownLabor.getId())) continue;
                        ownLabsItems.add(labItem);
                    }
                }
            }
            return ownLabsItems;
        }
    }

    class TableDate {
        String date;
        int index;

        TableDate(TimeTool date, int index) {
            this.date = date.toString(9);
            this.index = index;
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return MesswerteView.this.viewerRows.toArray();
        }
    }

    class ViewLabelProvider
    extends ColumnLabelProvider {
        private int columnIndex;

        ViewLabelProvider(int columnIndex) {
            this.columnIndex = columnIndex;
        }

        public String getText(Object element) {
            return this.getColumnText(element, this.columnIndex);
        }

        public Font getFont(Object element) {
            return this.getFont(element, this.columnIndex);
        }

        public Color getForeground(Object element) {
            return this.getForeground(element, this.columnIndex);
        }

        public Color getBackground(Object element) {
            return null;
        }

        public String getColumnText(Object obj, int index) {
            String text = "";
            if (obj instanceof LabRowGroup) {
                if (index == 0) {
                    LabRowGroup labRowGroup = (LabRowGroup)obj;
                    text = labRowGroup.group.groupName;
                    int spaceIndex = text.indexOf(" ");
                    if (spaceIndex >= 0) {
                        text = text.substring(spaceIndex + 1);
                    }
                }
            } else if (obj instanceof LabRowValues) {
                LabRowValues row = (LabRowValues)obj;
                if (index == 0) {
                    text = row.labItem.getShortLabel();
                } else if (index == 1) {
                    if (MesswerteView.this.actPatient != null) {
                        text = MesswerteView.this.actPatient.getGeschlecht().equals(MesswerteView.FEMININ) ? row.labItem.getRefW() : row.labItem.getRefM();
                    }
                } else {
                    int datesIndex = index - 2;
                    TableDate tableDate = MesswerteView.this.tableDates[datesIndex];
                    if (tableDate != null) {
                        List<LabResult> values;
                        String date = tableDate.date;
                        int valueIndex = tableDate.index;
                        if (!StringTool.isNothing((Object)date) && (values = row.results.get(date)) != null && values.size() > valueIndex) {
                            StringBuffer sb = new StringBuffer();
                            boolean isPathologic = false;
                            LabResult labResult = values.get(valueIndex);
                            sb.append(labResult.getResult());
                            if (labResult.isFlag(1)) {
                                isPathologic = true;
                            }
                            if (isPathologic && SWT.getPlatform().equals("gtk")) {
                                sb.insert(0, "*");
                            }
                            if ((text = sb.toString()).equalsIgnoreCase("text") && labResult.getComment().length() <= 15) {
                                text = labResult.getComment();
                            }
                        }
                    }
                }
            }
            return text;
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }

        public Color getForeground(Object element, int columnIndex) {
            if (columnIndex >= 2 && element instanceof LabRowValues) {
                LabRowValues row = (LabRowValues)element;
                int datesIndex = columnIndex - 2;
                TableDate tableDate = MesswerteView.this.tableDates[datesIndex];
                if (tableDate != null) {
                    List<LabResult> values;
                    String date = tableDate.date;
                    int valueIndex = tableDate.index;
                    if (!StringTool.isNothing((Object)date) && (values = row.results.get(date)) != null && values.size() > valueIndex) {
                        boolean isPathologic = false;
                        boolean hasComment = false;
                        LabResult labResult = values.get(valueIndex);
                        if (labResult.isFlag(1)) {
                            isPathologic = true;
                        }
                        if (!StringTool.isNothing((Object)labResult.getComment())) {
                            hasComment = true;
                        }
                        if (isPathologic) {
                            return MesswerteView.this.viewer.getTable().getDisplay().getSystemColor(3);
                        }
                        if (hasComment) {
                            return MesswerteView.this.viewer.getTable().getDisplay().getSystemColor(9);
                        }
                    }
                }
            }
            return null;
        }

        public Color getBackground(Object element, int columnIndex) {
            return null;
        }

        public Font getFont(Object element, int columnIndex) {
            if (element instanceof LabRowGroup) {
                if (boldFont == null) {
                    Font defaultFont = MesswerteView.this.viewer.getTable().getFont();
                    FontData defaultFontData = defaultFont.getFontData()[0];
                    boldFont = new Font(defaultFont.getDevice(), defaultFontData.getName(), defaultFontData.getHeight(), defaultFontData.getStyle() | 1);
                }
                return boldFont;
            }
            return null;
        }
    }
}

