/*
 * Decompiled with CFR 0.152.
 */
package org.noggit;

import org.noggit.CharArr;
import org.noggit.JSONWriter;

public class JSONUtil {
    public static final char[] TRUE_CHARS = new char[]{'t', 'r', 'u', 'e'};
    public static final char[] FALSE_CHARS = new char[]{'f', 'a', 'l', 's', 'e'};
    public static final char[] NULL_CHARS = new char[]{'n', 'u', 'l', 'l'};
    public static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    public static final char VALUE_SEPARATOR = ',';
    public static final char NAME_SEPARATOR = ':';
    public static final char OBJECT_START = '{';
    public static final char OBJECT_END = '}';
    public static final char ARRAY_START = '[';
    public static final char ARRAY_END = ']';

    public static String toJSON(Object o) {
        CharArr out = new CharArr();
        new JSONWriter(out).write(o);
        return out.toString();
    }

    public static String toJSON(Object o, int indentSize) {
        CharArr out = new CharArr();
        new JSONWriter(out, indentSize).write(o);
        return out.toString();
    }

    public static void writeNumber(int number, CharArr out) {
        out.write(Integer.toString(number));
    }

    public static void writeNumber(long number, CharArr out) {
        out.write(Long.toString(number));
    }

    public static void writeNumber(float number, CharArr out) {
        out.write(Float.toString(number));
    }

    public static void writeNumber(double number, CharArr out) {
        out.write(Double.toString(number));
    }

    public static void writeString(CharArr val, CharArr out) {
        JSONUtil.writeString(val.getArray(), val.getStart(), val.getEnd(), out);
    }

    public static void writeString(char[] val, int start, int end, CharArr out) {
        out.write('\"');
        JSONUtil.writeStringPart(val, start, end, out);
        out.write('\"');
    }

    public static void writeString(String val, int start, int end, CharArr out) {
        out.write('\"');
        JSONUtil.writeStringPart(val, start, end, out);
        out.write('\"');
    }

    public static void writeString(CharSequence val, int start, int end, CharArr out) {
        out.write('\"');
        JSONUtil.writeStringPart(val, start, end, out);
        out.write('\"');
    }

    public static void writeStringPart(char[] val, int start, int end, CharArr out) {
        int i = start;
        while (i < end) {
            char ch = val[i];
            if (ch > '\u001f' && (ch * 146087937 & 0xD6A01F80) != 0) {
                out.write(ch);
            } else {
                JSONUtil.writeChar(ch, out);
            }
            ++i;
        }
    }

    public static void writeChar(char ch, CharArr out) {
        switch (ch) {
            case '\"': 
            case '\\': {
                out.write('\\');
                out.write(ch);
                break;
            }
            case '\r': {
                out.write('\\');
                out.write('r');
                break;
            }
            case '\n': {
                out.write('\\');
                out.write('n');
                break;
            }
            case '\t': {
                out.write('\\');
                out.write('t');
                break;
            }
            case '\b': {
                out.write('\\');
                out.write('b');
                break;
            }
            case '\f': {
                out.write('\\');
                out.write('f');
                break;
            }
            case '\u2028': 
            case '\u2029': {
                JSONUtil.unicodeEscape(ch, out);
                break;
            }
            default: {
                if (ch <= '\u001f') {
                    JSONUtil.unicodeEscape(ch, out);
                    break;
                }
                out.write(ch);
            }
        }
    }

    public static void writeStringPart(String chars, int start, int end, CharArr out) {
        int pos;
        int toWrite = end - start;
        char[] arr = out.getArray();
        int space = arr.length - (pos = out.getEnd());
        if (space < toWrite) {
            JSONUtil.writeStringPart((CharSequence)chars, start, end, out);
            return;
        }
        chars.getChars(start, end, arr, pos);
        int endInOut = pos + toWrite;
        out.setEnd(endInOut);
        int i = pos;
        while (i < endInOut) {
            char ch = arr[i];
            if (ch <= '\u001f' || (ch * 146087937 & 0xD6A01F80) == 0) {
                out.setEnd(i);
                JSONUtil.writeStringPart((CharSequence)chars, start + (i - pos), end, out);
                return;
            }
            ++i;
        }
    }

    public static void writeStringPart(CharSequence chars, int start, int end, CharArr out) {
        int i = start;
        while (i < end) {
            char ch = chars.charAt(i);
            if (ch > '\u001f' && (ch * 146087937 & 0xD6A01F80) != 0) {
                out.write(ch);
            } else {
                JSONUtil.writeChar(ch, out);
            }
            ++i;
        }
    }

    public static void unicodeEscape(int ch, CharArr out) {
        out.write('\\');
        out.write('u');
        out.write(HEX_CHARS[ch >>> 12]);
        out.write(HEX_CHARS[ch >>> 8 & 0xF]);
        out.write(HEX_CHARS[ch >>> 4 & 0xF]);
        out.write(HEX_CHARS[ch & 0xF]);
    }

    public static void writeNull(CharArr out) {
        out.write(NULL_CHARS);
    }

    public static void writeBoolean(boolean val, CharArr out) {
        out.write(val ? TRUE_CHARS : FALSE_CHARS);
    }
}

