/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.stream.Stream;

public class XML {
    private static final String[] chardata_escapes;
    private static final String[] attribute_escapes;

    static {
        String[] stringArray = new String[63];
        stringArray[0] = "#0;";
        stringArray[1] = "#1;";
        stringArray[2] = "#2;";
        stringArray[3] = "#3;";
        stringArray[4] = "#4;";
        stringArray[5] = "#5;";
        stringArray[6] = "#6;";
        stringArray[7] = "#7;";
        stringArray[8] = "#8;";
        stringArray[11] = "#11;";
        stringArray[12] = "#12;";
        stringArray[14] = "#14;";
        stringArray[15] = "#15;";
        stringArray[16] = "#16;";
        stringArray[17] = "#17;";
        stringArray[18] = "#18;";
        stringArray[19] = "#19;";
        stringArray[20] = "#20;";
        stringArray[21] = "#21;";
        stringArray[22] = "#22;";
        stringArray[23] = "#23;";
        stringArray[24] = "#24;";
        stringArray[25] = "#25;";
        stringArray[26] = "#26;";
        stringArray[27] = "#27;";
        stringArray[28] = "#28;";
        stringArray[29] = "#29;";
        stringArray[30] = "#30;";
        stringArray[31] = "#31;";
        stringArray[38] = "&amp;";
        stringArray[60] = "&lt;";
        stringArray[62] = "&gt;";
        chardata_escapes = stringArray;
        String[] stringArray2 = new String[61];
        stringArray2[0] = "#0;";
        stringArray2[1] = "#1;";
        stringArray2[2] = "#2;";
        stringArray2[3] = "#3;";
        stringArray2[4] = "#4;";
        stringArray2[5] = "#5;";
        stringArray2[6] = "#6;";
        stringArray2[7] = "#7;";
        stringArray2[8] = "#8;";
        stringArray2[11] = "#11;";
        stringArray2[12] = "#12;";
        stringArray2[14] = "#14;";
        stringArray2[15] = "#15;";
        stringArray2[16] = "#16;";
        stringArray2[17] = "#17;";
        stringArray2[18] = "#18;";
        stringArray2[19] = "#19;";
        stringArray2[20] = "#20;";
        stringArray2[21] = "#21;";
        stringArray2[22] = "#22;";
        stringArray2[23] = "#23;";
        stringArray2[24] = "#24;";
        stringArray2[25] = "#25;";
        stringArray2[26] = "#26;";
        stringArray2[27] = "#27;";
        stringArray2[28] = "#28;";
        stringArray2[29] = "#29;";
        stringArray2[30] = "#30;";
        stringArray2[31] = "#31;";
        stringArray2[34] = "&quot;";
        stringArray2[38] = "&amp;";
        stringArray2[60] = "&lt;";
        attribute_escapes = stringArray2;
    }

    public static void escapeCharData(String str, Writer out) throws IOException {
        XML.escape(str, out, chardata_escapes);
    }

    public static void escapeAttributeValue(String str, Writer out) throws IOException {
        XML.escape(str, out, attribute_escapes);
    }

    public static void escapeAttributeValue(char[] chars, int start, int length, Writer out) throws IOException {
        XML.escape(chars, start, length, out, attribute_escapes);
    }

    public static final void writeUnescapedXML(Writer out, String tag, String val, Object ... attrs) throws IOException {
        XML.writeXML(out, tag, (Writer writer1) -> writer1.write(val), attrs);
    }

    public static final void writeXML(Writer out, String tag, String val, Object ... attrs) throws IOException {
        Writable writable = val != null ? writer1 -> XML.escapeCharData(val, writer1) : null;
        XML.writeXML(out, tag, writable, attrs);
    }

    public static void writeXML(Writer out, String tag, String val, Map<String, String> attrs) throws IOException {
        XML.writeXML(out, tag, val, attrs.entrySet().stream().flatMap(entry -> Stream.of((String)entry.getKey(), (String)entry.getValue())).toArray());
    }

    public static final void writeXML(Writer out, String tag, Writable valWritable, Object ... attrs) throws IOException {
        out.write(60);
        out.write(tag);
        int attrsLen = attrs == null ? 0 : attrs.length;
        int i = 0;
        while (i < attrsLen) {
            out.write(32);
            out.write(attrs[i++].toString());
            out.write(61);
            out.write(34);
            XML.escapeAttributeValue(attrs[i].toString(), out);
            out.write(34);
            ++i;
        }
        if (valWritable == null) {
            out.write(47);
            out.write(62);
        } else {
            out.write(62);
            valWritable.write(out);
            out.write(60);
            out.write(47);
            out.write(tag);
            out.write(62);
        }
    }

    private static void escape(char[] chars, int offset, int length, Writer out, String[] escapes) throws IOException {
        int i = offset;
        while (i < length) {
            String replacement;
            char ch = chars[i];
            if (ch < escapes.length && (replacement = escapes[ch]) != null) {
                out.write(replacement);
            } else {
                out.write(ch);
            }
            ++i;
        }
    }

    private static void escape(String str, Writer out, String[] escapes) throws IOException {
        int i = 0;
        while (i < str.length()) {
            String replacement;
            char ch = str.charAt(i);
            if (ch < escapes.length && (replacement = escapes[ch]) != null) {
                out.write(replacement);
            } else {
                out.write(ch);
            }
            ++i;
        }
    }

    @FunctionalInterface
    public static interface Writable {
        public void write(Writer var1) throws IOException;
    }
}

