/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Template {
    public final String template;
    public static final Pattern DOLLAR_BRACES_PLACEHOLDER_PATTERN = Pattern.compile("[$][{](.*?)[}]");
    public static final Pattern BRACES_PLACEHOLDER_PATTERN = Pattern.compile("[{](.*?)[}]");
    private List<Integer> startIndexes = new ArrayList<Integer>(2);
    private List<Integer> endOffsets = new ArrayList<Integer>(2);
    public final List<String> variables;

    public Template(String template, Pattern pattern) {
        this.template = template;
        ArrayList<String> variables = new ArrayList<String>(2);
        Matcher m = pattern.matcher(template);
        while (m.find()) {
            String variable = m.group(1);
            this.startIndexes.add(m.start(0));
            this.endOffsets.add(m.end(0));
            variables.add(variable);
        }
        this.variables = Collections.unmodifiableList(variables);
    }

    public String apply(Function<String, Object> valueSupplier) {
        if (this.startIndexes != null) {
            StringBuilder sb = new StringBuilder(this.template);
            int i = this.startIndexes.size() - 1;
            while (i >= 0) {
                String replacement = valueSupplier.apply(this.variables.get(i)).toString();
                sb.replace(this.startIndexes.get(i), this.endOffsets.get(i), replacement);
                --i;
            }
            return sb.toString();
        }
        return this.template;
    }
}

