/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.io.Closeable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.apache.solr.common.util.ExecutorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectReleaseTracker {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static Map<Object, String> OBJECTS = new ConcurrentHashMap<Object, String>();

    public static boolean track(Object object) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        new ObjectTrackerException(object.getClass().getName()).printStackTrace(pw);
        OBJECTS.put(object, sw.toString());
        return true;
    }

    public static boolean release(Object object) {
        OBJECTS.remove(object);
        return true;
    }

    public static void clear() {
        OBJECTS.clear();
    }

    public static String checkEmpty() {
        String error = null;
        Set<Map.Entry<Object, String>> entries = OBJECTS.entrySet();
        if (entries.size() > 0) {
            ArrayList<String> objects = new ArrayList<String>();
            for (Map.Entry<Object, String> entry : entries) {
                objects.add(entry.getKey().getClass().getSimpleName());
            }
            error = "ObjectTracker found " + entries.size() + " object(s) that were not released!!! " + objects + "\n";
            for (Map.Entry<Object, String> entry : entries) {
                error = String.valueOf(error) + entry.getValue() + "\n";
            }
        }
        return error;
    }

    public static void tryClose() {
        Set<Map.Entry<Object, String>> entries = OBJECTS.entrySet();
        if (entries.size() > 0) {
            for (Map.Entry<Object, String> entry : entries) {
                if (entry.getKey() instanceof Closeable) {
                    try {
                        ((Closeable)entry.getKey()).close();
                    }
                    catch (Throwable t) {
                        log.error("", t);
                    }
                    continue;
                }
                if (!(entry.getKey() instanceof ExecutorService)) continue;
                try {
                    ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)entry.getKey());
                }
                catch (Throwable t) {
                    log.error("", t);
                }
            }
        }
    }

    private static class ObjectTrackerException
    extends RuntimeException {
        ObjectTrackerException(String msg) {
            super(msg);
        }
    }
}

