/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.solr.common.util.EnumValidator;
import org.apache.solr.common.util.ItemsValidator;
import org.apache.solr.common.util.OneOfValidator;
import org.apache.solr.common.util.Pair;
import org.apache.solr.common.util.PropertiesValidator;
import org.apache.solr.common.util.RequiredValidator;
import org.apache.solr.common.util.TypeValidator;
import org.apache.solr.common.util.Utils;
import org.apache.solr.common.util.Validator;

public class JsonSchemaValidator {
    private List<Validator> validators = new LinkedList<Validator>();
    private static Set<String> KNOWN_FNAMES = new HashSet<String>(Arrays.asList("description", "documentation", "default", "additionalProperties"));
    static final Map<String, Function<Pair<Map, Object>, Validator>> VALIDATORS = new HashMap<String, Function<Pair<Map, Object>, Validator>>();

    static {
        VALIDATORS.put("items", pair -> new ItemsValidator((Map)pair.first(), (Map)pair.second()));
        VALIDATORS.put("enum", pair -> new EnumValidator((Map)pair.first(), (List)pair.second()));
        VALIDATORS.put("properties", pair -> new PropertiesValidator((Map)pair.first(), (Map)pair.second()));
        VALIDATORS.put("type", pair -> new TypeValidator((Map)pair.first(), pair.second()));
        VALIDATORS.put("required", pair -> new RequiredValidator((Map)pair.first(), (List)pair.second()));
        VALIDATORS.put("oneOf", pair -> new OneOfValidator((Map)pair.first(), (List)pair.second()));
    }

    public JsonSchemaValidator(String jsonString) {
        this((Map)Utils.fromJSONString(jsonString));
    }

    public JsonSchemaValidator(Map<?, ?> jsonSchema) {
        for (Map.Entry<?, ?> entry : jsonSchema.entrySet()) {
            Object fname = entry.getKey();
            if (KNOWN_FNAMES.contains(fname.toString())) continue;
            Function<Pair<Map, Object>, Validator> initializeFunction = VALIDATORS.get(fname.toString());
            if (initializeFunction == null) {
                throw new RuntimeException("Unknown key : " + fname);
            }
            this.validators.add(initializeFunction.apply(new Pair(jsonSchema, entry.getValue())));
        }
    }

    public List<String> validateJson(Object data) {
        LinkedList<String> errs = new LinkedList<String>();
        this.validate(data, errs);
        return errs.isEmpty() ? null : errs;
    }

    boolean validate(Object data, List<String> errs) {
        if (data == null) {
            return true;
        }
        for (Validator validator : this.validators) {
            if (validator.validate(data, errs)) continue;
            return false;
        }
        return true;
    }
}

