/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.solr.common.util.Utils;
import org.noggit.JSONParser;

public class JsonRecordReader {
    public static final String DELIM = ".";
    private Node rootNode = new Node("/", null);

    public static JsonRecordReader getInst(String split, List<String> fieldMappings) {
        JsonRecordReader jsonRecordReader = new JsonRecordReader();
        jsonRecordReader.addSplit(split);
        Iterator<String> iterator = fieldMappings.iterator();
        while (iterator.hasNext()) {
            String s;
            String path = s = iterator.next();
            int idx = s.indexOf(58);
            String fieldName = null;
            if (idx > 0) {
                fieldName = s.substring(0, idx);
                path = s.substring(idx + 1);
            }
            jsonRecordReader.addField(path, fieldName, true, false);
        }
        return jsonRecordReader;
    }

    private JsonRecordReader() {
    }

    void addSplit(String splitPath) {
        String[] splits;
        String[] stringArray = splits = splitPath.split("\\|");
        int n = splits.length;
        int n2 = 0;
        while (n2 < n) {
            String split = stringArray[n2];
            if ((split = split.trim()).startsWith("//")) {
                throw new RuntimeException("split cannot start with '//': " + split);
            }
            if (split.length() != 0) {
                this.addField(split, split, false, true);
            }
            ++n2;
        }
    }

    private void addField(String path, String fieldName, boolean multiValued, boolean isRecord) {
        if (!path.startsWith("/")) {
            throw new RuntimeException("All paths must start with '/' " + path);
        }
        List<String> paths = JsonRecordReader.splitEscapeQuote(path);
        if (paths.size() == 0) {
            if (isRecord) {
                this.rootNode.setAsRecord();
            }
            return;
        }
        if ("".equals(paths.get(0).trim())) {
            paths.remove(0);
        }
        this.rootNode.build(paths, fieldName, multiValued, isRecord, path);
        this.rootNode.buildOptimize();
    }

    public List<Map<String, Object>> getAllRecords(Reader r) throws IOException {
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        this.streamRecords(r, (Map<String, Object> record, String path) -> {
            boolean bl = results.add(Utils.getDeepCopy(record, 2));
        });
        return results;
    }

    public void streamRecords(Reader r, Handler handler) throws IOException {
        this.streamRecords(new JSONParser(r), handler);
    }

    public void streamRecords(JSONParser parser, Handler handler) throws IOException {
        this.rootNode.parse(parser, handler, new LinkedHashMap<String, Object>());
    }

    private static List<String> splitEscapeQuote(String str) {
        LinkedList<String> result = new LinkedList<String>();
        String[] ss = str.split("/");
        int i = 0;
        while (i < ss.length) {
            StringBuilder sb = new StringBuilder();
            int quoteCount = 0;
            while (true) {
                sb.append(ss[i]);
                int j = 0;
                while (j < ss[i].length()) {
                    if (ss[i].charAt(j) == '\'') {
                        ++quoteCount;
                    }
                    ++j;
                }
                if (quoteCount % 2 == 0) break;
                ++i;
                sb.append("/");
            }
            result.add(sb.toString());
            ++i;
        }
        return result;
    }

    public static Object parseSingleFieldValue(int ev, JSONParser parser, MethodFrameWrapper runnable) throws IOException {
        switch (ev) {
            case 1: {
                return parser.getString();
            }
            case 2: {
                return parser.getLong();
            }
            case 3: {
                return parser.getDouble();
            }
            case 4: {
                return parser.getNumberChars().toString();
            }
            case 5: {
                return parser.getBoolean();
            }
            case 6: {
                parser.getNull();
                return null;
            }
            case 9: {
                return JsonRecordReader.parseArrayFieldValue(ev, parser, runnable);
            }
            case 7: {
                if (runnable != null) {
                    runnable.walk(7);
                    return null;
                }
                JsonRecordReader.consumeTillMatchingEnd(parser, 1, 0);
                return null;
            }
        }
        throw new RuntimeException("Error parsing JSON field value. Unexpected " + JSONParser.getEventString(ev));
    }

    public static List<Object> parseArrayFieldValue(int ev, JSONParser parser, MethodFrameWrapper runnable) throws IOException {
        assert (ev == 9);
        ArrayList<Object> lst = new ArrayList<Object>(2);
        while (true) {
            if ((ev = parser.nextEvent()) == 10) {
                if (lst.isEmpty()) {
                    return null;
                }
                return lst;
            }
            Object val = JsonRecordReader.parseSingleFieldValue(ev, parser, runnable);
            if (val == null) continue;
            lst.add(val);
        }
    }

    public static void consumeTillMatchingEnd(JSONParser parser, int obj, int arr) throws IOException {
        do {
            int event;
            if ((event = parser.nextEvent()) == 7) {
                ++obj;
            }
            if (event == 8) {
                --obj;
            }
            assert (obj >= 0);
            if (event == 9) {
                ++arr;
            }
            if (event == 10) {
                --arr;
            }
            assert (arr >= 0);
        } while (obj != 0 || arr != 0);
    }

    public static interface Handler {
        public void handle(Map<String, Object> var1, String var2);
    }

    static abstract class MethodFrameWrapper {
        Node node;
        MethodFrameWrapper parent;
        String name;

        MethodFrameWrapper() {
        }

        void addName(StringBuilder sb) {
            if (this.parent != null && !this.parent.node.isChildRecord) {
                this.parent.addName(sb);
                sb.append(JsonRecordReader.DELIM);
            }
            sb.append(this.name);
        }

        public abstract void walk(int var1) throws IOException;
    }

    private static class Node {
        String name;
        String fieldName;
        String splitPath;
        final LinkedHashMap<String, Node> childNodes = new LinkedHashMap();
        Node parent;
        boolean isLeaf = false;
        boolean isRecord = false;
        boolean isChildRecord = false;
        Node wildCardChild;
        Node recursiveWildCardChild;
        private boolean useFqn = false;
        static final String WILDCARD_PATH = "*";
        static final String RECURSIVE_WILDCARD_PATH = "**";

        public Node(String name, Node p) {
            this.name = name;
            this.parent = p;
        }

        public Node(String name, String fieldName) {
            this.name = name;
            this.fieldName = fieldName;
        }

        void setAsRecord() {
            if (this.isMyChildARecord()) {
                throw new RuntimeException(String.valueOf(this.name) + " has a parent node at my level or lower");
            }
            this.isChildRecord = this.hasParentRecord();
            this.isRecord = true;
        }

        private boolean hasParentRecord() {
            return this.isRecord || this.parent != null && this.parent.hasParentRecord();
        }

        private boolean isMyChildARecord() {
            if (this.isRecord) {
                return true;
            }
            for (Node node : this.childNodes.values()) {
                if (!node.isMyChildARecord()) continue;
                return true;
            }
            return false;
        }

        private void buildOptimize() {
            if (this.parent != null && this.parent.recursiveWildCardChild != null && this.recursiveWildCardChild == null) {
                this.recursiveWildCardChild = this.parent.recursiveWildCardChild;
            }
            for (Node n : this.childNodes.values()) {
                n.buildOptimize();
            }
        }

        private void build(List<String> paths, String fieldName, boolean multiValued, boolean record, String path) {
            String segment = paths.remove(0);
            if (segment.length() < 1) {
                throw new RuntimeException("all pieces in path must be non empty " + path);
            }
            Node n = this.getOrAddNode(segment, this.childNodes);
            if (paths.isEmpty()) {
                if (record) {
                    assert (!WILDCARD_PATH.equals(n.name));
                    assert (!RECURSIVE_WILDCARD_PATH.equals(n.name));
                    n.setAsRecord();
                    n.splitPath = fieldName;
                } else {
                    if (n.name.equals(WILDCARD_PATH)) {
                        this.wildCardChild = n;
                    }
                    if (n.name.equals(RECURSIVE_WILDCARD_PATH)) {
                        this.recursiveWildCardChild = n.recursiveWildCardChild = n;
                    }
                    n.isLeaf = true;
                    n.fieldName = fieldName;
                    if ("$FQN".equals(n.fieldName)) {
                        n.fieldName = null;
                        n.useFqn = true;
                    }
                }
            } else {
                if (WILDCARD_PATH.equals(this.name) || RECURSIVE_WILDCARD_PATH.equals(this.name)) {
                    throw new RuntimeException("wild cards are allowed only in the end " + path);
                }
                n.build(paths, fieldName, multiValued, record, path);
            }
        }

        private Node getOrAddNode(String pathName, Map<String, Node> children) {
            Node n = children.get(pathName);
            if (n != null) {
                return n;
            }
            n = new Node(pathName, this);
            children.put(pathName, n);
            return n;
        }

        private void parse(JSONParser parser, Handler handler, Map<String, Object> values) throws IOException {
            int event = -1;
            boolean recordStarted = false;
            while ((event = parser.nextEvent()) != 11) {
                if (event == 7) {
                    this.handleObjectStart(parser, handler, new LinkedHashMap<String, Object>(), new Stack<Set<String>>(), recordStarted, null);
                    continue;
                }
                if (event != 9) continue;
                while ((event = parser.nextEvent()) != 10) {
                    if (event != 7) continue;
                    this.handleObjectStart(parser, handler, new LinkedHashMap<String, Object>(), new Stack<Set<String>>(), recordStarted, null);
                }
            }
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void handleObjectStart(JSONParser parser, Handler handler, Map<String, Object> values, Stack<Set<String>> stack, boolean recordStarted, MethodFrameWrapper frameWrapper) throws IOException {
            block19: {
                isRecordStarted = recordStarted != false || this.isRecord != false;
                valuesAddedinThisFrame = null;
                if (this.isRecord || !recordStarted) {
                    valuesAddedinThisFrame = new HashSet<E>();
                    stack.push(valuesAddedinThisFrame);
                } else if (recordStarted) {
                    valuesAddedinThisFrame = stack.peek();
                }
                try {
                    while (true) {
                        if ((event = parser.nextEvent()) == 8) {
                            if (this.isRecord()) {
                                handler.handle(values, this.splitPath);
                            }
                        }
                        if (!Node.$assertionsDisabled && event != 1) {
                            throw new AssertionError();
                        }
                        if (!Node.$assertionsDisabled && !parser.wasKey()) {
                            throw new AssertionError();
                        }
                        name = parser.getString();
                        node = this.childNodes.get(name);
                        if (node == null) {
                            node = this.wildCardChild;
                        }
                        if (node == null) {
                            node = this.recursiveWildCardChild;
                        }
                        if (node != null) {
                            if (node.isLeaf) {
                                event = parser.nextEvent();
                                nameInRecord = node.fieldName == null ? this.getNameInRecord(name, frameWrapper, node) : node.fieldName;
                                runnable = null;
                                if ((event == 7 || event == 9) && node.recursiveWildCardChild != null) {
                                    runnable = new 1Wrapper(node, frameWrapper, name, parser, values, handler, stack, isRecordStarted);
                                }
                                if ((val = JsonRecordReader.parseSingleFieldValue(event, parser, runnable)) == null) continue;
                                this.putValue(values, nameInRecord, val);
                                valuesAddedinThisFrame.add(nameInRecord);
                                continue;
                            }
                            event = parser.nextEvent();
                            new 1Wrapper(node, frameWrapper, name, parser, values, handler, stack, isRecordStarted).walk(event);
                            continue;
                        }
                        event = parser.nextEvent();
                        if (event == 1 || event == 2 || event == 3 || event == 4 || event == 5 || event == 6) continue;
                        if (event == 9) {
                            JsonRecordReader.consumeTillMatchingEnd(parser, 0, 1);
                            continue;
                        }
                        if (event != 7) break;
                        JsonRecordReader.consumeTillMatchingEnd(parser, 1, 0);
                    }
                    throw new RuntimeException("unexpected token " + event);
                }
                finally {
                    if (!this.isRecord() && isRecordStarted) break block19;
                    ** for (fld : valuesAddedinThisFrame)
                }
lbl-1000:
                // 1 sources

                {
                    values.remove(fld);
                    continue;
                }
            }
        }

        private void addChildDoc2ParentDoc(Map<String, Object> record, Map<String, Object> values, String key) {
            record = Utils.getDeepCopy(record, 2);
            Object oldVal = values.get(key);
            if (oldVal == null) {
                values.put(key, record);
            } else if (oldVal instanceof List) {
                ((List)oldVal).add(record);
            } else {
                ArrayList<Object> l = new ArrayList<Object>();
                l.add(oldVal);
                l.add(record);
                values.put(key, l);
            }
        }

        private String getNameInRecord(String name, MethodFrameWrapper frameWrapper, Node n) {
            if (frameWrapper == null || !n.useFqn || frameWrapper.node.isChildRecord) {
                return name;
            }
            StringBuilder sb = new StringBuilder();
            frameWrapper.addName(sb);
            return sb.append(JsonRecordReader.DELIM).append(name).toString();
        }

        private boolean isRecord() {
            return this.isRecord;
        }

        private void putValue(Map<String, Object> values, String fieldName, Object o) {
            if (o == null) {
                return;
            }
            Object val = values.get(fieldName);
            if (val == null) {
                values.put(fieldName, o);
                return;
            }
            if (val instanceof List) {
                List list = (List)val;
                list.add(o);
                return;
            }
            ArrayList<Object> l = new ArrayList<Object>();
            l.add(val);
            l.add(o);
            values.put(fieldName, l);
        }

        private String getPathSuffix(String path) {
            int indexOf = path.lastIndexOf("/");
            if (indexOf == -1) {
                return path;
            }
            return path.substring(indexOf + 1);
        }

        public String toString() {
            return this.name;
        }
    }
}

