/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.solr.common.util.SolrNamedThreadFactory;
import org.apache.solr.common.util.SuppressForbidden;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class ExecutorUtil {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static volatile List<InheritableThreadLocalProvider> providers = new ArrayList<InheritableThreadLocalProvider>();
    private static final ThreadLocal<Boolean> isServerPool = new ThreadLocal();

    public static synchronized void addThreadLocalProvider(InheritableThreadLocalProvider provider) {
        for (InheritableThreadLocalProvider p : providers) {
            if (!p.getClass().equals(provider.getClass())) continue;
            return;
        }
        ArrayList<InheritableThreadLocalProvider> copy = new ArrayList<InheritableThreadLocalProvider>(providers);
        copy.add(provider);
        providers = copy;
    }

    public static void shutdownAndAwaitTermination(ExecutorService pool) {
        if (pool == null) {
            return;
        }
        pool.shutdown();
        ExecutorUtil.awaitTermination(pool);
    }

    public static void shutdownNowAndAwaitTermination(ExecutorService pool) {
        if (pool == null) {
            return;
        }
        pool.shutdownNow();
        ExecutorUtil.awaitTermination(pool);
    }

    public static void awaitTermination(ExecutorService pool) {
        boolean shutdown = false;
        while (!shutdown) {
            try {
                shutdown = pool.awaitTermination(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static ExecutorService newMDCAwareFixedThreadPool(int nThreads, ThreadFactory threadFactory) {
        return new MDCAwareThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
    }

    public static ExecutorService newMDCAwareSingleThreadExecutor(ThreadFactory threadFactory) {
        return new MDCAwareThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
    }

    public static ExecutorService newMDCAwareCachedThreadPool(String name) {
        return ExecutorUtil.newMDCAwareCachedThreadPool(new SolrNamedThreadFactory(name));
    }

    public static ExecutorService newMDCAwareCachedThreadPool(ThreadFactory threadFactory) {
        return new MDCAwareThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory);
    }

    public static ExecutorService newMDCAwareCachedThreadPool(int maxThreads, ThreadFactory threadFactory) {
        return new MDCAwareThreadPoolExecutor(0, maxThreads, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(maxThreads), threadFactory);
    }

    public static boolean isSolrServerThread() {
        return Boolean.TRUE.equals(isServerPool.get());
    }

    public static void setServerThreadFlag(Boolean flag) {
        if (flag == null) {
            isServerPool.remove();
        } else {
            isServerPool.set(flag);
        }
    }

    public static interface InheritableThreadLocalProvider {
        public void store(AtomicReference<?> var1);

        public void set(AtomicReference<?> var1);

        public void clean(AtomicReference<?> var1);
    }

    @SuppressForbidden(reason="class customizes ThreadPoolExecutor so it can be used instead")
    public static class MDCAwareThreadPoolExecutor
    extends ThreadPoolExecutor {
        private static final int MAX_THREAD_NAME_LEN = 512;
        private final boolean enableSubmitterStackTrace;

        public MDCAwareThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
            this.enableSubmitterStackTrace = true;
        }

        public MDCAwareThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
            this.enableSubmitterStackTrace = true;
        }

        public MDCAwareThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
            this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, true);
        }

        public MDCAwareThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, boolean enableSubmitterStackTrace) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
            this.enableSubmitterStackTrace = enableSubmitterStackTrace;
        }

        public MDCAwareThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, handler);
            this.enableSubmitterStackTrace = true;
        }

        @Override
        public void execute(Runnable command) {
            ArrayList ctx;
            String ctxStr;
            Map submitterContext = MDC.getCopyOfContextMap();
            StringBuilder contextString = new StringBuilder();
            if (submitterContext != null) {
                Collection values = submitterContext.values();
                for (String value : values) {
                    contextString.append(value).append(' ');
                }
                if (contextString.length() > 1) {
                    contextString.setLength(contextString.length() - 1);
                }
            }
            String submitterContextStr = (ctxStr = contextString.toString().replace("/", "//")).length() <= 512 ? ctxStr : ctxStr.substring(0, 512);
            Exception submitterStackTrace = this.enableSubmitterStackTrace ? new Exception("Submitter stack trace") : null;
            List<InheritableThreadLocalProvider> providersCopy = providers;
            ArrayList arrayList = ctx = providersCopy.isEmpty() ? null : new ArrayList(providersCopy.size());
            if (ctx != null) {
                int i = 0;
                while (i < providers.size()) {
                    AtomicReference reference = new AtomicReference();
                    ctx.add(reference);
                    providersCopy.get(i).store(reference);
                    ++i;
                }
            }
            super.execute(() -> this.lambda$0(ctx, providersCopy, submitterContext, submitterContextStr, command, submitterStackTrace));
        }

        /*
         * Unable to fully structure code
         */
        private /* synthetic */ void lambda$0(ArrayList var1_1, List var2_2, Map var3_3, String var4_4, Runnable var5_5, Exception var6_6) {
            block15: {
                ExecutorUtil.isServerPool.set(Boolean.TRUE);
                if (var1_1 != null) {
                    i = 0;
                    while (i < var2_2.size()) {
                        ((InheritableThreadLocalProvider)var2_2.get(i)).set((AtomicReference)var1_1.get(i));
                        ++i;
                    }
                }
                threadContext = MDC.getCopyOfContextMap();
                currentThread = Thread.currentThread();
                oldName = currentThread.getName();
                if (var3_3 != null && !var3_3.isEmpty()) {
                    MDC.setContextMap((Map)var3_3);
                    currentThread.setName(String.valueOf(oldName) + "-processing-" + var4_4);
                } else {
                    MDC.clear();
                }
                try {
                    try {
                        var5_5.run();
                    }
                    catch (Throwable t) {
                        if (t instanceof OutOfMemoryError) {
                            throw t;
                        }
                        if (this.enableSubmitterStackTrace) {
                            ExecutorUtil.log.error("Uncaught exception {} thrown by thread: {}", new Object[]{t, currentThread.getName(), var6_6});
                        } else {
                            ExecutorUtil.log.error("Uncaught exception {} thrown by thread: {}", (Object)t, (Object)currentThread.getName());
                        }
                        throw t;
                    }
                }
                finally {
                    ExecutorUtil.isServerPool.remove();
                    if (threadContext != null && !threadContext.isEmpty()) {
                        MDC.setContextMap((Map)threadContext);
                    } else {
                        MDC.clear();
                    }
                    if (var1_1 == null) break block15;
                    i = 0;
                    ** while (i < var2_2.size())
                }
lbl-1000:
                // 1 sources

                {
                    ((InheritableThreadLocalProvider)var2_2.get(i)).clean((AtomicReference)var1_1.get(i));
                    ++i;
                    continue;
                }
            }
            currentThread.setName(oldName);
        }
    }
}

