/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.solr.common.ConfigNode;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.PropertiesUtil;
import org.apache.solr.common.util.StrUtils;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMUtil {
    public static final String XML_RESERVED_PREFIX = "xml";
    public static final Set<String> NL_TAGS = new HashSet<String>(Arrays.asList("str", "int", "long", "float", "double", "bool", "null"));

    public static Map<String, String> toMap(NamedNodeMap attrs) {
        return DOMUtil.toMapExcept(attrs, new String[0]);
    }

    public static Map<String, String> toMap(ConfigNode node) {
        return DOMUtil.toMapExcept(node, new String[0]);
    }

    public static Map<String, String> toMapExcept(ConfigNode node, String ... exclusions) {
        HashMap<String, String> args = new HashMap<String, String>();
        node.attributes().forEachEntry((k, v) -> {
            String[] stringArray2 = exclusions;
            int n = exclusions.length;
            int n2 = 0;
            while (n2 < n) {
                String ex = stringArray2[n2];
                if (ex.equals(k)) {
                    return;
                }
                ++n2;
            }
            args.put((String)k, (String)v);
        });
        return args;
    }

    public static Map<String, String> toMapExcept(NamedNodeMap attrs, String ... exclusions) {
        HashMap<String, String> args = new HashMap<String, String>();
        int j = 0;
        while (j < attrs.getLength()) {
            block4: {
                Node attr = attrs.item(j);
                if (!XML_RESERVED_PREFIX.equals(attr.getPrefix())) {
                    String attrName = attr.getNodeName();
                    String[] stringArray = exclusions;
                    int n = exclusions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String ex = stringArray[n2];
                        if (!ex.equals(attrName)) {
                            ++n2;
                            continue;
                        }
                        break block4;
                    }
                    String val = attr.getNodeValue();
                    args.put(attrName, val);
                }
            }
            ++j;
        }
        return args;
    }

    public static Node getChild(Node node, String name) {
        if (!node.hasChildNodes()) {
            return null;
        }
        NodeList lst = node.getChildNodes();
        if (lst == null) {
            return null;
        }
        int i = 0;
        while (i < lst.getLength()) {
            Node child = lst.item(i);
            if (name.equals(child.getNodeName())) {
                return child;
            }
            ++i;
        }
        return null;
    }

    public static String getAttr(NamedNodeMap attrs, String name) {
        return DOMUtil.getAttr(attrs, name, null);
    }

    public static String getAttr(Node nd, String name) {
        return DOMUtil.getAttr(nd.getAttributes(), name);
    }

    public static String getAttrOrDefault(Node nd, String name, String def) {
        String attr = DOMUtil.getAttr(nd.getAttributes(), name);
        return attr == null ? def : attr;
    }

    public static String getAttr(NamedNodeMap attrs, String name, String missing_err) {
        Node attr;
        Node node = attr = attrs == null ? null : attrs.getNamedItem(name);
        if (attr == null) {
            if (missing_err == null) {
                return null;
            }
            throw new RuntimeException(String.valueOf(missing_err) + ": missing mandatory attribute '" + name + "'");
        }
        String val = attr.getNodeValue();
        return val;
    }

    public static String getAttr(ConfigNode node, String name, String missing_err) {
        String attr = node.attributes().get(name);
        if (attr == null) {
            if (missing_err == null) {
                return null;
            }
            throw new RuntimeException(String.valueOf(missing_err) + ": missing mandatory attribute '" + name + "'");
        }
        return attr;
    }

    public static String getAttr(Node node, String name, String missing_err) {
        return DOMUtil.getAttr(node.getAttributes(), name, missing_err);
    }

    public static NamedList<Object> childNodesToNamedList(Node nd) {
        return DOMUtil.nodesToNamedList(nd.getChildNodes());
    }

    public static List childNodesToList(Node nd) {
        return DOMUtil.nodesToList(nd.getChildNodes());
    }

    public static NamedList<Object> childNodesToNamedList(ConfigNode node) {
        return DOMUtil.readNamedListChildren(node);
    }

    public static NamedList<Object> nodesToNamedList(NodeList nlst) {
        NamedList<Object> clst = new NamedList<Object>();
        int i = 0;
        while (i < nlst.getLength()) {
            DOMUtil.addToNamedList(nlst.item(i), clst, null);
            ++i;
        }
        return clst;
    }

    public static List nodesToList(NodeList nlst) {
        ArrayList lst = new ArrayList();
        int i = 0;
        while (i < nlst.getLength()) {
            DOMUtil.addToNamedList(nlst.item(i), null, lst);
            ++i;
        }
        return lst;
    }

    public static void addToNamedList(Node nd, NamedList nlst, List arr) {
        if (nd.getNodeType() != 1) {
            return;
        }
        String type = nd.getNodeName();
        String name = DOMUtil.getAttr(nd, "name");
        Object val = null;
        if ("lst".equals(type)) {
            val = DOMUtil.childNodesToNamedList(nd);
        } else if ("arr".equals(type)) {
            val = DOMUtil.childNodesToList(nd);
        } else {
            String textValue = DOMUtil.getText(nd);
            val = DOMUtil.parseVal(type, name, textValue);
        }
        if (nlst != null) {
            nlst.add(name, val);
        }
        if (arr != null) {
            arr.add(val);
        }
    }

    private static Object parseVal(String type, String name, String textValue) {
        Object val = null;
        try {
            if ("str".equals(type)) {
                val = textValue;
            } else if ("int".equals(type)) {
                val = Integer.valueOf(textValue);
            } else if ("long".equals(type)) {
                val = Long.valueOf(textValue);
            } else if ("float".equals(type)) {
                val = Float.valueOf(textValue);
            } else if ("double".equals(type)) {
                val = Double.valueOf(textValue);
            } else if ("bool".equals(type)) {
                val = StrUtils.parseBool(textValue);
            } else if ("null".equals(type)) {
                val = null;
            }
        }
        catch (NumberFormatException nfe) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Value " + (name != null ? "of '" + name + "' " : "") + "can not be parsed as '" + type + "': \"" + textValue + "\"", (Throwable)nfe);
        }
        return val;
    }

    public static NamedList<Object> readNamedListChildren(ConfigNode configNode) {
        NamedList<Object> result = new NamedList<Object>();
        configNode.forEachChild(it -> {
            String tag = it.name();
            String varName = it.attributes().get("name");
            if (NL_TAGS.contains(tag)) {
                result.add(varName, DOMUtil.parseVal(tag, varName, it.txt()));
            }
            if ("lst".equals(tag)) {
                result.add(varName, DOMUtil.readNamedListChildren(it));
            } else if ("arr".equals(tag)) {
                ArrayList l = new ArrayList();
                result.add(varName, l);
                it.forEachChild(n -> {
                    if (NL_TAGS.contains(n.name())) {
                        l.add(DOMUtil.parseVal(n.name(), null, n.txt()));
                    } else if ("lst".equals(n.name())) {
                        l.add(DOMUtil.readNamedListChildren(n));
                    }
                    return Boolean.TRUE;
                });
            }
            return Boolean.TRUE;
        });
        return result;
    }

    public static String getText(Node nd) {
        short type = nd.getNodeType();
        switch (type) {
            case 9: 
            case 10: 
            case 12: {
                return null;
            }
        }
        StringBuilder sb = new StringBuilder();
        DOMUtil.getText(nd, sb);
        return sb.toString();
    }

    private static void getText(Node nd, StringBuilder buf) {
        short type = nd.getNodeType();
        switch (type) {
            case 1: 
            case 5: 
            case 6: 
            case 11: {
                NodeList childs = nd.getChildNodes();
                int i = 0;
                while (i < childs.getLength()) {
                    Node child = childs.item(i);
                    short childType = child.getNodeType();
                    if (childType != 8 && childType != 7) {
                        DOMUtil.getText(child, buf);
                    }
                    ++i;
                }
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                buf.append(nd.getNodeValue());
            }
        }
    }

    public static void substituteSystemProperties(Node node) {
        DOMUtil.substituteProperties(node, null);
    }

    public static void substituteProperties(Node node, Properties properties) {
        Node child;
        Node next = node.getFirstChild();
        while ((child = next) != null) {
            next = child.getNextSibling();
            if (child.getNodeType() == 3) {
                child.setNodeValue(PropertiesUtil.substituteProperty(child.getNodeValue(), properties));
                continue;
            }
            if (child.getNodeType() != 1) continue;
            NamedNodeMap attributes = child.getAttributes();
            int i = 0;
            while (i < attributes.getLength()) {
                Node attribute = attributes.item(i);
                attribute.setNodeValue(PropertiesUtil.substituteProperty(attribute.getNodeValue(), properties));
                ++i;
            }
            DOMUtil.substituteProperties(child, properties);
        }
    }

    public static String substituteProperty(String value, Properties coreProperties) {
        if (value == null || value.indexOf(36) == -1) {
            return value;
        }
        ArrayList<String> fragments = new ArrayList<String>();
        ArrayList<String> propertyRefs = new ArrayList<String>();
        DOMUtil.parsePropertyString(value, fragments, propertyRefs);
        StringBuilder sb = new StringBuilder();
        Iterator i = fragments.iterator();
        Iterator j = propertyRefs.iterator();
        while (i.hasNext()) {
            String fragment = (String)i.next();
            if (fragment == null) {
                String propertyName = (String)j.next();
                String defaultValue = null;
                int colon_index = propertyName.indexOf(58);
                if (colon_index > -1) {
                    defaultValue = propertyName.substring(colon_index + 1);
                    propertyName = propertyName.substring(0, colon_index);
                }
                if (coreProperties != null) {
                    fragment = coreProperties.getProperty(propertyName);
                }
                if (fragment == null) {
                    fragment = System.getProperty(propertyName, defaultValue);
                }
                if (fragment == null) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "No system property or default value specified for " + propertyName + " value:" + value);
                }
            }
            sb.append(fragment);
        }
        return sb.toString();
    }

    private static void parsePropertyString(String value, List<String> fragments, List<String> propertyRefs) {
        int pos;
        int prev = 0;
        while ((pos = value.indexOf("$", prev)) >= 0) {
            if (pos > 0) {
                fragments.add(value.substring(prev, pos));
            }
            if (pos == value.length() - 1) {
                fragments.add("$");
                prev = pos + 1;
                continue;
            }
            if (value.charAt(pos + 1) != '{') {
                if (value.charAt(pos + 1) == '$') {
                    fragments.add("$");
                    prev = pos + 2;
                    continue;
                }
                fragments.add(value.substring(pos, pos + 2));
                prev = pos + 2;
                continue;
            }
            int endName = value.indexOf(125, pos);
            if (endName < 0) {
                throw new RuntimeException("Syntax error in property: " + value);
            }
            String propertyName = value.substring(pos + 2, endName);
            fragments.add(null);
            propertyRefs.add(propertyName);
            prev = endName + 1;
        }
        if (prev < value.length()) {
            fragments.add(value.substring(prev));
        }
    }
}

