/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.io.IOException;
import java.io.OutputStream;
import org.noggit.CharArr;

public class ByteUtils {
    public static final int MAX_UTF8_BYTES_PER_CHAR = 3;

    public static int UTF8toUTF16(byte[] utf8, int offset, int len, char[] out, int out_offset) {
        int out_start = out_offset;
        int limit = offset + len;
        while (offset < limit) {
            int b;
            if ((b = utf8[offset++] & 0xFF) < 192) {
                assert (b < 128);
                out[out_offset++] = (char)b;
                continue;
            }
            if (b < 224) {
                out[out_offset++] = (char)(((b & 0x1F) << 6) + (utf8[offset++] & 0x3F));
                continue;
            }
            if (b < 240) {
                out[out_offset++] = (char)(((b & 0xF) << 12) + ((utf8[offset] & 0x3F) << 6) + (utf8[offset + 1] & 0x3F));
                offset += 2;
                continue;
            }
            assert (b < 248);
            int ch = ((b & 7) << 18) + ((utf8[offset] & 0x3F) << 12) + ((utf8[offset + 1] & 0x3F) << 6) + (utf8[offset + 2] & 0x3F);
            offset += 3;
            if (ch < 65535) {
                out[out_offset++] = (char)ch;
                continue;
            }
            int chHalf = ch - 65536;
            out[out_offset++] = (char)((chHalf >> 10) + 55296);
            out[out_offset++] = (char)(((long)chHalf & 0x3FFL) + 56320L);
        }
        return out_offset - out_start;
    }

    public static void UTF8toUTF16(byte[] utf8, int offset, int len, CharArr out) {
        out.reserve(len);
        int n = ByteUtils.UTF8toUTF16(utf8, offset, len, out.getArray(), out.getEnd());
        out.setEnd(out.getEnd() + n);
    }

    public static String UTF8toUTF16(byte[] utf8, int offset, int len) {
        char[] out = new char[len];
        int n = ByteUtils.UTF8toUTF16(utf8, offset, len, out, 0);
        return new String(out, 0, n);
    }

    public static int UTF16toUTF8(CharSequence s, int offset, int len, byte[] result, int resultOffset) {
        int end = offset + len;
        int upto = resultOffset;
        int i = offset;
        while (i < end) {
            int utf32;
            char code = s.charAt(i);
            if (code < '\u0080') {
                result[upto++] = (byte)code;
            } else if (code < '\u0800') {
                result[upto++] = (byte)(0xC0 | code >> 6);
                result[upto++] = (byte)(0x80 | code & 0x3F);
            } else if (code < '\ud800' || code > '\udfff') {
                result[upto++] = (byte)(0xE0 | code >> 12);
                result[upto++] = (byte)(0x80 | code >> 6 & 0x3F);
                result[upto++] = (byte)(0x80 | code & 0x3F);
            } else if (code < '\udc00' && i < end - 1 && (utf32 = s.charAt(i + 1)) >= 56320 && utf32 <= 57343) {
                utf32 = (code - 55232 << 10) + (utf32 & 0x3FF);
                ++i;
                result[upto++] = (byte)(0xF0 | utf32 >> 18);
                result[upto++] = (byte)(0x80 | utf32 >> 12 & 0x3F);
                result[upto++] = (byte)(0x80 | utf32 >> 6 & 0x3F);
                result[upto++] = (byte)(0x80 | utf32 & 0x3F);
            } else {
                result[upto++] = -17;
                result[upto++] = -65;
                result[upto++] = -67;
            }
            ++i;
        }
        return upto - resultOffset;
    }

    public static int writeUTF16toUTF8(CharSequence s, int offset, int len, OutputStream fos, byte[] scratch) throws IOException {
        int end = offset + len;
        int upto = 0;
        int totalBytes = 0;
        int i = offset;
        while (i < end) {
            int utf32;
            char code = s.charAt(i);
            if (upto > scratch.length - 4) {
                totalBytes += upto;
                if (fos == null) {
                    throw new IOException("buffer over flow");
                }
                fos.write(scratch, 0, upto);
                upto = 0;
            }
            if (code < '\u0080') {
                scratch[upto++] = (byte)code;
            } else if (code < '\u0800') {
                scratch[upto++] = (byte)(0xC0 | code >> 6);
                scratch[upto++] = (byte)(0x80 | code & 0x3F);
            } else if (code < '\ud800' || code > '\udfff') {
                scratch[upto++] = (byte)(0xE0 | code >> 12);
                scratch[upto++] = (byte)(0x80 | code >> 6 & 0x3F);
                scratch[upto++] = (byte)(0x80 | code & 0x3F);
            } else if (code < '\udc00' && i < end - 1 && (utf32 = s.charAt(i + 1)) >= 56320 && utf32 <= 57343) {
                utf32 = (code - 55232 << 10) + (utf32 & 0x3FF);
                ++i;
                scratch[upto++] = (byte)(0xF0 | utf32 >> 18);
                scratch[upto++] = (byte)(0x80 | utf32 >> 12 & 0x3F);
                scratch[upto++] = (byte)(0x80 | utf32 >> 6 & 0x3F);
                scratch[upto++] = (byte)(0x80 | utf32 & 0x3F);
            } else {
                scratch[upto++] = -17;
                scratch[upto++] = -65;
                scratch[upto++] = -67;
            }
            ++i;
        }
        totalBytes += upto;
        if (fos != null) {
            fos.write(scratch, 0, upto);
        }
        return totalBytes;
    }

    public static int calcUTF16toUTF8Length(CharSequence s, int offset, int len) {
        int end = offset + len;
        int res = 0;
        int i = offset;
        while (i < end) {
            char utf32;
            char code = s.charAt(i);
            if (code < '\u0080') {
                ++res;
            } else if (code < '\u0800') {
                res += 2;
            } else if (code < '\ud800' || code > '\udfff') {
                res += 3;
            } else if (code < '\udc00' && i < end - 1 && (utf32 = s.charAt(i + 1)) >= '\udc00' && utf32 <= '\udfff') {
                ++i;
                res += 4;
            } else {
                res += 3;
            }
            ++i;
        }
        return res;
    }
}

