/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud.rule;

import java.lang.invoke.MethodHandles;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.rule.Snitch;
import org.apache.solr.common.cloud.rule.SnitchContext;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImplicitSnitch
extends Snitch {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final Pattern hostAndPortPattern = Pattern.compile("(?:https?://)?([^:]+):(\\d+)");
    public static final String NODE = "node";
    public static final String PORT = "port";
    public static final String HOST = "host";
    public static final String CORES = "cores";
    public static final String DISK = "freedisk";
    public static final String ROLE = "role";
    public static final String NODEROLE = "nodeRole";
    public static final String SYSPROP = "sysprop.";
    public static final String SYSLOADAVG = "sysLoadAvg";
    public static final String HEAPUSAGE = "heapUsage";
    public static final String DISKTYPE = "diskType";
    public static final List<String> IP_SNITCHES = Collections.unmodifiableList(Arrays.asList("ip_1", "ip_2", "ip_3", "ip_4"));
    public static final Set<String> tags = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("node", "port", "host", "cores", "freedisk", "role", "ip_1", "ip_2", "ip_3", "ip_4")));
    private static final String HOST_FRAG_SEPARATOR_REGEX = "\\.";

    @Override
    public void getTags(String solrNode, Set<String> requestedTags, SnitchContext ctx) {
        try {
            Matcher hostAndPortMatcher;
            if (requestedTags.contains(NODE)) {
                ctx.getTags().put(NODE, solrNode);
            }
            if (requestedTags.contains(HOST) && (hostAndPortMatcher = hostAndPortPattern.matcher(solrNode)).find()) {
                ctx.getTags().put(HOST, hostAndPortMatcher.group(1));
            }
            if (requestedTags.contains(PORT) && (hostAndPortMatcher = hostAndPortPattern.matcher(solrNode)).find()) {
                ctx.getTags().put(PORT, hostAndPortMatcher.group(2));
            }
            if (requestedTags.contains(ROLE)) {
                this.fillRole(solrNode, ctx, ROLE);
            }
            if (requestedTags.contains(NODEROLE)) {
                this.fillRole(solrNode, ctx, NODEROLE);
            }
            this.addIpTags(solrNode, requestedTags, ctx);
            this.getRemoteInfo(solrNode, requestedTags, ctx);
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    protected void getRemoteInfo(String solrNode, Set<String> requestedTags, SnitchContext ctx) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (requestedTags.contains(CORES)) {
            params.put(CORES, "1");
        }
        if (requestedTags.contains(DISK)) {
            params.put(DISK, "1");
        }
        for (String tag : requestedTags) {
            if (!tag.startsWith(SYSPROP)) continue;
            params.put(tag, tag.substring(SYSPROP.length()));
        }
        if (params.size() > 0) {
            Map<String, Object> vals = ctx.getNodeValues(solrNode, params.keySet());
            for (Map.Entry<String, Object> e : vals.entrySet()) {
                if (e.getValue() == null) continue;
                params.put(e.getKey(), e.getValue());
            }
        }
        ctx.getTags().putAll(params);
    }

    private void fillRole(String solrNode, SnitchContext ctx, String key) throws KeeperException, InterruptedException {
        Map roles = (Map)ctx.retrieve("/roles.json");
        try {
            if (roles == null) {
                roles = ctx.getZkJson("/roles.json");
            }
            this.cacheRoles(solrNode, ctx, key, roles);
        }
        catch (KeeperException.NoNodeException e) {
            this.cacheRoles(solrNode, ctx, key, Collections.emptyMap());
        }
    }

    private void cacheRoles(String solrNode, SnitchContext ctx, String key, Map roles) {
        ctx.store("/roles.json", roles);
        if (roles != null) {
            for (Map.Entry o : roles.entrySet()) {
                Map.Entry e = o;
                if (!(e.getValue() instanceof List) || !((List)e.getValue()).contains(solrNode)) continue;
                ctx.getTags().put(key, e.getKey());
                break;
            }
        }
    }

    @Override
    public boolean isKnownTag(String tag) {
        return tags.contains(tag) || tag.startsWith(SYSPROP);
    }

    private void addIpTags(String solrNode, Set<String> requestedTags, SnitchContext context) {
        ArrayList<String> requestedHostTags = new ArrayList<String>();
        for (String tag : requestedTags) {
            if (!IP_SNITCHES.contains(tag)) continue;
            requestedHostTags.add(tag);
        }
        if (requestedHostTags.isEmpty()) {
            return;
        }
        String[] ipFragments = this.getIpFragments(solrNode);
        if (ipFragments == null) {
            return;
        }
        int ipSnitchCount = IP_SNITCHES.size();
        int i = 0;
        while (i < ipSnitchCount) {
            String currentTagValue = ipFragments[i];
            String currentTagKey = IP_SNITCHES.get(ipSnitchCount - i - 1);
            if (requestedHostTags.contains(currentTagKey)) {
                context.getTags().put(currentTagKey, currentTagValue);
            }
            ++i;
        }
    }

    private String[] getIpFragments(String solrNode) {
        String ip;
        String host;
        Matcher hostAndPortMatcher = hostAndPortPattern.matcher(solrNode);
        if (hostAndPortMatcher.find() && (host = hostAndPortMatcher.group(1)) != null && (ip = this.getHostIp(host)) != null) {
            return ip.split(HOST_FRAG_SEPARATOR_REGEX);
        }
        log.warn("Failed to match host IP address from node URL [{}] using regex [{}]", (Object)solrNode, (Object)hostAndPortPattern.pattern());
        return null;
    }

    public String getHostIp(String host) {
        try {
            InetAddress address = InetAddress.getByName(host);
            return address.getHostAddress();
        }
        catch (Exception e) {
            log.warn("Failed to get IP address from host [{}], with exception [{}] ", (Object)host, (Object)e);
            return null;
        }
    }
}

