/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.StringUtils;
import org.apache.solr.common.cloud.DefaultZkCredentialsProvider;
import org.apache.solr.common.cloud.ZkCredentialsProvider;

public class VMParamsSingleSetCredentialsDigestZkCredentialsProvider
extends DefaultZkCredentialsProvider {
    public static final String DEFAULT_DIGEST_FILE_VM_PARAM_NAME = "zkDigestCredentialsFile";
    public static final String DEFAULT_DIGEST_USERNAME_VM_PARAM_NAME = "zkDigestUsername";
    public static final String DEFAULT_DIGEST_PASSWORD_VM_PARAM_NAME = "zkDigestPassword";
    final String zkDigestUsernameVMParamName;
    final String zkDigestPasswordVMParamName;

    static Properties readCredentialsFile(String pathToFile) throws SolrException {
        Properties props = new Properties();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(pathToFile), StandardCharsets.UTF_8);){
                props.load(reader);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioExc) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)ioExc);
        }
        return props;
    }

    public VMParamsSingleSetCredentialsDigestZkCredentialsProvider() {
        this(DEFAULT_DIGEST_USERNAME_VM_PARAM_NAME, DEFAULT_DIGEST_PASSWORD_VM_PARAM_NAME);
    }

    public VMParamsSingleSetCredentialsDigestZkCredentialsProvider(String zkDigestUsernameVMParamName, String zkDigestPasswordVMParamName) {
        this.zkDigestUsernameVMParamName = zkDigestUsernameVMParamName;
        this.zkDigestPasswordVMParamName = zkDigestPasswordVMParamName;
    }

    @Override
    protected Collection<ZkCredentialsProvider.ZkCredentials> createCredentials() {
        ArrayList<ZkCredentialsProvider.ZkCredentials> result = new ArrayList<ZkCredentialsProvider.ZkCredentials>();
        String pathToFile = System.getProperty(DEFAULT_DIGEST_FILE_VM_PARAM_NAME);
        Properties props = pathToFile != null ? VMParamsSingleSetCredentialsDigestZkCredentialsProvider.readCredentialsFile(pathToFile) : System.getProperties();
        String digestUsername = props.getProperty(this.zkDigestUsernameVMParamName);
        String digestPassword = props.getProperty(this.zkDigestPasswordVMParamName);
        if (!StringUtils.isEmpty(digestUsername) && !StringUtils.isEmpty(digestPassword)) {
            result.add(new ZkCredentialsProvider.ZkCredentials("digest", (String.valueOf(digestUsername) + ":" + digestPassword).getBytes(StandardCharsets.UTF_8)));
        }
        return result;
    }
}

