/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.cloud.NodeStateProvider;
import org.apache.solr.client.solrj.routing.PreferenceRule;
import org.apache.solr.common.SolrCloseable;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.CommonTestInjection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodesSysPropsCacher
implements SolrCloseable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int NUM_RETRY = 5;
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    private final NodeStateProvider nodeStateProvider;
    private Map<String, String> additionalProps = CommonTestInjection.injectAdditionalProps();
    private final String currentNode;
    private final ConcurrentHashMap<String, Map<String, Object>> cache = new ConcurrentHashMap();
    private final AtomicInteger fetchCounting = new AtomicInteger(0);
    private volatile boolean isClosed;
    private volatile Collection<String> tags = new ArrayList<String>();

    public NodesSysPropsCacher(NodeStateProvider nodeStateProvider, String currentNode, ZkStateReader stateReader) {
        this.nodeStateProvider = nodeStateProvider;
        this.currentNode = currentNode;
        stateReader.registerClusterPropertiesListener(properties -> {
            Collection<String> tags = new ArrayList<String>();
            String shardPreferences = properties.getOrDefault("defaultShardPreferences", "");
            if (shardPreferences.contains("node.sysprop")) {
                try {
                    tags = PreferenceRule.from(shardPreferences).stream().filter(r -> "node.sysprop".equals(r.name)).map(r -> r.value).collect(Collectors.toSet());
                }
                catch (Exception e) {
                    log.info("Error on parsing shards preference:{}", (Object)shardPreferences);
                }
            }
            if (tags.isEmpty()) {
                this.pause();
            } else {
                this.start(tags);
                this.fetchSysProps(stateReader.getClusterState().getLiveNodes());
            }
            return this.isClosed;
        });
        stateReader.registerLiveNodesListener((oldLiveNodes, newLiveNodes) -> {
            this.fetchSysProps(newLiveNodes);
            return this.isClosed;
        });
    }

    private void start(Collection<String> tags) {
        if (this.isClosed) {
            return;
        }
        this.tags = tags;
        this.isRunning.set(true);
    }

    private void fetchSysProps(Set<String> newLiveNodes) {
        if (this.isRunning.get()) {
            int fetchRound = this.fetchCounting.incrementAndGet();
            this.cache.clear();
            for (String node : newLiveNodes) {
                if (this.isClosed && fetchRound != this.fetchCounting.get()) {
                    return;
                }
                if (this.currentNode.equals(node)) {
                    HashMap<String, String> props = new HashMap<String, String>();
                    for (String tag : this.tags) {
                        String propName = tag.substring("sysprop.".length());
                        if (this.additionalProps != null && this.additionalProps.containsKey(propName)) {
                            props.put(tag, this.additionalProps.get(propName));
                            continue;
                        }
                        props.put(tag, System.getProperty(propName));
                    }
                    this.cache.put(node, Collections.unmodifiableMap(props));
                    continue;
                }
                this.fetchRemoteProps(node, fetchRound);
            }
        }
    }

    private void fetchRemoteProps(String node, int fetchRound) {
        int i = 0;
        while (i < 5) {
            if (this.isClosed && fetchRound != this.fetchCounting.get()) {
                return;
            }
            try {
                Map<String, Object> props = this.nodeStateProvider.getNodeValues(node, this.tags);
                this.cache.put(node, Collections.unmodifiableMap(props));
                break;
            }
            catch (Exception e) {
                try {
                    int backOffTime = 1000 * (i + 1);
                    backOffTime *= backOffTime;
                    backOffTime = Math.min(10000, backOffTime);
                    Thread.sleep(backOffTime);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                    log.info("Exception on caching node:{} system.properties:{}, retry {}/{}", new Object[]{node, this.tags, i + 1, 5, e});
                    break;
                }
                log.info("Exception on caching node:{} system.properties:{}, retry {}/{}", new Object[]{node, this.tags, i + 1, 5, e});
                ++i;
            }
        }
    }

    public Map<String, Object> getSysProps(String node, Collection<String> tags) {
        Map<String, Object> props = this.cache.get(node);
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (props != null) {
            for (String tag : tags) {
                if (!props.containsKey(tag)) continue;
                result.put(tag, props.get(tag));
            }
        }
        return result;
    }

    public int getCacheSize() {
        return this.cache.size();
    }

    public boolean isRunning() {
        return this.isRunning.get();
    }

    private void pause() {
        this.isRunning.set(false);
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public void close() {
        this.isClosed = true;
        this.pause();
    }
}

