/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.TimeoutException;
import org.apache.solr.common.AlreadyClosedException;
import org.apache.solr.common.cloud.SolrZooKeeper;
import org.apache.solr.common.cloud.ZkClientConnectionStrategy;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConnectionStrategy
extends ZkClientConnectionStrategy {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    public void connect(String serverAddress, int timeout, Watcher watcher, ZkClientConnectionStrategy.ZkUpdate updater) throws IOException, InterruptedException, TimeoutException {
        SolrZooKeeper zk = this.createSolrZooKeeper(serverAddress, timeout, watcher);
        boolean success = false;
        try {
            updater.update(zk);
            success = true;
        }
        finally {
            if (!success) {
                zk.close();
            }
        }
    }

    @Override
    public void reconnect(String serverAddress, int zkClientTimeout, Watcher watcher, ZkClientConnectionStrategy.ZkUpdate updater) throws IOException, InterruptedException, TimeoutException {
        block12: {
            log.warn("Connection expired - starting a new one...");
            SolrZooKeeper zk = this.createSolrZooKeeper(serverAddress, zkClientTimeout, watcher);
            boolean success = false;
            try {
                try {
                    updater.update(zk);
                    success = true;
                    log.info("Reconnected to ZooKeeper");
                }
                catch (AlreadyClosedException alreadyClosedException) {
                    if (success) break block12;
                    try {
                        zk.close();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
            finally {
                if (!success) {
                    try {
                        zk.close();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
    }
}

