/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.routing;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.routing.PreferenceRule;
import org.apache.solr.client.solrj.routing.ReplicaListTransformer;
import org.apache.solr.client.solrj.routing.ReplicaListTransformerFactory;
import org.apache.solr.client.solrj.routing.RequestReplicaListTransformerGenerator;
import org.apache.solr.common.StringUtils;
import org.apache.solr.common.cloud.NodesSysPropsCacher;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.params.SolrParams;

public class NodePreferenceRulesComparator
implements Comparator<Object> {
    private final NodesSysPropsCacher sysPropsCache;
    private final String nodeName;
    private final List<PreferenceRule> sortRules;
    private final List<PreferenceRule> preferenceRules;
    private final String localHostAddress;
    private final ReplicaListTransformer baseReplicaListTransformer;
    private static final ReplicaListTransformer NOOP_RLT = choices -> {};
    private static final ReplicaListTransformerFactory NOOP_RLTF = (configSpec, requestParams, fallback) -> NOOP_RLT;

    public NodePreferenceRulesComparator(List<PreferenceRule> preferenceRules, SolrParams requestParams, ReplicaListTransformerFactory defaultRltFactory, ReplicaListTransformerFactory stableRltFactory) {
        this(preferenceRules, requestParams, null, null, null, defaultRltFactory, stableRltFactory);
    }

    public NodePreferenceRulesComparator(List<PreferenceRule> preferenceRules, SolrParams requestParams, String nodeName, String localHostAddress, NodesSysPropsCacher sysPropsCache, ReplicaListTransformerFactory defaultRltFactory, ReplicaListTransformerFactory stableRltFactory) {
        block11: {
            PreferenceRule lastRule;
            int maxIdx;
            block10: {
                this.sysPropsCache = sysPropsCache;
                this.preferenceRules = preferenceRules;
                this.nodeName = nodeName;
                this.localHostAddress = localHostAddress;
                maxIdx = preferenceRules.size() - 1;
                lastRule = preferenceRules.get(maxIdx);
                if ("replica.base".equals(lastRule.name)) break block10;
                this.sortRules = preferenceRules;
                this.baseReplicaListTransformer = defaultRltFactory.getInstance(null, requestParams, RequestReplicaListTransformerGenerator.RANDOM_RLTF);
                break block11;
            }
            this.sortRules = maxIdx == 0 ? null : preferenceRules.subList(0, maxIdx);
            String[] parts = lastRule.value.split(":", 2);
            switch (parts[0]) {
                case "random": {
                    this.baseReplicaListTransformer = RequestReplicaListTransformerGenerator.RANDOM_RLTF.getInstance(parts.length == 1 ? null : parts[1], requestParams, null);
                    break;
                }
                case "stable": {
                    this.baseReplicaListTransformer = stableRltFactory.getInstance(parts.length == 1 ? null : parts[1], requestParams, RequestReplicaListTransformerGenerator.RANDOM_RLTF);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid base replica order spec");
                }
            }
        }
    }

    NodePreferenceRulesComparator(List<PreferenceRule> sortRules, SolrParams requestParams) {
        this(sortRules, requestParams, NOOP_RLTF, null);
    }

    public ReplicaListTransformer getBaseReplicaListTransformer() {
        return this.baseReplicaListTransformer;
    }

    @Override
    public int compare(Object left, Object right) {
        block21: {
            if (this.sortRules == null) break block21;
            for (PreferenceRule preferenceRule : this.sortRules) {
                boolean lhs;
                if (lhs == (switch (preferenceRule.name) {
                    case "replica.type" -> {
                        lhs = NodePreferenceRulesComparator.hasReplicaType(left, preferenceRule.value);
                        yield NodePreferenceRulesComparator.hasReplicaType(right, preferenceRule.value);
                    }
                    case "replica.location" -> {
                        lhs = this.hasCoreUrlPrefix(left, preferenceRule.value);
                        yield this.hasCoreUrlPrefix(right, preferenceRule.value);
                    }
                    case "replica.leader" -> {
                        lhs = NodePreferenceRulesComparator.hasLeaderStatus(left, preferenceRule.value);
                        yield NodePreferenceRulesComparator.hasLeaderStatus(right, preferenceRule.value);
                    }
                    case "node.sysprop" -> {
                        if (this.sysPropsCache == null) {
                            throw new IllegalArgumentException("Unable to get the NodesSysPropsCacher on sorting replicas by preference:" + preferenceRule.value);
                        }
                        lhs = this.hasSameMetric(left, preferenceRule.value);
                        yield this.hasSameMetric(right, preferenceRule.value);
                    }
                    case "replica.base" -> throw new IllegalArgumentException("only one base replica order may be specified in shards.preference, and it must be specified last");
                    default -> throw new IllegalArgumentException("Invalid shards.preference type: " + preferenceRule.name);
                })) continue;
                return lhs ? -1 : 1;
            }
        }
        return 0;
    }

    private boolean hasSameMetric(Object o, String metricTag) {
        if (!(o instanceof Replica)) {
            return false;
        }
        List<String> tags = Collections.singletonList(metricTag);
        String otherNodeName = ((Replica)o).getNodeName();
        Map<String, Object> currentNodeMetric = this.sysPropsCache.getSysProps(this.nodeName, tags);
        Map<String, Object> otherNodeMetric = this.sysPropsCache.getSysProps(otherNodeName, tags);
        return currentNodeMetric.equals(otherNodeMetric);
    }

    private boolean hasCoreUrlPrefix(Object o, String prefix) {
        String s;
        if (o instanceof String) {
            s = (String)o;
        } else if (o instanceof Replica) {
            s = ((Replica)o).getCoreUrl();
        } else {
            return false;
        }
        if (prefix.equals("local")) {
            return !StringUtils.isEmpty(this.localHostAddress) && s.startsWith(this.localHostAddress);
        }
        return s.startsWith(prefix);
    }

    private static boolean hasReplicaType(Object o, String preferred) {
        if (!(o instanceof Replica)) {
            return false;
        }
        String s = ((Replica)o).getType().toString();
        return s.equalsIgnoreCase(preferred);
    }

    private static boolean hasLeaderStatus(Object o, String status) {
        if (!(o instanceof Replica)) {
            return false;
        }
        boolean leaderStatus = ((Replica)o).isLeader();
        return leaderStatus == Boolean.parseBoolean(status);
    }

    public List<PreferenceRule> getSortRules() {
        return this.sortRules;
    }

    public List<PreferenceRule> getPreferenceRules() {
        return this.preferenceRules;
    }
}

