/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.routing;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import org.apache.solr.client.solrj.routing.ReplicaListTransformer;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.Hash;

public class AffinityReplicaListTransformer
implements ReplicaListTransformer {
    private final int routingDividend;
    private static final Comparator<SortableChoice> SORTABLE_CHOICE_COMPARATOR = Comparator.comparing(o -> o.sortableCoreLabel);

    private AffinityReplicaListTransformer(String hashVal) {
        this.routingDividend = Math.abs(Hash.lookup3ycs(hashVal, 0, hashVal.length(), 0));
    }

    private AffinityReplicaListTransformer(int routingDividend) {
        this.routingDividend = routingDividend;
    }

    public static ReplicaListTransformer getInstance(String dividendParam, String hashParam, SolrParams requestParams) {
        String hashVal;
        Integer dividendVal;
        if (dividendParam != null && (dividendVal = requestParams.getInt(dividendParam)) != null) {
            return new AffinityReplicaListTransformer(dividendVal);
        }
        if (hashParam != null && (hashVal = requestParams.get(hashParam)) != null && !hashVal.isEmpty()) {
            return new AffinityReplicaListTransformer(hashVal);
        }
        return null;
    }

    @Override
    public void transform(List<?> choices) {
        int size = choices.size();
        if (size > 1) {
            int i = 0;
            SortableChoice[] sortableChoices = new SortableChoice[size];
            for (Object o : choices) {
                sortableChoices[i++] = new SortableChoice(o);
            }
            Arrays.sort(sortableChoices, SORTABLE_CHOICE_COMPARATOR);
            ListIterator<?> iter = choices.listIterator();
            i = this.routingDividend % size;
            int limit = i + size;
            do {
                iter.next();
                iter.set(sortableChoices[i % size].choice);
            } while (++i < limit);
        }
    }

    private static final class SortableChoice {
        private final Object choice;
        private final String sortableCoreLabel;

        private SortableChoice(Object choice) {
            this.choice = choice;
            if (choice instanceof Replica) {
                this.sortableCoreLabel = ((Replica)choice).getCoreUrl();
            } else if (choice instanceof String) {
                this.sortableCoreLabel = (String)choice;
            } else {
                throw new IllegalArgumentException("can't handle type " + choice.getClass());
            }
        }
    }
}

