/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import org.apache.commons.io.IOUtils;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.BinaryRequestWriter;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.JavaBinCodec;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.Pair;

public class MultiContentWriterRequest
extends AbstractUpdateRequest {
    private final Iterator<Pair<NamedList, Object>> payload;

    public MultiContentWriterRequest(SolrRequest.METHOD m, String path, Iterator<Pair<NamedList, Object>> payload) {
        super(m, path);
        this.params = new ModifiableSolrParams();
        this.params.add("multistream", "true");
        this.payload = payload;
    }

    @Override
    public RequestWriter.ContentWriter getContentWriter(String expectedType) {
        return new RequestWriter.ContentWriter(){

            @Override
            public void write(OutputStream os) throws IOException {
                new JavaBinCodec().marshal(iw -> {
                    while (MultiContentWriterRequest.this.payload.hasNext()) {
                        Pair<NamedList, Object> next = MultiContentWriterRequest.this.payload.next();
                        if (next.second() instanceof ByteBuffer || next.second() instanceof byte[]) {
                            NamedList params = next.first();
                            if (params.get("update.contentType") == null) {
                                String detectedType = MultiContentWriterRequest.detect(next.second());
                                if (detectedType == null) {
                                    throw new RuntimeException("Unknown content type");
                                }
                                params.add("update.contentType", detectedType);
                            }
                            iw.add(params);
                            iw.add(next.second());
                            continue;
                        }
                        throw new RuntimeException("payload value must be byte[] or ByteBuffer");
                    }
                }, os);
            }

            @Override
            public String getContentType() {
                return "application/javabin";
            }
        };
    }

    public static String detect(Object o) throws IOException {
        int ch;
        InputStreamReader rdr = null;
        byte[] bytes = null;
        if (o instanceof byte[]) {
            bytes = (byte[])o;
        } else if (o instanceof ByteBuffer) {
            bytes = ((ByteBuffer)o).array();
        }
        rdr = new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), StandardCharsets.UTF_8);
        String detectedContentType = null;
        while (Character.isWhitespace(ch = ((Reader)rdr).read())) {
        }
        int nextChar = -1;
        if (ch == 35 || ch == 47 && ((nextChar = ((Reader)rdr).read()) == 47 || nextChar == 42) || ch == 123 || ch == 91) {
            detectedContentType = "application/json";
        } else if (ch == 60) {
            detectedContentType = "text/xml";
        }
        return detectedContentType;
    }

    public static ByteBuffer readByteBuffer(InputStream is) throws IOException {
        BinaryRequestWriter.BAOS baos = new BinaryRequestWriter.BAOS();
        IOUtils.copy((InputStream)is, (OutputStream)baos);
        return ByteBuffer.wrap(baos.getbuf(), 0, baos.size());
    }
}

