/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.IsUpdateRequest;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.params.ModifiableSolrParams;

public abstract class AbstractUpdateRequest
extends SolrRequest<UpdateResponse>
implements IsUpdateRequest {
    protected ModifiableSolrParams params;
    protected int commitWithin = -1;

    public AbstractUpdateRequest(SolrRequest.METHOD m, String path) {
        super(m, path);
    }

    public AbstractUpdateRequest setAction(ACTION action, boolean waitFlush, boolean waitSearcher) {
        return this.setAction(action, waitFlush, waitSearcher, 1);
    }

    public AbstractUpdateRequest setAction(ACTION action, boolean waitFlush, boolean waitSearcher, boolean softCommit) {
        return this.setAction(action, waitFlush, waitSearcher, softCommit, 1);
    }

    public AbstractUpdateRequest setAction(ACTION action, boolean waitFlush, boolean waitSearcher, int maxSegments) {
        return this.setAction(action, waitFlush, waitSearcher, false, maxSegments);
    }

    public AbstractUpdateRequest setAction(ACTION action, boolean waitFlush, boolean waitSearcher, boolean softCommit, int maxSegments) {
        if (this.params == null) {
            this.params = new ModifiableSolrParams();
        }
        if (action == ACTION.OPTIMIZE) {
            this.params.set("optimize", "true");
            this.params.set("maxSegments", maxSegments);
        } else if (action == ACTION.COMMIT) {
            this.params.set("commit", "true");
            this.params.set("softCommit", String.valueOf(softCommit));
        }
        this.params.set("waitSearcher", String.valueOf(waitSearcher));
        return this;
    }

    public AbstractUpdateRequest setAction(ACTION action, boolean waitFlush, boolean waitSearcher, int maxSegments, boolean softCommit, boolean expungeDeletes) {
        this.setAction(action, waitFlush, waitSearcher, softCommit, maxSegments);
        this.params.set("expungeDeletes", String.valueOf(expungeDeletes));
        return this;
    }

    public AbstractUpdateRequest setAction(ACTION action, boolean waitFlush, boolean waitSearcher, int maxSegments, boolean expungeDeletes) {
        return this.setAction(action, waitFlush, waitSearcher, maxSegments, false, expungeDeletes);
    }

    public AbstractUpdateRequest setAction(ACTION action, boolean waitFlush, boolean waitSearcher, int maxSegments, boolean softCommit, boolean expungeDeletes, boolean openSearcher) {
        this.setAction(action, waitFlush, waitSearcher, maxSegments, softCommit, expungeDeletes);
        this.params.set("openSearcher", String.valueOf(openSearcher));
        return this;
    }

    public AbstractUpdateRequest rollback() {
        if (this.params == null) {
            this.params = new ModifiableSolrParams();
        }
        this.params.set("rollback", "true");
        return this;
    }

    public void setParam(String param, String value) {
        if (this.params == null) {
            this.params = new ModifiableSolrParams();
        }
        this.params.set(param, value);
    }

    public void setParams(ModifiableSolrParams params) {
        this.params = params;
    }

    @Override
    public ModifiableSolrParams getParams() {
        return this.params;
    }

    @Override
    protected UpdateResponse createResponse(SolrClient client) {
        return new UpdateResponse();
    }

    public boolean isWaitSearcher() {
        return this.params != null && this.params.getBool("waitSearcher", false);
    }

    public ACTION getAction() {
        if (this.params == null) {
            return null;
        }
        if (this.params.getBool("commit", false)) {
            return ACTION.COMMIT;
        }
        if (this.params.getBool("optimize", false)) {
            return ACTION.OPTIMIZE;
        }
        return null;
    }

    public void setWaitSearcher(boolean waitSearcher) {
        this.setParam("waitSearcher", String.valueOf(waitSearcher));
    }

    public int getCommitWithin() {
        return this.commitWithin;
    }

    public AbstractUpdateRequest setCommitWithin(int commitWithin) {
        this.commitWithin = commitWithin;
        return this;
    }

    public static enum ACTION {
        COMMIT,
        OPTIMIZE;

    }
}

