/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream.metrics;

import java.io.IOException;
import java.util.Locale;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.client.solrj.io.stream.metrics.Metric;

public class MinMetric
extends Metric {
    private long longMin = Long.MAX_VALUE;
    private double doubleMin = Double.MAX_VALUE;
    private String columnName;

    public MinMetric(String columnName) {
        this.init("min", columnName);
    }

    public MinMetric(StreamExpression expression, StreamFactory factory) throws IOException {
        String functionName = expression.getFunctionName();
        String columnName = factory.getValueOperand(expression, 0);
        if (columnName == null) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expected %s(columnName)", expression, functionName));
        }
        if (1 != expression.getParameters().size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - unknown operands found", expression));
        }
        this.init(functionName, columnName);
    }

    private void init(String functionName, String columnName) {
        this.columnName = columnName;
        this.setFunctionName(functionName);
        this.setIdentifier(functionName, "(", columnName, ")");
    }

    @Override
    public String[] getColumns() {
        return new String[]{this.columnName};
    }

    @Override
    public Number getValue() {
        if (this.longMin == Long.MAX_VALUE) {
            return this.doubleMin;
        }
        return this.longMin;
    }

    @Override
    public void update(Tuple tuple) {
        long l;
        Object o = tuple.get(this.columnName);
        if (o instanceof Double) {
            double d = (Double)o;
            if (d < this.doubleMin) {
                this.doubleMin = d;
            }
        } else if (o instanceof Float) {
            Float f = (Float)o;
            double d = f.doubleValue();
            if (d < this.doubleMin) {
                this.doubleMin = d;
            }
        } else if (o instanceof Integer) {
            Integer i = (Integer)o;
            long l2 = i.longValue();
            if (l2 < this.longMin) {
                this.longMin = l2;
            }
        } else if (o instanceof Long && (l = ((Long)o).longValue()) < this.longMin) {
            this.longMin = l;
        }
    }

    @Override
    public Metric newInstance() {
        return new MinMetric(this.columnName);
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        return new StreamExpression(this.getFunctionName()).withParameter(this.columnName);
    }
}

